function leafNames = initializeThePlot(treeFileName)
    
    if isequal(treeFileName(end-3:end), '.tre')
        
        % Plot the tree
        tr = phytreeread(treeFileName);
        tr = reroot(tr);
        leafNames = get(tr,'LeafNames');
        
        h = plot(tr, 'TerminalLabels', 'false', 'LeafLabels', 'false');
        set(h.BranchDots, 'Marker', 'none');
        set(h.LeafDots, 'Marker', 'none');
        set(h.axes, 'YTick', []);
        set(gcf,'Position',[709 80 770 840]);
        
    elseif isequal(treeFileName(end-3:end), '.txt')
        
        leafNames = cell(30000,1);
        nNames = 0;
        fid = fopen(treeFileName);
        
        line = fgetl(fid);
        while ischar(line)
            nNames = nNames + 1;
            leafNames{nNames} = line;
            line = fgetl(fid);
        end
        leafNames = leafNames(nNames:-1:1);
        % This needs to be reversed, because the Y-axis is also reversed.
        nStrains = length(leafNames);
        axes;
        set(gca,'XLim', [-0.05 1.2], 'YLim', [-nStrains.*0.05, nStrains.*1.05], 'YDir', 'reverse');
        
    end
    
end