close('all');

sys = computer;
if isequal(sys(1:2),'PC')
    dataRoot = '.\data3_many\';
else
    dataRoot = './data3_many/';
end
inputFile = [dataRoot 'alignment-rec.fa'];
outputFile = [dataRoot 'data3_many_res.mat'];
inputSpecsFile = 'fG_input_specs.txt';
fileWithOrderingOfStrains = [dataRoot 'data3_order_to_plot.txt'];

setFgPaths;
fastGEAR(inputFile, outputFile, inputSpecsFile);

% Plot recent recombinations, order by cluster label.
%plotRecombinations(outputFile, outputDir, 1, 2);

% Plot recent recombinations, sort according to original order.
plotRecombinations(outputFile, 1, 1); h1 = gcf;
set(h1, 'Name', 'Recent');

% Plot ancestral recombinations, sort accorging to the ordering specified
% in the file
plotRecombinations(outputFile, 2, fileWithOrderingOfStrains); h2 = gcf;
set(h2, 'Name', 'Ancestral')

% For reference, show lineage colors
plotColors([], outputFile);