function h = plotPopStructure(partition,popStructure, ...
    orderToShow, totalSequenceLength, snpPositions, sequenceTickValues, ...
    missingnessTable, cmap, minMissingLength, nClusters)
% If partition is a scalar, then it specifies the number of cluster, and
% the clusters are not drawn.
if nargin==6
    missingnessTable = [];
    cmap = [];
    minMissingLength = 0;
    nClusters = [];
elseif nargin==7
    cmap = [];
    minMissingLength = 0;
    nClusters = [];
elseif nargin==8
    minMissingLength = 0;
    nClusters = [];
elseif nargin==9
    nClusters = [];
end

h = figure;
hold on;
nStrains = length(orderToShow);

% Modify axes so that profiles can be plotted:

set(gca,'XLim', [0 totalSequenceLength*1.05]./totalSequenceLength);
set(gca, 'Ylim', [0.5 nStrains+0.5]);

% Add new tick labels specifying sequence position:
newXTickLabels = cell(1,length(sequenceTickValues));
for i=1:length(sequenceTickValues)
    newXTickLabels{i} = [num2str(sequenceTickValues(i)./1000000) 'Mb'];
end
set(gca, 'XTick', sequenceTickValues./totalSequenceLength);
set(gca, 'XTickLabel', newXTickLabels);


if isempty(nClusters)
    nClusters = length(unique(partition));
end

if isempty(cmap)
    %cmap = hsv(double(nClusters));
    %cmap = lines(nClusters);
    %cmap(nClusters,:) = [1 1 1]; % White color for the largest cluster!
    colors = distinguishable_colors(nClusters);
    %colors(:,4) = 0.5;
    cmap = colors(end:-1:1,:);
    cmap = brighten(cmap, 0.5);
    
    cmap(nClusters+1,:) = [0 0 0]; % Black color for the empty cluster.
    cmap(nClusters+2,:) = [1 1 1]; % White color for recent recombinations (or missing elements in general)
end


% DRAW SEGMENTS:
for strainIndex = 1:size(popStructure,1)
    segments = identifySegments(popStructure, strainIndex, snpPositions, totalSequenceLength);
    nSegments = size(segments,1);
    yPos = find(orderToShow==strainIndex);
    for segmentIndex = 1:nSegments
        x = segments(segmentIndex,[1 2])./totalSequenceLength;
        origin = segments(segmentIndex,3);
        color = cmap(origin,:);
        patch([x(1) x(2) x(2) x(1)], [yPos+0.5 yPos+0.5 yPos-0.5 yPos-0.5],color,'EdgeColor','none');
    end
    if ~isempty(missingnessTable)
        segments = identifySegments(missingnessTable, strainIndex, snpPositions, totalSequenceLength);
        segments = segments(segments(:,3)==1,:);  % Those segments which were missing.
        segmentLengths = segments(:,2)-segments(:,1);
        sufficientlyLong = find(segmentLengths > minMissingLength);
        segments = segments(sufficientlyLong,:);
        nSegments = size(segments,1);
        for segmentIndex = 1:nSegments
            x = segments(segmentIndex,[1 2])./totalSequenceLength;
            patch([x(1) x(2) x(2) x(1)], [yPos+0.5 yPos+0.5 yPos-0.5 yPos-0.5],[0.8 0.8 0.8],'EdgeColor',[0.8 0.8 0.8]);
        end
    end
end


% DRAW CLUSTERS:
if ~isempty(partition)
    orderedPartition = zeros(length(orderToShow),1);
    orderedPartition(orderToShow ~= 0) = partition(orderToShow(orderToShow ~= 0));
    
    %Show clusters only if more than one cluster
    for i=1:length(unique(partition))
        strainsInCluster = find(orderedPartition==i);
        x1 = 1.03;%(totalSequenceLength+20000)/totalSequenceLength;
        x2 = 1.05;%(totalSequenceLength+55000)/totalSequenceLength;
        
        for strainIndex = strainsInCluster'
            patch([x1 x2 x2 x1],...
                [(strainIndex-0.5)*ones(1,2) (strainIndex+0.5)*ones(1,2)], ...
                cmap(i,:), 'EdgeColor','none');
        end
    end
end
line([1 1],get(gca,'YLim'), 'LineWidth', 1.5, 'Color', 'black');

set(gcf,'Position', [479 162 822 842]);
