function plotMarginals(snpPositions, marginals, donorLineage)
% Plot marginal distributions.
%
% "snpPositions" is expected to be row vector and "marginals" nStates*nSnps
% array.

figure;

%colors = [lines(size(marginals,1)-1); 0 0 0];
%colors = [hsv(size(marginals,1)-1)];
%colors(end,:) = [1 1 1];
%colors(end+1,:) = [0 0 0];

nClusters = size(marginals,1)-1; % The last row is for the empty cluster.
colors = distinguishable_colors(nClusters);
cmap = colors(end:-1:1,:);
%cmap(nClusters+1,:) = [1 1 1]; % Black color for the empty cluster.

cmap(nClusters+1,:) = [0 0 0]; % Black color for the empty cluster.
cmap(nClusters+2,:) = [1 1 1]; % White color for recent recombinations (or missing elements in general)

if donorLineage == 0
    h = area(snpPositions', marginals');
    
    for i=1:nClusters+1
        set(h(i),'FaceColor',cmap(i,:));
    end
else
    h = area(snpPositions', marginals(donorLineage,:));
    set(h(1), 'FaceColor', cmap(donorLineage,:));
end

set(gca,'YLim',[0,1]);
pos = get(gcf,'Position');
pos([3 4]) = [800 250];
set(gcf,'Position', pos);