function plotColors(nClusters, outputFile)
    
    if ~isnumeric(nClusters)
        nClusters = str2double(nClusters);
    end
    
    if nargin == 2
        load(outputFile); % uData
        nClusters = max(uData.groupedPartition);
    end
    
    %colors = hsv(nClusters);
    colors = distinguishable_colors(nClusters);
    cmap = colors(end:-1:1,:);
    %cmap(nClusters+1,:) = [1 1 1]; % Black color for the empty cluster.
    
    cmap(nClusters+1,:) = [0 0 0]; % Black color for the empty cluster.
    cmap(nClusters+2,:) = [1 1 1]; % White color for recent recombinations (or missing elements in general)
    
    cmap = brighten(cmap, 0.5);
    
    figure
    set(gca,'XLim',[0 nClusters+3], 'YLim', [0 1]);
    
    currentPosition = get(gcf, 'Position');
    newPosition = currentPosition;
    newPosition(4) = 150;
    set(gcf, 'Position', newPosition);
    
    for x = 1 : nClusters + 2
        patch([x-0.5 x+0.5 x+0.5 x-0.5], [0 0 1 1], cmap(x,:));
    end
end