function c = updateCounts(c, strain, newStates, oldStates)
% The function updates COUNTS and SUMCOUNTS in "c", when "strain" has been
% updated. The old and new cluster assignments of the strain have been
% provided "newStates", "oldStates".

changedLoci = find(newStates ~= oldStates & c.data(strain,:)>0);
observations = c.data(strain,changedLoci);

countsIndices = sub2ind(size(c.COUNTS), observations, changedLoci, oldStates(changedLoci));
c.COUNTS(countsIndices) = c.COUNTS(countsIndices) - 1;

countsIndices = sub2ind(size(c.COUNTS), observations, changedLoci, newStates(changedLoci));
c.COUNTS(countsIndices) = c.COUNTS(countsIndices) + 1;

sumCountsIndices = sub2ind(size(c.SUMCOUNTS), oldStates(changedLoci), changedLoci);
c.SUMCOUNTS(sumCountsIndices) = c.SUMCOUNTS(sumCountsIndices) - 1;

sumCountsIndices = sub2ind(size(c.SUMCOUNTS), newStates(changedLoci), changedLoci);
c.SUMCOUNTS(sumCountsIndices) = c.SUMCOUNTS(sumCountsIndices) + 1;