function uData = inspectClusterRelationships(inputFile, outputDir, analyseLineages)
    
    load(inputFile);  % Variable uData
    
    % Reorder cluster labels such that the smallest cluster has label 1 and
    % so on.
    uData = reorderClusterLabels(uData);
    
    load(uData.snpDataFileName); % snpData
    
    if analyseLineages
        % Mark as missing all recent recombinations
        nSnps = length(uData.snpPositions);
        structureWithoutRecentRecombinations = uint8(repmat(uData.groupedPartition, [1 nSnps]));
        recentRecombinationInds = find(structureWithoutRecentRecombinations ~= uData.updatedPopStructure);
        snpData(recentRecombinationInds) = 0;
        
        nClusters = max(uData.groupedPartition);
        c = createBapsOutputStruct(uData.groupedPartition,snpData, ...
            uData.snpPositions, nClusters, [], []);
        
    else
        
        nClusters = max(uData.partition);
        c = createBapsOutputStruct(uData.partition,snpData, ...
            uData.snpPositions, nClusters, [], []);
    end
    
    % Note, no empty cluster included here. If some cluster is different
    % from all other clusters, then it just is in its own cluster.
    
    phi = uData.priorProbOfNoBreaks;
    
    %disp(['phi=' num2str(phi)]);
    
    preCalculatedTransMatrices = preCalculateTransMatrices(uData.totalSequenceLength, phi, 2, c.snpPositions, 0);
    
    allPairwiseMarginals = cell(nClusters,nClusters);
    
    for cluster1 = 1:nClusters-1
        for cluster2 = cluster1+1:nClusters
            
            [marginals, ~, ~] = hmmRecombinationAnalysis(c, preCalculatedTransMatrices, [], [cluster1 cluster2]);
            
            allPairwiseMarginals{cluster1,cluster2} = marginals;
            
        end
    end
    
    if analyseLineages
        prefix = 'lineage_comparison';
    else
        prefix = 'cluster_comparison';
    end
    
    save([outputDir uData.delimiter prefix '.mat'], 'allPairwiseMarginals');
    
end




function uData = reorderClusterLabels(uData)
    
    nClusters = length(unique(uData.partition));
    
    clusterSizes = zeros(nClusters,1);
    for clusterIndex = 1:nClusters
        clusterSizes(clusterIndex) = length(find(uData.partition==clusterIndex));
    end
    aux = [(1:nClusters)' clusterSizes];
    aux = sortrows(aux, 2);
    orderedClusters = aux(:,1);

    newPartition = zeros(length(uData.partition), 1);
    for clusterIndex = 1:nClusters
        strainsNow = find(uData.partition==orderedClusters(clusterIndex));
        newPartition(strainsNow) = clusterIndex;
    end   
    uData.partition = newPartition;
    
end
