function segments = identifySegments(popStructure, strain, snpPositions, totalSequenceLength)
% The function goes through the popStructure and identifies the segments
% the the specified strain.
%
% segments is a nSegments*3 array, where the first column is the starting
% point of the segment, second column is the end point of the segment, and
% the third column is the origin of the segment.

nStrains = size(popStructure,1);
segments = zeros(10,3);
if length(snpPositions)<2
    segments = zeros(0,3);
    return
end
nSegments = 0;

popStructureStrain = double(popStructure(strain,:));

breakPoints = find(popStructureStrain(2:end)-popStructureStrain(1:end-1) ~= 0);
% If breakPoints contains value k, then it means that between SNPs k and
% k+1 there is a breakpoint.

for i=1:length(breakPoints)
    % Add segment which ends at breakPoint(i):
    nSegments = nSegments+1;
    if nSegments>size(segments,1)
        segments = [segments; zeros(size(segments))];
    end
    
    if i==1
        starting = 1;
        origin = popStructureStrain(1);
    else
        starting = ...
            floor((snpPositions(breakPoints(i-1))+snpPositions(breakPoints(i-1)+1))/2)+1;
        origin = popStructureStrain( breakPoints(i));
    end
    
    ending = floor((snpPositions(breakPoints(i))+snpPositions(breakPoints(i)+1))/2);
    
    segments(i,:) = [starting ending origin];
end

nSegments = nSegments+1;
if isempty(breakPoints)
    segments(nSegments,:) = [1 totalSequenceLength popStructureStrain(1)];
else
    segments(nSegments,:) = ...
        [floor((snpPositions(breakPoints(end))+snpPositions(breakPoints(end)+1))/2)+1 ...
        totalSequenceLength popStructureStrain(end)];
end

segments = segments(1:nSegments,:);