function uData = createClusterGroups(uData)

    nClusters = size(uData.clusterDist,1);
    distElems = uData.clusterDist(find(tril(ones(nClusters),-1)))';
    clusterZ = linkage(distElems, 'complete');
    %dendrogram(clusterZ);
    clusterGroups = cluster(clusterZ, 'cutoff', 0.5, 'criterion', 'distance');
    uData.clusterGroups = clusterGroups;
    uData.groupedPartition = uData.clusterGroups(uData.partition);
    
    uData = reorderClusterGroups(uData);
    disp([' Number of lineages detected: ' num2str(length(unique(uData.groupedPartition)))]);    
    
end


function uData = reorderClusterGroups(uData)
    % Orders cluster groups s.t. the largest cluster group (i.e. lineage)
    % has most strains in it.
    
    nLineages = length(unique(uData.groupedPartition));
    
    lineageSizes = zeros(nLineages,1);
    for lineageIndex = 1:nLineages
        lineageSizes(lineageIndex) = length(find(uData.groupedPartition==lineageIndex));
    end
    aux = [(1:nLineages)' lineageSizes];
    aux = sortrows(aux, 2);
    orderedLineages = aux(:,1);
    
    newPartition = zeros(length(uData.groupedPartition), 1);
    clusterPartition = zeros(length(uData.clusterGroups), 1);
    for lineageIndex = 1:nLineages
        newPartition(uData.groupedPartition==orderedLineages(lineageIndex)) = lineageIndex;
        
        clusterPartition(uData.clusterGroups==orderedLineages(lineageIndex)) = lineageIndex;
    end
    
    uData.groupedPartition = newPartition;
    uData.clusterGroups = clusterPartition;
    
end