function c = createBapsOutputStruct(partition, snpData, snpPositions, nClusters, partitionArray, blockWidth, alpha)
% If partitionArray and blockWidth are both equal to [], then COUNTS and
% SUMCOUNTS will be created on the basis of observations divided into
% clusters as in "partition".
% 
% If "blockWidth" is  [], but "partitionArray" is non-empty, then 
% partitionArray variable contains actually "popStructure", which specifies 
% how to divide observations to different clusters. The size of
% "popStructure" is equal to the size of "snpData".
% 
% If neither of "partitionArray" or "blockWidth" is equal to [], then 
% COUNTS and SUMCOUNTS will be created on the basis of origins of the 
% observations as dictated by "partitionArray".
%
% If "nClusters" is larger than the different number of clusters in
% a) "partition" b) "partitionArray", then the function adds as many empty 
% clusters to "COUNTS" and "SUMCOUNTS", as needed.

if nargin==6
    alpha = 1;
end

c.PARTITION = partition;
c.npops = length(unique(c.PARTITION));   % The number of non-empty clusters.
[c.data c.noalle] = relabelCodes(snpData);  clear snpData;

%if any(c.noalle==1)
%    error('SNP with only a single value.');
%end

c.snpPositions = snpPositions;
if isempty(partitionArray) && isempty(blockWidth)
    % Form COUNTS using partition.
    [c.SUMCOUNTS, c.COUNTS] = initialCounts(c.PARTITION, c.data, c.npops, c.noalle);
elseif isempty(blockWidth)
    % partitionArray specifies population structure. Use this to calculate
    % COUNTS.
    popStructure = partitionArray;  clear partitionArray;
    [c.SUMCOUNTS, c.COUNTS] = initialCountsWithPopStructure(popStructure, c.data, c.noalle);
else
    % Use partitionArray and blockWidth when calculating COUNTS.
    [c.SUMCOUNTS, c.COUNTS] = initialCountsWithOrigins(partitionArray, blockWidth, c.data, c.noalle, snpPositions);
end
    
[c.adjprior, c.priorTerm] = calculatePriorTerms(c, alpha);

nEmptyClusters = nClusters - size(c.COUNTS,3);
if nEmptyClusters>0
    c.COUNTS = cat(3,c.COUNTS, zeros(size(c.COUNTS,1),size(c.COUNTS,2),nEmptyClusters)); % Empty clusters added.
    c.SUMCOUNTS = [c.SUMCOUNTS; zeros(nEmptyClusters,size(c.SUMCOUNTS,2))];  % Empty clusters added.
end


%---------------------------------------------------

function [sumcounts, counts] = initialCounts(partition, data, npops, noalle)

nloci=size(data,2);

counts = zeros(max(noalle),nloci,npops);
sumcounts = zeros(npops,nloci);
for i=1:npops
    for j=1:nloci
        havainnotLokuksessa = find(partition==i & data(:,j)>0);
        sumcounts(i,j) = length(havainnotLokuksessa);
        for k=1:noalle(j)
            alleleCode = k;
            N_ijk = length(find(data(havainnotLokuksessa,j)==alleleCode));
            counts(k,j,i) = N_ijk;
        end
    end
end


function [sumCounts, counts] = initialCountsWithOrigins(partitionArray, blockWidth, snpData, noalle, snpPositions)

nSnps = size(snpData,2);
nPops = max(max(partitionArray));   % largest cluster index in any interval

nIntervals = size(partitionArray,2);
counts = zeros(max(noalle),nSnps, nPops);
sumCounts = zeros(nPops,nSnps);

for i = 1:nIntervals
    intervalFirstSite = (i-1)*blockWidth+1;
    intervalLastSite = i*blockWidth;
    snpsInInterval = find(snpPositions>=intervalFirstSite & snpPositions<=intervalLastSite);
    if ~isempty(snpsInInterval)
        dataInInterval = snpData(:,snpsInInterval);
        noalleInInterval = noalle(1,snpsInInterval);
        [sumcountsInInterval, countsInInterval] = initialCounts(partitionArray(:,i), dataInInterval, nPops, noalleInInterval);
        diff = max(noalle)-max(noalleInInterval);
        if diff>0
            countsInInterval = cat(1, countsInInterval, zeros(diff,length(snpsInInterval),nPops));
        end
        counts(:,snpsInInterval,:) = countsInInterval;
        sumCounts(:,snpsInInterval) = sumcountsInInterval;
    end
end


function [sumCounts, counts] = initialCountsWithPopStructure(popStructure, snpData, noalle)
nSnps = size(snpData,2);
nPops = max(max(popStructure));

counts = zeros(max(noalle),nSnps,nPops);
sumCounts = zeros(nPops,nSnps);

for j=1:nSnps
    for i=1:nPops
        observations = find(popStructure(:,j)==i & snpData(:,j)>0);
        sumCounts(i,j) = length(observations);
        for k=1:noalle(j)
            alleleCode = k;
            N_ijk = length(find(snpData(observations,j)==alleleCode));
            counts(k,j,i) = N_ijk;
        end
    end
end