function diffInCounts = computeDiffInCounts(rows, maxNoalle, nLoci, data)
% Forms maxNoalle*nloci array, with counts of alleles that are on "rows" in
% "data". "rows" must be a row vector.

diffInCounts = zeros(maxNoalle, nLoci);
for i=rows
    row = double(data(i,:));
    notEmpty = find(row > 0);
    
    if length(notEmpty)>0
        diffInCounts(row(notEmpty) + (notEmpty-1)*maxNoalle) = ...
            diffInCounts(row(notEmpty) + (notEmpty-1)*maxNoalle) + 1;
    end
end
