function checkCountsClusterStructureCompatibility(c, clusterStructure, clusterIndex)
    % 'clusterStructure' is the structure for just this one cluster.
    
    strainsInCluster = find(c.PARTITION == clusterIndex);
    
    nSnps = size(c.COUNTS,2);
    
    nAlleles = size(c.COUNTS,1);
    
    checkedCounts = zeros(nAlleles,nSnps);
    
    for snpIndex = 1:nSnps
        
        observations = c.data(strainsInCluster(clusterStructure(:,snpIndex) == clusterIndex), snpIndex);
        
        allelesPresent = unique(observations);
        allelesPresent = setdiff(allelesPresent,0);
        alleleCounts = histc(observations, allelesPresent);
        
        checkedCounts(allelesPresent,snpIndex) = alleleCounts;
        
    end
    
    if ~isequal(checkedCounts, c.COUNTS(:,:,clusterIndex))
        disp('Error 4');
        keyboard
    else
        disp('All ok');
    end
    
end