function [partitionFile, nIterations, nClustList, runAllUpperBounds, reducedOutput] = getSpecifications(inputSpecsFile)
% "inputSpecsFile" is a text file that contains input specifications for
% the program. This function reads the required parameters from the file.

fid = fopen(inputSpecsFile);

line = fgetl(fid);
bb = find(line=='#');
nIterations = str2num(line(1:bb(1)-1));

line = fgetl(fid);
bb = find(line=='#');
nClustList = str2num(line(1:bb(1)-1));

line = fgetl(fid);
bb = find(line=='#');
runAllUpperBounds = str2num(line(1:bb(1)-1));

line = fgetl(fid);
bb = find(line=='#');
partitionFile = line(1:bb(1)-1);
% Remove spaces (Note: the file name may not contain spaces)
toRemove = find(partitionFile == ' ');
partitionFile(toRemove) = [];

line = fgetl(fid);
bb = find(line=='#');
reducedOutput = str2num(line(1:bb(1)-1));

fclose(fid);