function writeRecombinationsToTextFile(inputFile, outputFile, type)
% type = 1 (recent), 2 (lineage-level), 3 (cluster-level),
% 4 (lineage-level, not cleaned), 5 (cluster-level, not cleaned)

load(inputFile); % Loads variable uData

outputId = fopen(outputFile,'w');

if length(uData.snpPositions) == 1
    uData.popStructureCleaned = [];
    uData.lineageAncestralLogBf = [];
    uData.lineageStructureCleaned = [];
    % Add something so that the following lines don't crash. Note that if
    % there's only one SNP, then the analysis is stopped after reading in
    % data.
end

if type == 1
    popStructure = uData.popStructureCleaned;
    headerEnd = 'STRAINS';
    firstRow = 'DonorLineage    RecipientStrain  log(BF)    StrainName';
elseif type == 2
    popStructure = uData.lineageStructureCleaned;
    logBf = uData.lineageAncestralLogBf;
    headerEnd = 'LINEAGES';
    %firstRow = 'DonorLineage    RecipientLineage log(BF)';
    firstRow = 'Lineage1        Lineage2         log(BF)';
elseif type == 3
    popStructure = uData.clusterStructureCleaned;
    logBf = uData.clusterAncestralLogBf;
    headerEnd = 'CLUSTERS';
    %firstRow = 'DonorCluster    RecipientCluster log(BF)';
    firstRow = 'Cluster1        Cluster2         log(BF)';
elseif type == 4
    popStructure = uData.lineageStructure;
    logBf = uData.lineageAncestralLogBf;
    headerEnd = 'LINEAGES (SIGNIFICANCE NOT CHECKED)';
    %firstRow = 'DonorLineage    RecipientLineage log(BF)';
    firstRow = 'Lineage1        Lineage2 log(BF)';
elseif type == 5
    popStructure = uData.clusterStructure;
    logBf = uData.clusterAncestralLogBf;
    headerEnd = 'CLUSTERS (SIGNIFICANCE NOT CHECKED)';
    %firstRow = 'DonorCluster    RecipientCluster log(BF)';
    firstRow = 'Cluster1        Cluster2         log(BF)';
end

if type ~= 1
    header = ['RECOMBINATIONS IN ' headerEnd];
else
    if length(uData.snpPositions) == 1
        res.nRecent = 0;
    else
        res = countRecentRecombinations(uData);
    end
    header = [num2str(res.nRecent) ' RECENT RECOMBINATION EVENTS'];
end
firstRow = ['Start     End       ', firstRow];

% Print the top row only if a new file was created:
fprintf(outputId, '%s\n', header);
fprintf(outputId, '%s\n',firstRow);

if length(uData.snpPositions) == 1
    return
end

nRows = size(popStructure,1);

for rowIndex=1:nRows
    
    segments = identifySegments(popStructure, rowIndex, ...
        uData.snpPositions, uData.totalSequenceLength);
    
    if type == 1 
        % For strains, the home cluster is the lineage to which the strain
        % belongs.
        homeCluster = uData.groupedPartition(rowIndex);
    else
        homeCluster = rowIndex;
    end
    segments(segments(:,3)==homeCluster,:) = [];   % Remove home segments.
    nSegments = size(segments,1);
    
    if nSegments>0
        table = segments;
        table(:,end+1) = rowIndex;
        if type == 1
            % Add the name of the strain to the end.
            table = [table uData.recentRecombinationSignificances{rowIndex}];
            addToEnd = uData.strainLabels{rowIndex};
            fprintf(outputId, ['%-10.0f%-10.0f%-16.0f%-17.0f%-11.1f' addToEnd '\n'], table');
        else
            if nSegments ~= length(logBf{rowIndex})
                error('ERROR: Incorrect number of significance scores.')
            end
            addToEnd = logBf{rowIndex};
            table = [table, addToEnd];
            
%             % Remove rows with logBF below the threshold.
%             toRemove = find(addToEnd<uData.ancestralLogBfThreshold);
%             if ~isempty(toRemove)
%                 table(toRemove,:) = [];
%             end
            
            fprintf(outputId,'%-10.0f%-10.0f%-16.0f%-17.0f%-10.1f\n',table');
        end
        
    end
end
if outputId~=1
    fclose(outputId);
end
