function plotMarginalsForStrain(outputFile, strainIndex, donorLineage)
    % 'strainIndex' is the index of the strain for which the marginal
    % probabilities will be plotted.
    %
    % 'donorLineage': if the user wants to get the probabilities for a
    % particular lineage, the lineage can be given as an argument. If
    % donorLineage==0, then all lineages will be plotted.
    
    load(outputFile); % uData
    
    outputDir = inferOutputDir(outputFile);
    
    if ~isnumeric(strainIndex)
        strainIndex = str2double(strainIndex);
    end
    
    if ~isnumeric(donorLineage)
        donorLineage = str2double(donorLineage);
    end
    
    
    sysName = computer;
    if (isequal(sysName(1:2),'PC')) % Windows
        delimiter = '\';
    else
        delimiter = '/';
    end
    
    marginalsFile = [outputDir delimiter 'strain_' num2str(strainIndex) '.mat'];
    
    load(marginalsFile);
    
    plotMarginals(uData.snpPositions, marginals, donorLineage);
    
end