function newPartition = reorderClusterLabels(partition)
    
    nClusters = length(unique(partition));
    
    clusterSizes = zeros(nClusters,1);
    for clusterIndex = 1:nClusters
        clusterSizes(clusterIndex) = length(find(partition==clusterIndex));
    end
    aux = [(1:nClusters)' clusterSizes];
    aux = sortrows(aux, 2);
    orderedClusters = aux(:,1);

    newPartition = zeros(length(partition), 1);
    for clusterIndex = 1:nClusters
        strainsNow = find(partition==orderedClusters(clusterIndex));
        newPartition(strainsNow) = clusterIndex;
    end
    
end