#!/usr/bin/env ruby
require 'fileutils'
require 'optparse'

class Result
  attr_reader :exitstatus, :depth
  def initialize dir
    @dir=dir
    @exitstatus=Integer(self.prop "exitstatus")
    @time=Float(self.prop("time").match(/user (\d+(\.\d+))/)[1])
    @t=(self.prop("out.log").match(/is true/) and true)
    @f=(self.prop("out.log").match(/is false/) and true)
    @safe=(not self.prop("err.log").match(/not a syntactical safety property/))
  end
  def prop label
    f=File.new(File.join @dir, label)
    s=f.read
    f.close
    return s
  end
  def timeout?
    self.exitstatus == 152
  end
  def memout?
    self.exitstatus != 0 and not self.timeout?
  end
  def true?
    @t
  end
  def false?
    @f
  end
  def safe?
    @safe
  end
  def time
    if self.timeout?
      $timeout
    else
      if self.memout?
        $memout
      else
        if @time<$origin
          $origin
        else
          @time
        end
      end
    end
  end
  def name
    @dir
  end
end

$origin=0.01
$timeout=120.0
$reverse=false
OptionParser.new do |opts|
  opts.on "--timeout TIMEOUT" do |o|
    $timeout=Float(o)
  end
  opts.on "--reverse" do
    $reverse=true
  end
end.parse!
$memout=10**((Math.log10($timeout)-(Math.log10($origin)))/0.95+
             Math.log10($origin))
$range=10**((Math.log10($timeout)-(Math.log10($origin)))/0.9+
            Math.log10($origin))

for arg in ARGV
  impls=[]
  names=[]
  for impl in Dir[File.join arg, "*"].sort
    impls << Hash.new
    names << File.split(impl)[1]
    for result in Dir[File.join impl, "*"]
      res=Result.new(result)
      impls[-1][File.split(result)[1]]=res
    end
  end

  data_true=open("data_true","w")
  data_false=open("data_false","w")
  for k in impls[-1].keys
    data_line=""
    for impl in impls
      data_line << impl[k].time.to_s + " "
    end
    data_line << "\n"
    if (impls.map {|i| i[k].false?}).reduce(false) {|a,b| a or b} # if at least someone found a counter-example
      data_false.write data_line
    else
      data_true.write data_line
    end
  end
  data_true.close
  data_false.close

  sets="1:2"
  if $reverse
    sets="2:1"
    names[1],names[0]=names[0],names[1]
  end

  plot=IO.popen "gnuplot", "w+"
  plot.write <<-PLOT
set out "#{arg}.png"
set terminal png
set log
set autoscale
set size square
set xrange [#{$origin}:#{$range}]
set yrange [#{$origin}:#{$range}]
set xlabel "#{names[0]}"
set ylabel "#{names[1]}"
set arrow from #{$origin},#{$origin} to #{$range},#{$range} nohead
set arrow from #{$origin},#{$timeout} to #{$range},#{$timeout} nohead
set arrow from #{$timeout},#{$origin} to #{$timeout},#{$range} nohead
set arrow from #{$origin},#{$memout} to #{$range},#{$memout} nohead
set arrow from #{$memout},#{$origin} to #{$memout},#{$range} nohead
plot "data_true" using #{sets} title "True" with points lt rgb "blue" pt 4, "data_false" using #{sets} title "False" with points lt rgb "red" pt 1
quit
PLOT
  plot.close

  FileUtils.remove ["data_true", "data_false"]
end
