#!/usr/bin/env python
from random import seed, choice, randint
from optparse import OptionParser

class Node(object):
  sere=("union", "intersection", "intersection+", "concatenation", "fusion", "repetition")
  prop=("tail implication", "tail conjunction", "negation", "conjunction", "disjunction", "next", "until", "releases")
  allowed_children={"tail implication": (sere, prop),
                    "tail conjunction": (sere, prop),
                    "union": (sere, sere),
                    "intersection": (sere, sere),
                    "intersection+": (sere, sere),
                    "concatenation": (sere, sere),
                    "fusion": (sere, sere),
                    "repetition": (sere, ()),
                    "negation": (prop, ()),
                    "conjunction": (prop, prop),
                    "disjunction": (prop, prop),
                    "next": (prop, ()),
                    "until": (prop, prop),
                    "releases": (prop, prop),
                    "sere": (sere, ())}
  string_representation={"tail implication": "({%s} (%s))",
                         "tail conjunction": "(!({%s} (!%s)))",
                         "union": "{%s} | {%s}",
                         "intersection": "{%s} && {%s}",
                         "intersection+": "{%s} & {%s}",
                         "concatenation": "{%s} ; {%s}",
                         "fusion": "{%s} : {%s}",
                         "repetition": "{%s}[*]",
                         "negation": "(!%s)",
                         "conjunction": "(%s & %s)",
                         "disjunction": "(%s | %s)",
                         "next": "(X %s)",
                         "until": "([%s U %s])",
                         "releases": "(!([!%s U !%s]))"}
  atoms=5
  def __init__(self,choices):
    self._operator=choice(choices)
    self._left=None
    self._right=None
  def getoperator(self):
    return self._operator
  operator=property(getoperator)
  def getleft(self):
    if self._left==None:
      return "p%d"%randint(0,Node.atoms-1)
    else:
      return self._left
  def setleft(self, value):
    self._left=value
  left=property(getleft, setleft)
  def getright(self):
    if self._right==None:
      return "p%d"%randint(0,Node.atoms-1)
    else:
      return self._right
  def setright(self, value):
    if self.binary:
      self._right=value
    else:
      raise AttributeError("Trying to set right operand of a unary operator")
  right=property(getright, setright)
  def getbinary(self):
    return self.rchoices!=()
  binary=property(getbinary)
  def getlchoices(self):
    return Node.allowed_children[self.operator][0]
  lchoices=property(getlchoices)
  def getrchoices(self):
    return Node.allowed_children[self.operator][1]
  rchoices=property(getrchoices)
  def __str__(self):
    if self.binary:
      return Node.string_representation[self.operator]%(self.left, self.right)
    else:
      return Node.string_representation[self.operator]%(self.left)
  def __len__(self):
    if self.binary:
      return 1 + (self._left==None and 1 or len(self.left)) + (self._right==None and 1 or len(self.right))
    else:
      return 1 + (self._left==None and 1 or len(self.left))

def random(n, choices):
  node=Node(choices)
  if len(node) < n:
    if not node.binary:
      node.left=random(n-1, node.lchoices)
    else:
      r=randint(1,n-2)
      node.left=random(r, node.lchoices)
      node.right=random(n-r-1, node.rchoices)
  return node

if __name__=="__main__":
  parser=OptionParser()
  parser.add_option("--atoms",type="int",dest="atoms",default=5)
  parser.add_option("--length",type="int",dest="length",default=10)
  (opts,args)=parser.parse_args()
  Node.atoms=opts.atoms
  seed()
  print "PSLSPEC %s;"%random(opts.length, Node.prop)