/*
 This file is part of the PSL Observer modification for NuSMV.
 Copyright (C) 2008-2009 Tuomas Launiainen.
 
 This program is free software; you can redistribute it and/or 
 modify it under the terms of the GNU Lesser General Public 
 License as published by the Free Software Foundation; either 
 version 2 of the License, or (at your option) any later version.
 
 This program is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of 
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public 
 License along with this library; if not, write to the Free Software 
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.
 
 For more information, see <http://www.tcs.hut.fi/~tlauniai/psl-observer>.
 */ 
#ifndef __OBSERVER_UTILS_H__
#define __OBSERVER_UTILS_H__

#include <stdarg.h>
#include "node/node.h"
#include "parser/symbols.h"
#include "parser/psl/psl_symbols.h"

#pragma mark Shorthands

#define atom(name) find_node(ATOM,(node_ptr)find_string(name),Nil)
#define fcons(a,b) find_node(CONS,a,b)
#define and(a,b) find_node(AND,a,b)
#define or(a,b) find_node(OR,a,b)
#define not(n) find_node(NOT,n,Nil)
#define eqdef(a,b) find_node(EQDEF,a,b)
#define ltlspec(n) find_node(LTLSPEC,n,Nil)
#define invarspec(n) find_node(INVARSPEC,n,Nil)
#define pslspec(n) find_node(PSLSPEC,n,Nil)
#define next(n) find_node(NEXT,n,Nil)
#define sinit(n) find_node(SMALLINIT,n,Nil)
#define implies(a,b) find_node(IMPLIES,a,b)
#define iff(a,b) find_node(IFF,a,b)
#define colon(a,b) find_node(COLON,a,b)
#define var(n) find_node(VAR,n,Nil)
#define trans(n) find_node(TRANS,n,Nil)
#define ivar(n) find_node(IVAR,n,Nil)
#define invar(n) find_node(INVAR,n,Nil)
#define leaf(t) find_node(t,Nil,Nil)
#define module(a,b) find_node(MODULE,a,b)
#define modtype(a,b) find_node(MODTYPE,a,b)
#define init(n) find_node(INIT,n,Nil)
#define assign(n) find_node(ASSIGN,n,Nil)
#define trueexp find_node(TRUEEXP,Nil,Nil)
#define falseexp find_node(FALSEEXP,Nil,Nil)
#define atom_text(n) (node_get_lstring(n)->text)

#define sere(n) find_node(PSL_SERE,n,Nil)
#define intersect(a,b) find_node(PSL_AMPERSANDAMPERSAND,a,b)
#define concat(a,b) find_node(PSL_SERECONCAT,find_node(PSL_SERE,a,Nil),find_node(PSL_SERE,b,Nil))
#define fusion(a,b) find_node(PSL_SEREFUSION,find_node(PSL_SERE,a,Nil),find_node(PSL_SERE,b,Nil))

#define tailimpl(a,b) find_node(PSL_PIPEMINUSGT,find_node(COLON,a,b),Nil)
#define tailex(a,b) find_node(NOT,find_node(PSL_PIPEMINUSGT,find_node(COLON,a,find_node(NOT,b,Nil)),Nil),Nil)

#define istailimpl(n) (node_get_type(n) == PSL_PIPEMINUSGT)
#define istailex(n) (node_get_type(n) == NOT && node_get_type(car(n)) == PSL_PIPEMINUSGT)

#define is_kleene(n) (node_get_type(n)==PSL_SEREREPEATED && node_get_type(car(n))==PSL_LBSPLAT)
#define is_plusrepeat(n) (node_get_type(n)==PSL_SEREREPEATED && node_get_type(car(n))==PSL_LBPLUSRB)
#define kleene(n) find_node(PSL_SEREREPEATED,find_node(PSL_LBSPLAT,find_node(PSL_SERE,n,Nil),Nil),Nil)
#define plusrepeat(n) find_node(PSL_SEREREPEATED,find_node(PSL_LBPLUSRB,find_node(PSL_SERE,n,Nil),Nil),Nil)
#define repeat_body(n) car(car(n))
#define repeat_amout(n) cdr(n)

#define finally(n) find_node(OP_FUTURE,n,Nil)
#define globally(n) find_node(OP_GLOBAL,n,Nil)
#define op_x(n) find_node(OP_NEXT, n, Nil)
#define releases(a,b) find_node(RELEASES, a, b)
#define until(a,b) find_node(UNTIL, a, b)

node_ptr tail_car(node_ptr);
node_ptr tail_cdr(node_ptr);
node_ptr share_subformulas(node_ptr);
void fatal(char* format, ...);

#pragma mark Stack

typedef struct stack* stack;

stack make_stack();
unsigned char stack_empty(stack s);
void stack_push(stack s, node_ptr n);
node_ptr stack_pop(stack s);
void free_stack(stack s);

#endif