/*
 This file is part of the PSL Observer modification for NuSMV.
 Copyright (C) 2008-2009 Tuomas Launiainen.
 
 This program is free software; you can redistribute it and/or 
 modify it under the terms of the GNU Lesser General Public 
 License as published by the Free Software Foundation; either 
 version 2 of the License, or (at your option) any later version.
 
 This program is distributed in the hope that it will be useful, 
 but WITHOUT ANY WARRANTY; without even the implied warranty of 
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public 
 License along with this library; if not, write to the Free Software 
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA.
 
 For more information, see <http://www.tcs.hut.fi/~tlauniai/psl-observer>.
 */ 
#include "observer_utils.h"
#include "utils/assoc.h"

node_ptr tail_car(node_ptr n) {
  if (istailimpl(n)) {
    return car(car(n));
  }
  else {
    if (istailex(n)) {
      return car(car(car(n)));
    }
    else {
      return car(n);
    }
  }
}

node_ptr tail_cdr(node_ptr n) {
  if (istailimpl(n)) {
    return cdr(car(n));
  }
  else {
    if (istailex(n)) {
      return car(cdr(car(car(n))));
    }
    else {
      return cdr(n);
    }
  }
}

node_ptr share_subformulas(node_ptr n) {
  if (n==Nil)
    return Nil;
  switch (node_get_type(n)) {
    case NOT:
    case PSL_X:
    case OP_NEXT:
    case OP_GLOBAL:
    case OP_FUTURE:
    case RELEASES:
    case UNTIL:
    case OP_PREC:
    case OP_NOTPRECNOT:
    case OP_ONCE:
    case OP_HISTORICAL:
    case SINCE:
    case TRIGGERED:      
    case OR:
    case AND:
    case IMPLIES:
    case IFF:
    case XNOR:
    case XOR:
    case UNION:
    case SETIN: 
    case EQUAL:
    case NOTEQUAL:
    case LT:
    case GT:
    case LE:
    case GE: 
    case TIMES:
    case DIVIDE:
    case PLUS :
    case MINUS:
    case MOD: 
    case LSHIFT:
    case RSHIFT:
    case LROTATE:
    case RROTATE:
    case DOT:
    case ARRAY:
      return find_node(node_get_type(n),share_subformulas(car(n)),
                       share_subformulas(cdr(n)));
      break;
    case FALSEEXP:
    case TRUEEXP:
    case NUMBER:
    case ATOM:
      return find_atom(n);
      break;
    default:
      fprintf(stderr,"Observer construction encountered an invalid node (%d), aborting\n",node_get_type(n));
      exit(1);
  }
  return Nil;
}

void fatal(char* format, ...) {
	va_list args;
	va_start (args, format);
	vfprintf(stderr, format, args);
	va_end (args);
	exit(1);
}

#pragma mark Stack

struct stack {
  node_ptr data;
};

stack make_stack() {
  struct stack* s=(struct stack*)malloc(sizeof(struct stack));
  s->data=Nil;
  return (stack)s;
}

unsigned char stack_empty(stack s) {
  return (s->data == Nil);
}

void stack_push(stack s, node_ptr n) {
  s->data=cons(n,s->data);
}

node_ptr stack_pop(stack s) {
  node_ptr n=car(s->data);
  node_ptr tmp=s->data;
  s->data=cdr(s->data);
  free_node(tmp);
  return n;
}

void free_stack(stack s) {
  while (!stack_empty(s))
    stack_pop(s);
  free(s);
}
