#include"graph.H"
#include"formula.H"
#include"net.H"
#include"stubborn.H"
#include"check.H"
#include<fstream.h>
#include<iostream.h>
unsigned int NumberOfStates = 0;
State * initial;

void printstate()
{
	int i,j;
	if(Sflg)
	{
	cout << "STATE";
	for(i=0,j=0;i<Places[0]->cnt;i++)
	{
		if(Places[i]->current_marking)
		cout << (j++ ? ",\n" : "\n" ) << Places[i]->name << " : " << Places[i]->current_marking ;
	}
	cout << "\n\n";
	return;
	}
	if(sflg)
	{
	ofstream statestream(statefile);
	if(! statestream)
	{	
		cerr << "Cannot open state output file: " << statefile <<
		"\n no output written\n";
		return;
	}
	statestream << "STATE";
	for(i=0,j=0;i<Places[0]->cnt;i++)
	{
		if(Places[i]->current_marking)
		statestream << (j++ ? ",\n" : "\n") << Places[i]->name << " : " << Places[i]->current_marking;
	}
	statestream << "\n\n";
	return;
	}

}

#ifdef MODELCHECKING

void print_witness_eu(State *, untilformula *);
void print_witness_ef(State *, unarytemporalformula *);

void print_witness_ex(State * s, unarytemporalformula * f)
{
	cout  << "PATH\n";
	if(s -> witnesstransition[f->tempindex])
	{
		cout << s -> witnesstransition[f->tempindex]->name << "\n";
	}
	else
	{
		cout << " SELF LOOP AT TERMINAL STATE\n";
	}
}

void print_witness_ef(State * s, unarytemporalformula * f)
{
	cout  << "PATH\n";
	while(!s->value[f->element->index])
	{
		cout << s -> witnesstransition[f->tempindex]->name << "\n";
		s = s -> witness[f->tempindex];
	}

}

void print_witness_eg(State * s, unarytemporalformula * f)
{
	cout  << "PATH\n";
	while(s->value[f->element->index])
	{
		cout << s -> witnesstransition[f->tempindex]->name << "\n";
		s->value[f->element->index] = false;
		s = s -> witness[f->tempindex];
	}
}

void print_counterexample_af(State * s, unarytemporalformula * f)
{
	cout  << "PATH\n";
	while(!s->value[f->element->index])
	{
		cout << s -> witnesstransition[f->tempindex]->name << "\n";
		s->value[f->element->index] = true;
		s = s -> witness[f->tempindex];
	}
}

void print_counterexample_au(State * s, untilformula * f)
{
	cout  << "PATH\n";
	while(s->value[f->hold->index])
	{
		cout << s -> witnesstransition[f->tempindex]->name << "\n";
		s->value[f->hold->index] = true;
		s = s -> witness[f->tempindex];
	}
}

void print_witness_eu(State * s, untilformula * f)
{
	cout  << "PATH\n";
	while(!s->value[f->goal->index])
	{
		cout << s -> witnesstransition[f->tempindex]->name << "\n";
		s = s -> witness[f->tempindex];
	}
}

void print_counterexample_ax(State * s, unarytemporalformula * f)
{
	cout  << "PATH\n";
	if(s -> witnesstransition[f->tempindex])
	{
		cout << s -> witnesstransition[f->tempindex]->name << "\n";
	}
	else
	{
		cout << "SELF LOOP AT TERMINAL STATE\n";
	}
}

void print_counterexample_ag(State * s, unarytemporalformula * f)
{
	cout  << "PATH\n";
	while(s->value[f->element->index])
	{
		cout << s -> witnesstransition[f->tempindex]->name << "\n";
		s = s -> witness[f->tempindex];
	}
}

void check(State * ,formula *);

void print_check_path(State * ini,formula * form)
{
	if((form->type == ef) && ini -> value[form -> index])
	{
		print_witness_ef(ini,(unarytemporalformula *) form);
		return;
	}
	if((form->type == ag) && !ini -> value[form -> index])
	{
		print_counterexample_ag(ini,(unarytemporalformula *) form);
		return;
	}
	if((form->type == eg) && ini -> value[form -> index])
	{
		print_witness_eg(ini,(unarytemporalformula *) form);
		return;
	}
	if((form->type == eu) && ini -> value[form -> index])
	{
		print_witness_eu(ini,(untilformula *) form);
		return;
	}
	if((form->type == ex) && ini -> value[form -> index])
	{
		print_witness_ex(ini,(unarytemporalformula *) form);
		return;
	}
	if((form->type == ax) && !ini -> value[form -> index])
	{
		print_counterexample_ax(ini,(unarytemporalformula *) form);
		return;
	}
	if((form->type == af) && !ini -> value[form -> index])
	{
		print_counterexample_af(ini,(unarytemporalformula *) form);
		return;
	}
	if((form->type == au) && !ini -> value[form -> index])
	{
		print_counterexample_au(ini,(untilformula *) form);
		return;
	}
	if(form->type != neg && form -> type != conj && form -> type != disj)
	{
		cout << "NO PATH\n";
		return;
	}
	if((form->type == neg))
	{
		print_check_path(ini,((unarybooleanformula *) form) -> sub);
		return;
	}
	if(form->type == conj)
	{
		unsigned int i;
		for(i=0;i< ((booleanformula *) form) -> cardsub;i++)
		{
			cout << "CONJ. " << i << ":\n";  print_check_path(ini,((booleanformula *) form) -> sub[i]);
			if(!(ini -> value[((booleanformula *) form) -> sub[i] -> index])) break;
		}
		return;
	}
	if(form->type == disj)
	{
		unsigned int i;
		for(i=0;i< ((booleanformula *) form) -> cardsub;i++)
		{
			cout << "DISJ. " << i << ":\n";  print_check_path(ini,((booleanformula *) form) -> sub[i]);
			if(ini -> value[((booleanformula *) form) -> sub[i] -> index]) break;
		}
		return;
	}
}

int modelcheck()
{
	unsigned int i;

	if(!F)
	{
		cerr << "\nspecify formula in analysis task file\n";
		_exit(4);
	}
	currentdfsnum = 1;
	for(i=0;i<Transitions[0]->cnt;i++)
	{
#ifdef EXTENDED
		unsigned int j;
		for(j=0;j<F -> tempcard;j++)
		{
			Transitions[i]-> lstdisabled[j] = 
			Transitions[i]-> lstfired[j] = 0;
		}
#endif
		Transitions[i]->pathrestriction = new bool [F -> tempcard];
	}
	DeadStatePathRestriction = new bool [F -> tempcard];


	for(i=0;i<Places[0]->cnt;i++)
	{
		Places[i] -> propositions = new formula * [Places[i] -> cardprop];
		Places[i]->cardprop = 0;
	}
	int res;
	F = F -> reduce(& res);
	if(res < 2)
	{
		return 1 - res;
	}
	// remove "not"s in static subformulae
	F = F -> posate();
	F -> tempcard = 0;
	F -> setstatic();
	cout << "\nFormula with \n" << F -> card << " subformulas\nand " << F -> tempcard << " temporal operators.\n";
	initial = insert_marking();
	F -> evaluateatomic(initial);
	check(initial,F);
	cout << "\nresult: " << (initial -> value[F -> index] ? "true" : "false") << "\n";
	statistics(NumberOfStates+1,Edges,NonEmptyHash);
	if(pflg || Pflg)
	{
		_IO_ostream_withassign tmpcout; 
		ofstream pathstream(pathfile);
		if(pflg)
		{
			if(!pathstream)
			{
				cerr << "Cannot open path output file: " << pathfile <<
				 "\nno output written";
				 pflg = false;
			}
			tmpcout = cout;
			cout = pathstream;
		}
		print_check_path(initial,F);
		if(pflg)
		{
			cout = tmpcout;
		}
	}
	return  (initial -> value[F -> index] ? 0 : 1);
}

void searchAF(State *,unarytemporalformula *);
void searchEG(State *,unarytemporalformula *);
void searchAU(State *,untilformula *);
void searchEU(State *,untilformula *);
void searchAG(State *,unarytemporalformula *);
void searchEF(State *,unarytemporalformula *);
void searchEX(State *,unarytemporalformula *);
void searchAX(State *,unarytemporalformula *);

void check(State * s, formula * f)
{
	unsigned int i;
	if(s->known[f->index]) return;
	switch(f->type)
	{
	case neg: check(s,((unarybooleanformula *) f)->sub);
		  if(s->value[((unarybooleanformula *) f) ->sub->index])
		  {
			s -> value[f->index] = false;
		  }
		  else
		  {
			s -> value[f->index] = true;
		  }
		  s -> known[f -> index] = true;
		  return;
	case conj:
	
			for(i=0;i<((booleanformula *) f) -> cardsub;i++)
		  {
		  check(s,((booleanformula *) f) -> sub[i]);
		  if(!(s-> value[((booleanformula *) f)->sub[i]->index]))
		  {
			s -> value[f -> index] = false;
			s -> known[f -> index] = true;
			return;
 		  }
		  }
		  s -> value[f -> index] = true;
		  s -> known[f -> index] = true;
		  return;
	case disj:
		 for(i=0;i<((booleanformula *) f) -> cardsub;i++)
		 {
			
		 check(s,((booleanformula *) f) -> sub[i]);
		  if(s-> value[((booleanformula *) f)->sub[i]->index])
		  {
			s -> value[f -> index] = true;
			s -> known[f -> index] = true;
			return;
		  }
		  }
		  s -> value[f->index] = false;
		  s -> known[f->index] = true;
		  return;
	case ef:  check(s,((unarytemporalformula *) f)->element);
		  if(s->value[((unarytemporalformula *) f)->element->index])
		  {
			s->value[f->index] = s->known[f->index] = true;
			s -> witness[f -> tempindex] = (State *) 0;
			s -> witnesstransition[f->tempindex] = (Transition *) 0;
			return;
		  }
		  searchEF(s,(unarytemporalformula *) f);
		  return;
	case ag:  check(s,((unarytemporalformula *) f)->element);
		  if(!s->value[((unarytemporalformula *) f)->element->index])
		  {
			s->value[f->index] = false;
			s->known[f->index] = true;
			s -> witness[f -> tempindex] = (State *) 0;
			s -> witnesstransition[f->tempindex] = (Transition *) 0;
			return;
		  }
		  searchAG(s,(unarytemporalformula *) f);
		  return;
	case eu:  check(s,((untilformula *) f) ->goal);
			  if(s -> value[((untilformula *) f) ->goal ->index])
			  {
				s -> value[f->index] = true;
				s -> known[f->index] = true;
				s -> witness[f -> tempindex] = (State *) 0;
				s -> witnesstransition[f->tempindex] = (Transition *) 0;
				return;
			  }
			  check(s,((untilformula *) f) ->hold);
			  if(!s->value[((untilformula *) f) ->hold->index])
			  {
					s->value[f->index] = false;
					s->known[f->index] = true;
					return;
			  }
			  searchEU(s,((untilformula *) f) );
			  return;
	case eg:  check(s,((unarytemporalformula *) f)->element);
			  if(!s -> value[((unarytemporalformula *) f)->element ->index])
			  {
				s -> value[f->index] = false;
				s -> known[f->index] = true;
				return;
			  }
			  searchEG(s,(unarytemporalformula *) f);
			  return;
	case af:  check(s,((unarytemporalformula *) f)->element);
			  if(s -> value[((unarytemporalformula *) f)->element ->index])
			  {
				s -> value[f->index] = true;
				s -> known[f->index] = true;
				return;
			  }
			  searchAF(s,(unarytemporalformula *) f);
			  return;
	case au:  check(s,((untilformula *) f) ->goal);
			  if(s -> value[((untilformula *) f) ->goal ->index])
			  {
				s -> value[f->index] = true;
				s -> known[f->index] = true;
				return;
			  }
			  check(s,((untilformula *) f) ->hold);
			  if(!s->value[((untilformula *) f) ->hold->index])
			  {
					s->value[f->index] = false;
					s->known[f->index] = true;
					s -> witness[f -> tempindex] = (State *) 0;
					s -> witnesstransition[f->tempindex] = (Transition *) 0;
					return;
			  }
			  searchAU(s,((untilformula *) f) );
			  return;
	case ex:  searchEX(s,((unarytemporalformula *) f)); return;
	case ax:  searchAX(s,((unarytemporalformula *) f)); return;
	default: cout << "temporal operator not supported\n";
	}
}

void searchEF(State * s,unarytemporalformula * f)
{
  State * tarjanroot;
  bool found;
  unsigned int i;
  unsigned int cardstates;
  State * CurrentState, * NewState;

#ifdef EXTENDEDCTL
  TemporalIndex = f -> tempindex;
#endif
  found = false;
  cardstates = 1;
  CurrentState = s;
  tarjanroot = s;
  // End of Stack = Self reference! Not on stack -> next = nil
  CurrentState -> tarjanstack[f->tempindex] = CurrentState;
  CurrentState -> checkcurrent[f->tempindex] = 0;
  CurrentState -> checkfirelist[f->tempindex] = 
#ifdef STUBBORN
stubbornfirelist(s,f->element);
#else
firelist();
#endif
  CurrentState -> checkparent[f->tempindex] = (State *) 0;
  CurrentState -> checkdfs[f->tempindex] = CurrentState -> checkmin[f->tempindex] = 0;
  
  // process marking until returning from initial state
  
  while(CurrentState)
    {
	CurrentState -> value[f->index] = false;
        CurrentState -> known[f->index] = true;
      if(CurrentState -> checkfirelist[f->tempindex][CurrentState -> checkcurrent[f->tempindex]])
	{
	  // there is a next state that needs to be explored
	  CurrentState -> checkfirelist[f->tempindex][CurrentState -> checkcurrent[f->tempindex]] -> fire();
	  if(NewState = search_marking())
	    {
		Edges ++;
		 if(!(Edges % REPORTFREQUENCY))
					   cout << "st: " << NumberOfStates << "     edg: " << Edges << "\n";
	      if(NewState -> known[f->index])
	      {
		if(NewState -> value[f->index])
                {
		  // Value of new state known, true
		  //Whitness for EF phi found!
                  found = true;
                  CurrentState -> value[f->index] = CurrentState -> known[f->index] = true;
		  CurrentState -> witness[f->tempindex] = NewState;
		  CurrentState -> witnesstransition[f->tempindex] = CurrentState->checkfirelist[f->tempindex][CurrentState->checkcurrent[f->tempindex]];
		  CurrentState -> checkfirelist[f->tempindex][CurrentState -> checkcurrent[f->tempindex]] -> backfire();
		  break;
                }
	        else
                {
				  // Value of new state known, false
                  // NewState either on Stack or does not model EF phi
		  if(NewState->tarjanstack[f->tempindex])
	  	  {
			// on Stack: set min, update witness
	          	if(CurrentState -> checkmin[f->tempindex] > NewState -> checkdfs[f->tempindex])
			{	
				CurrentState -> checkmin[f->tempindex] = NewState -> checkdfs[f->tempindex];
				CurrentState -> witness[f->tempindex] = NewState;
				CurrentState -> witnesstransition[f->tempindex] = CurrentState -> checkfirelist[f->tempindex][CurrentState -> checkcurrent[f->tempindex]];
			}
		  }
		  CurrentState -> checkfirelist[f->tempindex][CurrentState -> checkcurrent[f->tempindex]] -> backfire();
		  CurrentState -> checkcurrent[f->tempindex]++;
		}
              }
	      else
	      {
		// value of new state unknown
		check(NewState,f->element);
		if(NewState->value[f->element->index])
		{
                        NewState -> value[f->index] = true;
                        NewState -> known[f->index] = true;
                        CurrentState -> value[f->index] = true;
                        CurrentState -> known[f->index] = true;
			found = true;
		  CurrentState -> checkfirelist[f->tempindex][CurrentState -> checkcurrent[f->tempindex]] -> backfire();
		        CurrentState -> witness[f->tempindex] = NewState;
		        CurrentState -> witnesstransition[f->tempindex] = CurrentState->checkfirelist[f->tempindex][CurrentState ->checkcurrent[f->tempindex]];
			break;
		}
		else
		{
                        CurrentState -> value[f->index] = false;
                        CurrentState -> known[f->index] = true;
			NewState -> checkparent[f->tempindex] = CurrentState;
#ifdef EXTENDEDCTL
			TemporalIndex = f -> tempindex;
#endif
			NewState -> checkfirelist[f -> tempindex] = 
#ifdef STUBBORN
stubbornfirelist(NewState,f->element);
#else
firelist();
#endif
			NewState -> checkdfs[f->tempindex] = NewState -> checkmin[f->tempindex] = cardstates++;
			NewState -> checkcurrent[f -> tempindex] = 0;
			NewState -> tarjanstack[f->tempindex] = tarjanroot;
			tarjanroot = NewState;
			CurrentState = NewState;
		}
	      }
	    }
	  else
	    {
	      NewState = insert_marking();
		  NewState -> tarjanstack[f->tempindex] = tarjanroot;
		  tarjanroot = NewState;
		  NumberOfStates ++;
		  Edges ++;
		   if(!(Edges % REPORTFREQUENCY))
						 cout << "st: " << NumberOfStates << "     edg: " << Edges << "\n";
	      NewState -> checkcurrent[f->tempindex] = 0;
	      NewState -> checkparent[f->tempindex] = CurrentState;
	      NewState -> checkdfs[f->tempindex] = NewState -> checkmin[f->tempindex] = cardstates++;
	      check(NewState,f->element);
	      if(NewState->value[f->element->index])
	      {
		NewState -> value[f->index] = true;
		NewState -> known[f->index] = true;
		CurrentState -> value[f->index] = true;
		CurrentState -> known[f->index] = true;
		found = true;
		CurrentState -> witness[f->tempindex] = NewState;
		CurrentState -> witnesstransition[f->tempindex] = CurrentState->checkfirelist[f->tempindex][CurrentState->checkcurrent[f->tempindex]];
		  CurrentState -> checkfirelist[f->tempindex][CurrentState -> checkcurrent[f->tempindex]] -> backfire();
		break;
	      }
	      else
	      {
#ifdef EXTENDEDCTL
		  TemporalIndex = f -> tempindex;
#endif
	      NewState -> checkfirelist[f->tempindex] = 
#ifdef STUBBORN
stubbornfirelist(NewState,f->element);
#else
firelist();
#endif
		NewState -> checkcurrent[f->tempindex] = 0;
		CurrentState -> value[f->index] = false;
		CurrentState -> known[f->index] = true;
		CurrentState = NewState;
	      }
	    }
	}
      else
	{
	  // test scc, update tarjanstack, return to previous state
	  if(CurrentState->checkmin[f->tempindex] == CurrentState-> checkdfs[f->tempindex])
          {
		// scc closed 
		CurrentState -> value[f->index] = false;
		CurrentState -> known[f->index] = true;
		while((tarjanroot->checkdfs[f->tempindex] >= CurrentState -> checkdfs[f->tempindex]))
		{
			State * tmp;
			tmp = tarjanroot;
			tarjanroot -> witness[f->tempindex] = (State *) 0;
			if(tarjanroot == tarjanroot ->tarjanstack[f->tempindex])
			{	
				tarjanroot -> tarjanstack[f->tempindex] = (State *) 0;
				break;
			}
			tarjanroot = tarjanroot -> tarjanstack[f -> tempindex];
			tmp -> tarjanstack[f -> tempindex] = (State *) 0;
		}
	  }
	  // return to previous state
	  if(CurrentState->checkparent[f -> tempindex])
	    {
	      if(CurrentState -> checkparent[f->tempindex]->checkmin[f->tempindex] > CurrentState -> checkmin[f->tempindex])
	      {
		CurrentState -> checkparent[f->tempindex]->checkmin[f->tempindex] = CurrentState -> checkmin[f->tempindex];
		CurrentState -> checkparent[f->tempindex] -> witness[f->tempindex] = CurrentState;
		 CurrentState -> checkparent[f->tempindex] -> witnesstransition[f->tempindex] =
			CurrentState -> checkparent[f->tempindex] -> checkfirelist[f->tempindex][ CurrentState -> checkparent[f->tempindex] -> checkcurrent[f->tempindex]];
              }
	      CurrentState = CurrentState -> checkparent[f->tempindex];
	      CurrentState -> checkfirelist[f->tempindex][CurrentState -> checkcurrent[f->tempindex]] -> backfire();
	      CurrentState -> checkcurrent[f -> tempindex] ++;
	    }
	  else
	    {
		CurrentState = (State *) 0;
            }
	}
    }
    if(found)
    {
	while(CurrentState -> checkparent[f -> tempindex])
	{
		CurrentState -> checkparent[f -> tempindex] -> witness[f -> tempindex] = CurrentState;
		CurrentState -> checkparent[f -> tempindex] -> witnesstransition[f -> tempindex]
			= CurrentState -> checkparent[f -> tempindex]-> checkfirelist[f -> tempindex][CurrentState -> checkparent[f -> tempindex] -> checkcurrent[f -> tempindex]];
		
		CurrentState = CurrentState -> checkparent[f -> tempindex];
		CurrentState -> value[f-> index] = true;
		  CurrentState -> checkfirelist[f->tempindex][CurrentState -> checkcurrent[f->tempindex]] -> backfire();
	}
	while(1)
	{
		State * tmp;

		tmp = tarjanroot;
		tarjanroot -> value[f->index] = true;
		if(tarjanroot == tarjanroot -> tarjanstack[f->tempindex])
		{	
			tarjanroot -> tarjanstack[f->tempindex] = (State *) 0;
			break;
		}
		tarjanroot = tarjanroot -> tarjanstack[f->tempindex];
		tmp -> tarjanstack[f->tempindex] = (State *) 0;
        }
     }
}

void searchAX(State * s,unarytemporalformula * f)
{
  State * NewState;

#ifdef EXTENDEDCTL
	TemporalIndex = f -> tempindex;
#endif
    s -> checkfirelist[f->tempindex] = firelist();
    s -> value[f->index] = true;
    s -> known[f->index] = true;

    if(!(s -> checkfirelist[f->tempindex][0]))
	{
		if(Transitions[0]->NrEnabled)
		{
			// no tau-successors, but state not dead
			return;
		}
		// dead state: this state counts as successor state
		if(DeadStatePathRestriction[f -> tempindex])
		{
		check(s,f -> element);
		if(!(s->value[f->element->index]))
		{
			s -> value[f->index] = false;
			s -> witness[f->tempindex] = (State *) 0;
			s -> witnesstransition[f->tempindex] = (Transition *) 0;
		}
		}
		return;
	}
    s -> checkcurrent[f->tempindex] = 0;
	do
	{
	  // there is a next state that needs to be explored
	  s -> checkfirelist[f->tempindex][s -> checkcurrent[f->tempindex]] -> fire();
	  if(!(NewState = search_marking()))
	  {
	    NewState = insert_marking();
	    NumberOfStates ++;
	  }
	  Edges ++;
	  if(!(Edges % REPORTFREQUENCY))
				 cout << "st: " << NumberOfStates << "     edg: " << Edges << "\n";
	  check(NewState,f->element);
	  if(!(NewState->value[f->element->index]))
	  {
		  s -> value[f->index] = false;
		  s -> witness[f->tempindex] = NewState;
		  s -> witnesstransition[f->tempindex] = s->checkfirelist[f->tempindex][s->checkcurrent[f->tempindex]];
		  s -> checkfirelist[f->tempindex][s -> checkcurrent[f->tempindex]] -> backfire();
		  return;
	  }
	  // return to previous state
	  s -> checkfirelist[f->tempindex][s -> checkcurrent[f -> tempindex]] -> backfire();
	  s -> checkcurrent[f -> tempindex] ++;
	}
    while(s -> checkfirelist[f->tempindex][s -> checkcurrent[f->tempindex]]);
}

void searchEX(State * s,unarytemporalformula * f)
{
  State * NewState;

#ifdef EXTENDEDCTL
	TemporalIndex = f -> tempindex;
#endif
    s -> checkfirelist[f->tempindex] = firelist();
    s -> value[f->index] = false;
    s -> known[f->index] = true;

    if(!(s -> checkfirelist[f->tempindex][0]))
	{
		if(Transitions[0]-> NrEnabled)
		{
			// no tau-successors, but state not dead
			return;
		}
		// dead state: this state counts as successor state
		if(DeadStatePathRestriction[f -> tempindex])
		{
		check(s,f -> element);
		if(s->value[f->element->index])
		{
			s -> value[f->index] = true;
			s -> witness[f->tempindex] = (State *) 0;
			s -> witnesstransition[f->tempindex] = (Transition *) 0;
		}
		}
		return;
	}
    s -> checkcurrent[f->tempindex] = 0;
	do
	{
	  // there is a next state that needs to be explored
	  s -> checkfirelist[f->tempindex][s -> checkcurrent[f->tempindex]] -> fire();
	  if(!(NewState = search_marking()))
	  {
	    NewState = insert_marking();
	    NumberOfStates ++;
	  }
	  Edges ++;
	  if(!(Edges % REPORTFREQUENCY))
				 cout << "st: " << NumberOfStates << "     edg: " << Edges << "\n";
	  check(NewState,f->element);
	  if(NewState->value[f->element->index])
	  {
		  s -> value[f->index] = true;
		  s -> witness[f->tempindex] = NewState;
		  s -> witnesstransition[f->tempindex] = s->checkfirelist[f->tempindex][s->checkcurrent[f->tempindex]];
		  s -> checkfirelist[f->tempindex][s -> checkcurrent[f->tempindex]] -> backfire();
		  return;
	  }
	  // return to previous state
	  s -> checkfirelist[f->tempindex][s -> checkcurrent[f -> tempindex]] -> backfire();
	  s -> checkcurrent[f -> tempindex] ++;
	}
    while(s -> checkfirelist[f->tempindex][s -> checkcurrent[f->tempindex]]);
}

void searchAG(State * s,unarytemporalformula * f)
{
  State * tarjanroot;
  bool found;
  unsigned int i;
  unsigned int cardstates;
  State * CurrentState, * NewState;

  found = false;
  cardstates = 1;
  CurrentState = s;
  tarjanroot = s;
  // End of Stack = Self reference! Not on stack -> next = nil
  CurrentState -> tarjanstack[f->tempindex] = CurrentState;
  CurrentState -> checkcurrent[f->tempindex] = 0;
#ifdef EXTENDEDCTL
  TemporalIndex = f -> tempindex;
#endif
  CurrentState -> checkfirelist[f->tempindex] = 
#ifdef STUBBORN
	stubbornfirelistneg(s,f -> element);
#else
	firelist();
#endif
  CurrentState -> checkparent[f->tempindex] = (State *) 0;
  CurrentState -> checkdfs[f->tempindex] = CurrentState -> checkmin[f->tempindex] = 0;
  
  // process marking until returning from initial state
  
  while(CurrentState)
    {
	CurrentState -> value[f->index] = true;
        CurrentState -> known[f->index] = true;
      if(CurrentState -> checkfirelist[f->tempindex][CurrentState -> checkcurrent[f->tempindex]])
	{
	  // there is a next state that needs to be explored
	  CurrentState -> checkfirelist[f->tempindex][CurrentState -> checkcurrent[f->tempindex]] -> fire();
	  if(NewState = search_marking())
	    {
		Edges ++;
		 if(!(Edges % REPORTFREQUENCY))
					   cout << "st: " << NumberOfStates << "     edg: " << Edges << "\n";
	      if(NewState -> known[f->index])
	      {
		if(!(NewState -> value[f->index]))
                {
		  // Value of new state known, true
		  //Counterexample for AG phi found!
                  found = true;
                  CurrentState -> value[f->index] = false;
		  CurrentState -> witness[f->tempindex] = NewState;
		  CurrentState -> witnesstransition[f->tempindex] = CurrentState->checkfirelist[f->tempindex][CurrentState->checkcurrent[f->tempindex]];
		  CurrentState -> checkfirelist[f->tempindex][CurrentState -> checkcurrent[f->tempindex]] -> backfire();
		  break;
                }
	        else
                {
				  // Value of new state known, false
                  // NewState either on Stack or does not model EF phi
		  if(NewState->tarjanstack[f->tempindex])
	  	  {
			// on Stack: set min, update witness
	          	if(CurrentState -> checkmin[f->tempindex] > NewState -> checkdfs[f->tempindex])
			{	
				CurrentState -> checkmin[f->tempindex] = NewState -> checkdfs[f->tempindex];
				CurrentState -> witness[f->tempindex] = NewState;
				CurrentState -> witnesstransition[f->tempindex] = CurrentState -> checkfirelist[f->tempindex][CurrentState -> checkcurrent[f->tempindex]];
			}
		  }
		  CurrentState -> checkfirelist[f->tempindex][CurrentState -> checkcurrent[f->tempindex]] -> backfire();
		  CurrentState -> checkcurrent[f->tempindex]++;
		}
              }
	      else
	      {
		// value of new state unknown
		check(NewState,f->element);
		if(!(NewState->value[f->element->index]))
		{
                        NewState -> value[f->index] = false;
                        NewState -> known[f->index] = true;
                        CurrentState -> value[f->index] = false;
                        CurrentState -> known[f->index] = true;
			found = true;
		  CurrentState -> checkfirelist[f->tempindex][CurrentState -> checkcurrent[f->tempindex]] -> backfire();
		        CurrentState -> witness[f->tempindex] = NewState;
		        CurrentState -> witnesstransition[f->tempindex] = CurrentState->checkfirelist[f->tempindex][CurrentState ->checkcurrent[f->tempindex]];
			break;
		}
		else
		{
                        CurrentState -> value[f->index] = true;
                        CurrentState -> known[f->index] = true;
			NewState -> checkparent[f->tempindex] = CurrentState;
#ifdef EXTENDEDCTL
			TemporalIndex = f -> tempindex;
#endif
			NewState -> checkfirelist[f -> tempindex] = 
#ifdef STUBBORN
stubbornfirelistneg(NewState,f->element);
#else
firelist();
#endif
			NewState -> checkdfs[f->tempindex] = NewState -> checkmin[f->tempindex] = cardstates++;
			NewState -> checkcurrent[f -> tempindex] = 0;
			NewState -> tarjanstack[f->tempindex] = tarjanroot;
			tarjanroot = NewState;
			CurrentState = NewState;
		}
	      }
	    }
	  else
	    {
	      NewState = insert_marking();
		  NewState -> tarjanstack[f->tempindex] = tarjanroot;
		  tarjanroot = NewState;
		  NumberOfStates ++;
		  Edges ++;
		   if(!(Edges % REPORTFREQUENCY))
						 cout << "st: " << NumberOfStates << "     edg: " << Edges << "\n";
	      NewState -> checkcurrent[f->tempindex] = 0;
	      NewState -> checkparent[f->tempindex] = CurrentState;
	      NewState -> checkdfs[f->tempindex] = NewState -> checkmin[f->tempindex] = cardstates++;
	      check(NewState,f->element);
	      if(!(NewState->value[f->element->index]))
	      {
		NewState -> value[f->index] = false;
		NewState -> known[f->index] = true;
		CurrentState -> value[f->index] = false;
		CurrentState -> known[f->index] = true;
		found = true;
		CurrentState -> witness[f->tempindex] = NewState;
		CurrentState -> witnesstransition[f->tempindex] = CurrentState->checkfirelist[f->tempindex][CurrentState->checkcurrent[f->tempindex]];
		  CurrentState -> checkfirelist[f->tempindex][CurrentState -> checkcurrent[f->tempindex]] -> backfire();
		break;
	      }
	      else
	      {
#ifdef EXTENDEDCTL
		  TemporalIndex = f -> tempindex;
#endif
	      NewState -> checkfirelist[f->tempindex] = 
#ifdef STUBBORN
stubbornfirelistneg(NewState,f->element);
#else
firelist();
#endif
		NewState ->checkcurrent[f->tempindex] = 0;
		CurrentState -> value[f->index] = true;
		CurrentState -> known[f->index] = true;
		CurrentState = NewState;
	      }
	    }
	}
      else
	{
	  // test scc, update tarjanstack, return to previous state
	  if(CurrentState->checkmin[f->tempindex] == CurrentState-> checkdfs[f->tempindex])
          {
		// scc closed 
		CurrentState -> value[f->index] = true;
		CurrentState -> known[f->index] = true;
		while((tarjanroot->checkdfs[f->tempindex] >= CurrentState -> checkdfs[f->tempindex]))
		{
			State * tmp;
			tmp = tarjanroot;
			tarjanroot -> witness[f->tempindex] = (State *) 0;
			if(tarjanroot == tarjanroot -> tarjanstack[f->tempindex])
			{
				tarjanroot -> tarjanstack[f->tempindex] = (State *) 0;
				break;
			}
			tarjanroot = tarjanroot -> tarjanstack[f -> tempindex];
			tmp -> tarjanstack[f -> tempindex] = (State *) 0;
		}
	  }
	  // return to previous state
	  if(CurrentState->checkparent[f -> tempindex])
	    {
	      if(CurrentState -> checkparent[f->tempindex]->checkmin[f->tempindex] > CurrentState -> checkmin[f->tempindex])
	      {
		CurrentState -> checkparent[f->tempindex]->checkmin[f->tempindex] = CurrentState -> checkmin[f->tempindex];
		CurrentState -> checkparent[f->tempindex] -> witness[f->tempindex] = CurrentState;
		 CurrentState -> checkparent[f->tempindex] -> witnesstransition[f->tempindex] =
			CurrentState -> checkparent[f->tempindex] -> checkfirelist[f->tempindex][ CurrentState -> checkparent[f->tempindex] -> checkcurrent[f->tempindex]];
              }
	      CurrentState = CurrentState -> checkparent[f->tempindex];
	      CurrentState -> checkfirelist[f->tempindex][CurrentState -> checkcurrent[f->tempindex]] -> backfire();
	      CurrentState -> checkcurrent[f -> tempindex] ++;
	    }
	  else
	    {
		CurrentState = (State *) 0;
            }
	}
    }
    if(found)
    {
	while(CurrentState -> checkparent[f -> tempindex])
	{
		CurrentState -> checkparent[f -> tempindex] -> witness[f -> tempindex] = CurrentState;
		CurrentState -> checkparent[f -> tempindex] -> witnesstransition[f -> tempindex]
			= CurrentState -> checkparent[f -> tempindex]-> checkfirelist[f -> tempindex][CurrentState -> checkparent[f -> tempindex] -> checkcurrent[f -> tempindex]];
		
		CurrentState = CurrentState -> checkparent[f -> tempindex];
		CurrentState -> value[f-> index] = false;
		  CurrentState -> checkfirelist[f->tempindex][CurrentState -> checkcurrent[f->tempindex]] -> backfire();
	}
	while(1)
	{
		State * tmp;

		tmp = tarjanroot;
		tarjanroot -> value[f->index] = false;
		if(tarjanroot == tarjanroot -> tarjanstack[f->tempindex])
		{	
			tarjanroot -> tarjanstack[f->tempindex] = (State *) 0;
			break;
		}
		tarjanroot = tarjanroot -> tarjanstack[f->tempindex];
		tmp -> tarjanstack[f->tempindex] = (State *) 0;
        }
     }
}
	  
extern unsigned int currentdfsnum;
unsigned int formulaindex;

void searchEU(State * s, untilformula * f)
{
	unsigned int MinBookmark;
	State * tarjanroot;
	unsigned int i;
	State * CurrentState, * NewState;
	bool found;

	MinBookmark = 0;
	found = false;
	CurrentState = s;
	s -> tarjanstack[f->tempindex] = s;
	tarjanroot = s; // End of Stack is recognised as self-loop
					// Thus, states not on stack can be detected through
					// nil-pointer in tarjanstack
#ifdef EXTENDEDCTL
	TemporalIndex = f -> tempindex;
#endif
	s -> checkfirelist[f->tempindex] =
#ifdef STUBBORN
	stubbornfirelistctl();
#else
	firelist();
#endif
	s -> checkparent[f->tempindex] = (State *) 0;
	s -> checkdfs[f -> tempindex] = s -> checkmin[f->tempindex] = currentdfsnum;
	s->checkcurrent[f->tempindex] = 0;
	
	while(CurrentState)
	{
		CurrentState -> value[f->index] = false;
		CurrentState -> known[f->index] = true;

		if(CurrentState -> checkfirelist[f->tempindex][CurrentState ->
							  checkcurrent[f->tempindex]])
		{
			// explore next state
			formulaindex = f -> tempindex;
			CurrentState -> checkfirelist[f->tempindex][CurrentState ->
							  checkcurrent[f->tempindex]] -> fire();
			Edges ++;
			if(!(Edges % REPORTFREQUENCY))
				cout << "st: " << NumberOfStates << "    edg: " << Edges
				<< "\n";
			if(NewState = search_marking())
			{
				// state exists
				if(NewState -> known[f->index])
				{
					// state exists, value known
					if(NewState -> value[f->index])
					{
						// state exists, value true --> witness found!
						found = true;
						CurrentState -> witness[f->tempindex] = NewState;
						CurrentState -> witnesstransition[f->tempindex]
						 = CurrentState -> checkfirelist[f->tempindex]
						 [CurrentState -> checkcurrent[f->tempindex]];
						 CurrentState -> checkfirelist[f->tempindex]
						 [CurrentState -> checkcurrent[f->tempindex]]
						 ->backfire();
						break;
					}
					else
					{
						// state exists, value false -> on stack or
						// does not model phi
						if(NewState->tarjanstack[f->tempindex])
						{
							// state exists, on stack -> set min,
							// update witness
							if(CurrentState -> checkmin[f->tempindex]
							   > NewState -> checkdfs[f->tempindex])
							{
								CurrentState -> checkmin[f->tempindex] =
								NewState -> checkdfs[f->tempindex];
								CurrentState -> witness[f->tempindex]
								= NewState;
								CurrentState -> witnesstransition[f->tempindex]
								= CurrentState -> checkfirelist[f->tempindex]
								  [CurrentState -> checkcurrent[f->tempindex]];
							}
						}
						else
						{
							// new state belongs to other scc ->
							// current state does not belong to tscc
							MinBookmark = CurrentState -> checkdfs[f->tempindex];
						}
						CurrentState -> checkfirelist[f->tempindex]
						[CurrentState -> checkcurrent[f->tempindex]]
						-> backfire();
						CurrentState -> checkcurrent[f->tempindex]++;
					}
				}
				else
				{
					// state exists, value unknown
					check(NewState,f->goal);
					if(NewState->value[f->goal->index])
					{
						// right subformula true -> witness found!
						found = true;
						CurrentState -> witness[f->tempindex] = NewState;
						CurrentState -> witnesstransition[f->tempindex]
						=  CurrentState -> checkfirelist[f->tempindex]
						   [CurrentState -> checkcurrent[f->tempindex]];
						CurrentState -> checkfirelist[f->tempindex]
						 [CurrentState -> checkcurrent[f->tempindex]]
						 ->backfire();
						break;
					}
					else
					{
						// state exists, right subformula false
						check(NewState,f->hold);
						if(NewState->value[f->hold->index])
						{
							// state exists, left true, right false
							// -> continue search
							NewState -> checkparent[f->tempindex] 
							= CurrentState;
#ifdef EXTENDEDCTL
							TemporalIndex = f -> tempindex;
#endif
							NewState -> checkfirelist[f->tempindex] =
#ifdef STUBBORN
								stubbornfirelistctl();
#else
								firelist();
#endif
							NewState -> checkdfs[f->tempindex]
							= NewState -> checkmin[f->tempindex]
							= currentdfsnum++;
							NewState -> checkcurrent[f->tempindex] = 0;
							NewState -> tarjanstack[f->tempindex] =
							tarjanroot;
							tarjanroot = NewState;
							CurrentState = NewState;
						}
						else
						{
							// state exists, left false, right false
							// -> backtracking
							CurrentState -> checkfirelist[f->tempindex]
							[CurrentState -> checkcurrent[f->tempindex]]
							-> backfire();
							CurrentState -> checkcurrent[f->tempindex]++;
						}
					}
				}
			}
			else
			{
				// state is new
				NewState = insert_marking();
				NumberOfStates ++;
				NewState -> checkcurrent[f->tempindex] = 0;
				NewState -> checkdfs[f->tempindex] 
				= NewState -> checkmin[f->tempindex] = currentdfsnum ++;
				check(NewState,f->goal);
				if(NewState->value[f->goal->index])
				{
					// right subformula true -> witness found!
					found = true;
					CurrentState -> witness[f->tempindex] = NewState;
					CurrentState -> witnesstransition[f->tempindex]
					=  CurrentState -> checkfirelist[f->tempindex]
					   [CurrentState -> checkcurrent[f->tempindex]];
					CurrentState -> checkfirelist[f->tempindex]
					 [CurrentState -> checkcurrent[f->tempindex]]
					 ->backfire();
					break;
				}
				else
				{
					// right subformula false
					check(NewState,f->hold);
					if(NewState->value[f->hold->index])
					{
						// left true, right false
						// -> continue search
						NewState -> checkparent[f->tempindex] 
						= CurrentState;
#ifdef EXTENDEDCTL
						TemporalIndex = f -> tempindex;
#endif
						NewState -> checkfirelist[f->tempindex] =
#ifdef STUBBORN
							stubbornfirelistctl();
#else
							firelist();
#endif
						NewState -> checkdfs[f->tempindex]
						= NewState -> checkmin[f->tempindex]
						= currentdfsnum++;
						NewState -> checkcurrent[f->tempindex] = 0;
						NewState -> tarjanstack[f->tempindex] =
						tarjanroot;
						tarjanroot = NewState;
						CurrentState = NewState;
					}
					else
					{
						// left false, right false
						// -> backtracking
						CurrentState -> checkfirelist[f->tempindex]
						[CurrentState -> checkcurrent[f->tempindex]]
						-> backfire();
						CurrentState -> checkcurrent[f->tempindex]++;
					}
				}
			}
		}
		else
		{
			// firelist finished: test scc, update tarjanstack,
			// check for ignored transitions,
			// return to previous state
			if(CurrentState -> checkdfs[f->tempindex] ==
			   CurrentState -> checkmin[f->tempindex])
			{

				// check if scc is tscc
				if(CurrentState -> checkdfs[f->tempindex] > MinBookmark)
				{
					// is tscc -> check for ignored transitions
					unsigned int CardIgnored;
					Transition * ignored;

					for(ignored = ignored -> StartOfEnabledList;ignored;
						ignored = ignored -> NextEnabled)
					{
						if((ignored -> lstdisabled[f->tempindex] >=
						   CurrentState -> checkdfs[f->tempindex]) &&
							(ignored -> lstfired[f->tempindex] <
							CurrentState -> checkdfs[f->tempindex]))
						{
							CardIgnored ++;
							break;
						}
					}
					if(CardIgnored)
					{
						// there are ignored transitions
						// -> fire all transitions
						int i;
#ifdef EXTENDEDCTL
						TemporalIndex = f -> tempindex;
#endif
						Transition ** newFL = firelist();
						// in ctl modelchecking, ignoring applies that
						// current firelist was reduced, i.e. singleton.
						// thus, we sort the unique already
						//fired transition to the beginning of the firelist.

						for(i=0; newFL[i] != CurrentState->checkfirelist[f->tempindex][0];i++);
						newFL[i] = newFL[0];
						newFL[0] = CurrentState -> checkfirelist[f->tempindex][0];
						delete [] CurrentState -> checkfirelist[f->tempindex];
						CurrentState -> checkfirelist[f->tempindex] = newFL;
					}
				}
						
				// scc closed: remove members from tarjanstack, value = F

				CurrentState -> value[f->index] = false;
				CurrentState -> known[f-> index] = true;
				while(tarjanroot -> checkdfs[f->tempindex] >=
					  CurrentState -> checkdfs[f->tempindex])
				{
					State * tmp;
					tmp = tarjanroot;
					tarjanroot -> witness[f->tempindex] = (State *) 0;
					if(tarjanroot == tarjanroot -> tarjanstack[f->tempindex])
					{
						tarjanroot -> tarjanstack[f->tempindex] = (State *) 0;
						break;
					}
					tarjanroot = tarjanroot -> tarjanstack[f->tempindex];
					tmp -> tarjanstack[f->tempindex] = (State *) 0;
				}
			}
			// return to previous state
			if(NewState = CurrentState -> checkparent[f->tempindex])
			{
				if(NewState -> checkmin[f->tempindex] <
				   CurrentState -> checkmin[f->tempindex])
				{
					NewState -> checkmin[f->tempindex] 
					= CurrentState -> checkmin[f->tempindex];
					NewState -> witness[f->tempindex] = CurrentState;
					NewState -> witnesstransition[f->tempindex] =
					NewState -> checkfirelist[f->tempindex]
							[NewState -> checkcurrent[f->tempindex]];
				}
				NewState -> checkfirelist[f->tempindex]
						[NewState -> checkcurrent[f->tempindex]]->backfire();
				NewState -> checkcurrent[f->tempindex]++;
			}
			CurrentState = NewState;
		}
	}
	if(found)
	{
		// set witness for current path
		while(NewState = CurrentState -> checkparent[f->tempindex])
		{
			NewState -> witness[f->tempindex] = CurrentState;
			NewState -> witnesstransition[f->tempindex] 
			= NewState -> checkfirelist[f->tempindex]
				[NewState -> checkcurrent[f->tempindex]];
			NewState -> value[f->index] = true;
			NewState -> checkfirelist[f->tempindex]
				[NewState -> checkcurrent[f->tempindex]]->backfire();
			CurrentState = NewState;
		}
		while(1)
		{
			State * tmp;
			tmp = tarjanroot;
			tarjanroot -> value[f->index] = true;
			if(tarjanroot == tarjanroot -> tarjanstack[f->tempindex]) 
			{
				tarjanroot -> tarjanstack[f->tempindex] = (State *) 0;
				break;
			}
			tarjanroot = tarjanroot -> tarjanstack[f->tempindex];
			tmp -> tarjanstack[f->tempindex] = (State *) 0;
		}
	}
}
				
void searchAU(State * s, untilformula * f)
{
	unsigned int i;
	State * CurrentState, * NewState;
	bool found;

	found = false;
	CurrentState = s;
#ifdef EXTENDEDCTL
	TemporalIndex = f -> tempindex;
#endif
	s -> checkfirelist[f->tempindex] =
#ifdef STUBBORN
	stubbornfirelistctl();
#else
	firelist();
#endif
	s->checkcurrent[f->tempindex] = 0;
	s -> checkparent[f->tempindex] = (State *) 0;
	
	while(CurrentState)
	{
		CurrentState -> value[f->index] = false;
		CurrentState -> known[f->index] = true;

		if(CurrentState -> checkfirelist[f->tempindex][CurrentState ->
							  checkcurrent[f->tempindex]])
		{
			// explore next state
			CurrentState -> checkfirelist[f->tempindex][CurrentState ->
							  checkcurrent[f->tempindex]] -> fire();
			Edges ++;
			if(!(Edges % REPORTFREQUENCY))
				cout << "st: " << NumberOfStates << "    edg: " << Edges
				<< "\n";
			if(NewState = search_marking())
			{
				// state exists
				if(NewState -> known[f->index])
				{
					// state exists, value known
					if(!NewState -> value[f->index])
					{
						// state exists, value f --> counterex found!
						// state either on stack or does not model A phi U psi
						found = true;
						CurrentState -> witness[f->tempindex] = NewState;
						CurrentState -> witnesstransition[f->tempindex]
						 = CurrentState -> checkfirelist[f->tempindex]
						 [CurrentState -> checkcurrent[f->tempindex]];
						 CurrentState -> checkfirelist[f->tempindex]
						 [CurrentState -> checkcurrent[f->tempindex]]
						 ->backfire();
						break;
					}
					else
					{
						// state exists, value true -> continue search
						CurrentState -> checkfirelist[f->tempindex]
						[CurrentState -> checkcurrent[f->tempindex]]
						-> backfire();
						CurrentState -> checkcurrent[f->tempindex]++;
					}
				}
				else
				{
					// state exists, value unknown
					check(NewState,f->goal);
					if(NewState->value[f->goal->index])
					{
						// right subformula true -> backtracking
						CurrentState -> checkfirelist[f->tempindex]
						[CurrentState -> checkcurrent[f->tempindex]]
						-> backfire();
						CurrentState -> checkcurrent[f->tempindex]++;
					}
					else
					{
						// state exists, right subformula true
						check(NewState,f->hold);
						if(NewState->value[f->hold->index])
						{
							// state exists, left true, right false
							// -> continue search
							NewState -> checkparent[f->tempindex] 
							= CurrentState;
#ifdef EXTENDEDCTL
							TemporalIndex = f -> tempindex;
#endif
							NewState -> checkfirelist[f->tempindex] =
#ifdef STUBBORN
								stubbornfirelistctl();
#else
								firelist();
#endif
							NewState -> checkcurrent[f->tempindex] = 0;
							CurrentState = NewState;
						}
						else
						{
							// state exists, left false, right false
							// -> counterex found
							found = true;
							CurrentState -> witness[f->tempindex] = NewState;
							CurrentState -> witnesstransition[f->tempindex]
							=  CurrentState -> checkfirelist[f->tempindex]
							   [CurrentState -> checkcurrent[f->tempindex]];
							CurrentState -> checkfirelist[f->tempindex]
							 [CurrentState -> checkcurrent[f->tempindex]]
							 ->backfire();
							break;
						}
					}
				}
			}
			else
			{
				// state is new
				NewState = insert_marking();
				NumberOfStates ++;
				NewState -> checkcurrent[f->tempindex] = 0;
				check(NewState,f->goal);
				if(NewState->value[f->goal->index])
				{
					// right subformula true -> backtracking!
					CurrentState -> checkfirelist[f->tempindex]
					[CurrentState -> checkcurrent[f->tempindex]]
					-> backfire();
					CurrentState -> checkcurrent[f->tempindex]++;
				}
				else
				{
					// right subformula false
					check(NewState,f->hold);
					if(NewState->value[f->hold->index])
					{
						// left true, right false
						// -> continue search
						NewState -> checkparent[f->tempindex] 
						= CurrentState;
#ifdef EXTENDEDCTL
						TemporalIndex = f -> tempindex;
#endif
						NewState -> checkfirelist[f->tempindex] =
#ifdef STUBBORN
							stubbornfirelistctl();
#else
							firelist();
#endif
						NewState -> checkcurrent[f->tempindex] = 0;
						CurrentState = NewState;
					}
					else
					{
						// left false, right false
						// -> backtracking
						found = true;
						CurrentState -> witness[f->tempindex] = NewState;
						CurrentState -> witnesstransition[f->tempindex]
						=  CurrentState -> checkfirelist[f->tempindex]
						   [CurrentState -> checkcurrent[f->tempindex]];
						CurrentState -> checkfirelist[f->tempindex]
						 [CurrentState -> checkcurrent[f->tempindex]]
						 ->backfire();
						break;
					}
				}
			}
		}
		else
		{
			// return to previous state
			CurrentState -> value[f->index] = true;
			if(NewState = CurrentState -> checkparent[f->tempindex])
			{
				NewState -> checkfirelist[f->tempindex]
						[NewState -> checkcurrent[f->tempindex]]->backfire();
				NewState -> checkcurrent[f->tempindex]++;
			}
			CurrentState = NewState;
		}
	}
	if(found)
	{
		// set witness for current path
		while(NewState = CurrentState -> checkparent[f->tempindex])
		{
			NewState -> witness[f->tempindex] = CurrentState;
			NewState -> witnesstransition[f->tempindex] 
			= NewState -> checkfirelist[f->tempindex]
				[NewState -> checkcurrent[f->tempindex]];
			NewState -> checkfirelist[f->tempindex]
				[NewState -> checkcurrent[f->tempindex]]->backfire();
			CurrentState = NewState;
		}
	}
}
				
void searchAF(State * s, unarytemporalformula * f)
{
	unsigned int i;
	State * CurrentState, * NewState;
	bool found;

	found = false;
	CurrentState = s;
#ifdef EXTENDEDCTL
	TemporalIndex = f -> tempindex;
#endif
	s -> checkfirelist[f->tempindex] =
#ifdef STUBBORN
	stubbornfirelistctl();
#else
	firelist();
#endif
	s -> checkcurrent[f->tempindex] = 0;
	s -> checkparent[f->tempindex] = (State *) 0;
	
	while(CurrentState)
	{
		CurrentState -> value[f->index] = false;
		CurrentState -> known[f->index] = true;

		if(CurrentState -> checkfirelist[f->tempindex][CurrentState ->
							  checkcurrent[f->tempindex]])
		{
			// explore next state
			CurrentState -> checkfirelist[f->tempindex][CurrentState ->
							  checkcurrent[f->tempindex]] -> fire();
			Edges ++;
			if(!(Edges % REPORTFREQUENCY))
				cout << "st: " << NumberOfStates << "    edg: " << Edges
				<< "\n";
			if(NewState = search_marking())
			{
				// state exists
				if(NewState -> known[f->index])
				{
					// state exists, value known
					if(!NewState -> value[f->index])
					{
						// state exists, value f --> counterex found!
						// state either on stack or does not model A phi U psi
						found = true;
						CurrentState -> witness[f->tempindex] = NewState;
						CurrentState -> witnesstransition[f->tempindex]
						 = CurrentState -> checkfirelist[f->tempindex]
						 [CurrentState -> checkcurrent[f->tempindex]];
						 CurrentState -> checkfirelist[f->tempindex]
						 [CurrentState -> checkcurrent[f->tempindex]]
						 ->backfire();
						break;
					}
					else
					{
						// state exists, value true -> continue search
						CurrentState -> checkfirelist[f->tempindex]
						[CurrentState -> checkcurrent[f->tempindex]]
						-> backfire();
						CurrentState -> checkcurrent[f->tempindex]++;
					}
				}
				else
				{
					// state exists, value unknown
					check(NewState,f->element);
					if(NewState->value[f->element->index])
					{
						// subformula true -> backtracking
						CurrentState -> checkfirelist[f->tempindex]
						[CurrentState -> checkcurrent[f->tempindex]]
						-> backfire();
						CurrentState -> checkcurrent[f->tempindex]++;
					}
					else
					{
						// subformula false -> continue search
						NewState -> checkparent[f->tempindex] 
						= CurrentState;
#ifdef EXTENDEDCTL
						TemporalIndex = f -> tempindex;
#endif
						NewState -> checkfirelist[f->tempindex] =
#ifdef STUBBORN
							stubbornfirelistctl();
#else
							firelist();
#endif
						NewState -> checkcurrent[f->tempindex] = 0;
						CurrentState = NewState;
					}
				}
			}
			else
			{
				// state is new
				NewState = insert_marking();
				NumberOfStates ++;
				NewState -> checkcurrent[f->tempindex] = 0;
				check(NewState,f->element);
				if(NewState->value[f->element->index])
				{
					// subformula true -> backtracking!
					CurrentState -> checkfirelist[f->tempindex]
					[CurrentState -> checkcurrent[f->tempindex]]
					-> backfire();
					CurrentState -> checkcurrent[f->tempindex]++;
				}
				else
				{
					// subformula false -> continue search
					NewState -> checkparent[f->tempindex] 
					= CurrentState;
#ifdef EXTENDEDCTL
					TemporalIndex = f -> tempindex;
#endif
					NewState -> checkfirelist[f->tempindex] =
#ifdef STUBBORN
						stubbornfirelistctl();
#else
						firelist();
#endif
					NewState -> checkcurrent[f->tempindex] = 0;
					CurrentState = NewState;
				}
			}
		}
		else
		{
			// return to previous state
			CurrentState -> value[f->index] = true;
			if(NewState = CurrentState -> checkparent[f->tempindex])
			{
				NewState -> checkfirelist[f->tempindex]
						[NewState -> checkcurrent[f->tempindex]]->backfire();
				NewState -> checkcurrent[f->tempindex]++;
			}
			CurrentState = NewState;
		}
	}
	if(found)
	{
		// set witness for current path
		while(NewState = CurrentState -> checkparent[f->tempindex])
		{
			NewState -> witness[f->tempindex] = CurrentState;
			NewState -> witnesstransition[f->tempindex] 
			= NewState -> checkfirelist[f->tempindex]
				[NewState -> checkcurrent[f->tempindex]];
			NewState -> checkfirelist[f->tempindex]
				[NewState -> checkcurrent[f->tempindex]]->backfire();
			CurrentState = NewState;
		}
	}
}
				
void searchEG(State * s, unarytemporalformula * f)
{
	unsigned int i;
	State * CurrentState, * NewState;
	bool found;

	found = false;
	CurrentState = s;
#ifdef EXTENDEDCTL
	TemporalIndex = f -> tempindex;
#endif
	s -> checkfirelist[f->tempindex] =
#ifdef STUBBORN
	stubbornfirelistctl();
#else
	firelist();
#endif
	s -> checkcurrent[f->tempindex] = 0;
	s -> checkparent[f->tempindex] = (State *) 0;
	s -> checkdfs[f -> tempindex] = s -> checkmin[f->tempindex] = 0;
	
	while(CurrentState)
	{
		CurrentState -> value[f->index] = true;
		CurrentState -> known[f->index] = true;

		if(CurrentState -> checkfirelist[f->tempindex][CurrentState ->
							  checkcurrent[f->tempindex]])
		{
			// explore next state
			CurrentState -> checkfirelist[f->tempindex][CurrentState ->
							  checkcurrent[f->tempindex]] -> fire();
			Edges ++;
			if(!(Edges % REPORTFREQUENCY))
				cout << "st: " << NumberOfStates << "    edg: " << Edges
				<< "\n";
			if(NewState = search_marking())
			{
				// state exists
				if(NewState -> known[f->index])
				{
					// state exists, value known
					if(NewState -> value[f->index])
					{
						// state exists, value t --> witness found!
						// state either on stack or models EG phi
						found = true;
						CurrentState -> witness[f->tempindex] = NewState;
						CurrentState -> witnesstransition[f->tempindex]
						 = CurrentState -> checkfirelist[f->tempindex]
						 [CurrentState -> checkcurrent[f->tempindex]];
						 CurrentState -> checkfirelist[f->tempindex]
						 [CurrentState -> checkcurrent[f->tempindex]]
						 ->backfire();
						break;
					}
					else
					{
						// state exists, value false -> continue search
						CurrentState -> checkfirelist[f->tempindex]
						[CurrentState -> checkcurrent[f->tempindex]]
						-> backfire();
						CurrentState -> checkcurrent[f->tempindex]++;
					}
				}
				else
				{
					// state exists, value unknown
					check(NewState, f ->element);
					if(!NewState->value[ f ->element->index])
					{
						// subformula false -> backtracking
						CurrentState -> checkfirelist[f->tempindex]
						[CurrentState -> checkcurrent[f->tempindex]]
						-> backfire();
						CurrentState -> checkcurrent[f->tempindex]++;
					}
					else
					{
						// subformula true -> continue search
						NewState -> checkparent[f->tempindex] 
						= CurrentState;
#ifdef EXTENDEDCTL
						TemporalIndex = f -> tempindex;
#endif
						NewState -> checkfirelist[f->tempindex] =
#ifdef STUBBORN
							stubbornfirelistctl();
#else
							firelist();
#endif
						NewState -> checkcurrent[f->tempindex] = 0;
						CurrentState = NewState;
					}
				}
			}
			else
			{
				// state is new
				NewState = insert_marking();
				NumberOfStates ++;
				NewState -> checkcurrent[f->tempindex] = 0;
				check(NewState,f ->element);
				if(!NewState->value[f ->element->index])
				{
					// subformula false -> backtracking!
					CurrentState -> checkfirelist[f->tempindex]
					[CurrentState -> checkcurrent[f->tempindex]]
					-> backfire();
					CurrentState -> checkcurrent[f->tempindex]++;
				}
				else
				{
					// subformula true -> continue search
					NewState -> checkparent[f->tempindex] 
					= CurrentState;
#ifdef EXTENDEDCTL
					TemporalIndex = f -> tempindex;
#endif
					NewState -> checkfirelist[f->tempindex] =
#ifdef STUBBORN
						stubbornfirelistctl();
#else
						firelist();
#endif
					NewState -> checkcurrent[f->tempindex] = 0;
					CurrentState = NewState;
				}
			}
		}
		else
		{
			// return to previous state
			CurrentState -> value[f->index] = false;
			if(NewState = CurrentState -> checkparent[f->tempindex])
			{
				NewState -> checkfirelist[f->tempindex]
						[NewState -> checkcurrent[f->tempindex]]->backfire();
				NewState -> checkcurrent[f->tempindex]++;
			}
			CurrentState = NewState;
		}
	}
	if(found)
	{
		// set witness for current path
		while(NewState = CurrentState -> checkparent[f->tempindex])
		{
			NewState -> witness[f->tempindex] = CurrentState;
			NewState -> witnesstransition[f->tempindex] 
			= NewState -> checkfirelist[f->tempindex]
				[NewState -> checkcurrent[f->tempindex]];
			NewState -> checkfirelist[f->tempindex]
				[NewState -> checkcurrent[f->tempindex]]->backfire();
			CurrentState = NewState;
		}
	}
}
				
				





								







	      
	  
  












#endif
