%{
#include <stdlib.h>
#include <stdio.h>
#include <assert.h>
extern int cplex();
extern void cperror(const char *, ...);
extern FILE *outfile;
%}

%union {
  char *charptr;
  int intval;
}

%token LPAREN RPAREN LSET RSET LBRACKET RBRACKET
%token SEMICOLON COMMA DEF SET
%left EQUIV
%left IMPLY
%left OR
%left AND
%left ODD
%left NOT
%left ITE
%nonassoc <charptr> ID
%nonassoc EVEN
%token TRUE FALSE
%nonassoc <intval> NUM

%start circuit
%%

circuit:
	  gate_def
	| circuit gate_def
	;

gate_def:
	  ID SEMICOLON {fprintf(outfile, "%s;\n", $1); }
	| ID DEF {fprintf(outfile, "%s := ", $1);} formula SEMICOLON
	  {fprintf(outfile, ";\n");}
        | SET {fprintf(outfile, "ASSIGN ");}
	  LSET set_list RSET SEMICOLON
	  {fprintf(outfile, ";\n");}
	;

set_list:
          ID                            {fprintf(outfile, "%s", $1); }
        | NOT ID                        {fprintf(outfile, "~%s", $2); }
        | set_list COMMA ID             {fprintf(outfile, ",%s", $3); }
        | set_list COMMA NOT ID         {fprintf(outfile, ",~%s", $4); }
        ;

formula:
	  formula EQUIV {fprintf(outfile, " == "); } formula
	| formula IMPLY {fprintf(outfile, " => "); } formula
	| formula OR {fprintf(outfile, " | "); } formula
	| formula AND {fprintf(outfile, " & "); } formula
	| formula ODD {fprintf(outfile, " ^ "); } formula
	| NOT {fprintf(outfile, "~");} formula
	| LPAREN {fprintf(outfile, "(");} formula RPAREN
	  {fprintf(outfile, ")");}
	| ID		{fprintf(outfile, "%s", $1);}
	| TRUE		{fprintf(outfile, "T"); }
	| FALSE		{fprintf(outfile, "F"); }
	| EQUIV LSET {fprintf(outfile, "EQUIV(");} formula_list RSET
	  {fprintf(outfile, ")");}
	| IMPLY LPAREN {fprintf(outfile, "IMPLY(");} formula COMMA
	  {fprintf(outfile, ",");} formula RPAREN {fprintf(outfile, ")"); }
	| ITE LPAREN {fprintf(outfile, "ITE(");}
	  formula COMMA	{fprintf(outfile, ",");} 
	  formula COMMA	{fprintf(outfile, ",");} 
	  formula RPAREN {fprintf(outfile, ")");} 
	| OR LSET {fprintf(outfile, "OR(");}
	  formula_list RSET {fprintf(outfile, ")");}
	| AND LSET {fprintf(outfile, "AND(");}
	  formula_list RSET {fprintf(outfile, ")");}
	| EVEN LSET {fprintf(outfile, "EVEN(");}
	  formula_list RSET {fprintf(outfile, ")");}
	| ODD LSET {fprintf(outfile, "ODD(");}
	  formula_list RSET {fprintf(outfile, ")");}
	| treshold_rule
        ;

formula_list:
	  formula
	| formula_list COMMA {fprintf(outfile, ",");} formula
	;

treshold_rule:
	LBRACKET NUM COMMA NUM RBRACKET LSET
	{fprintf(outfile, "[%d,%d](", $2, $4);}
	formula_list RSET {fprintf(outfile, ")"); }
	;

%%
