/*
 Copyright (C) 2002 Tommi A. Junttila
 
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License version 2
 as published by the Free Software Foundation.
 
 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.
 
 You should have received a copy of the GNU General Public License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>

char *default_program_name = "oldbc2bc";

const char *infilename = 0;
FILE *infile = stdin;

const char *outfilename = 0;
FILE *outfile = stdout;

bool verbose = false;
FILE *verbstr = stderr;

static void usage(FILE *fp, char *argv0)
{
  char *program_name;
  
  program_name = rindex(argv0, '/');
  
  if(program_name) program_name++;
  else program_name = argv0;
  
  if(!*program_name) program_name = default_program_name;
  fprintf(fp, "oldbc2bc, version 2002-03-15\n");
  fprintf(fp, "Copyright (C) 2002 Tommi Junttila\n");
  fprintf(fp,
"%s [options] [<old file>] [<new file>]\n"
"\n"
"  -v              switch verbose mode on\n"
"  <old file>  input old circuit file (if not specified stdin is used)\n"
"  <new file>  output new circuit file (if not specified stdout is used)\n"
          ,program_name);
}

static void parse_options(int argc, char ** argv)
{
  int i;
  
  for(i=1; i<argc; i++) {
    if(strcmp(argv[i], "-v") == 0 || strcmp(argv[i], "-verbose") == 0)
      verbose = true;
    else if(argv[i][0] == '-') {
      fprintf(stderr, "unknown command line argument `%s'\n", argv[i]);
      usage(stderr, argv[0]);
      exit(1);
    }
    else {
      if(infile != stdin) {
        if(outfile != stdout) {
          fprintf(stderr, "too many file arguments\n");
          usage(stderr, argv[0]);
          exit(1);
        }
        outfilename = argv[i];
        outfile = fopen(argv[i], "w");
        if(!outfile) {
          fprintf(stderr, "cannot not open `%s'\n", argv[i]);
          exit(1); }
      }
      else {
        infilename = argv[i];
        infile = fopen(argv[i], "r");
        if(!infile) {
          fprintf(stderr, "cannot not open `%s'\n", argv[i]);
          exit(1); }
      }
    }
  }
}

int main(int argc, char **argv) {
  extern int cpparse();
  extern int cprestart(FILE *);

  parse_options(argc, argv);
  
  if(verbose) {
    fprintf(verbstr, "parsing from %s\n", infilename?infilename:"stdin");
    fflush(verbstr); }
  
  /* print header line */
  fprintf(outfile, "BC1.0\n");

  /* parse and print translation */
  cprestart(infile);
  if(cpparse())
    exit(1);

  if(infilename) fclose(infile);
  if(outfilename) fclose(outfile);

  return 0;
}



void start_err(int lineno) {
  fprintf(stderr,"\n");
  /*if(input_file)fprintf(stderr,"file %s: ",input_file);*/
  if(lineno) fprintf(stderr,"line %d: ", lineno);
}

void finish_err()
{
  fprintf(stderr, "\n");
  exit(1);
}

void cperror(const char * fmt, ...)
{
  extern char *cptext;
  extern int cplineno;
  va_list ap;

  start_err(cplineno);
  va_start(ap, fmt);
  fprintf(stderr,"at token \"%s\": ", cptext);
  vfprintf(stderr, fmt, ap);
  fprintf(stderr, "\n");
  va_end(ap);
  finish_err();
}

void cprpterr(char *s)
{
  extern int cplineno;
  start_err(cplineno);
  fprintf(stderr, s);
  finish_err();
}
