%{
#include <string.h>
#include "parser.tab.h"
/*int cplineno = 1;*/
extern void cprpterr(char *);
%}
%option noyywrap
%option nounput
%option yylineno

%%
[ \t]		;
"//".*\n	cplineno++;
\n		cplineno++;
"SET"		return(SET);
"EQUIV"		return(EQUIV);
"=="		return(EQUIV);
"=>"            return(IMPLY);
"IMPLY"		return(IMPLY);
"ITE"		return(ITE);
"OR"		return(OR);
"|"		return(OR);
"AND"		return(AND);
"&"		return(AND);
"EVEN"		return(EVEN);
"ODD"		return(ODD);
"^"		return(ODD);
"NOT"		return(NOT);
"~"		return(NOT);
"("		return(LPAREN);
")"		return(RPAREN);
"{"		return(LSET);
"}"		return(RSET);
"["		return(LBRACKET);
"]"		return(RBRACKET);
";"		return(SEMICOLON);
","		return(COMMA);
":="		return(DEF);
"T"		return(TRUE);
"F"		return(FALSE);
[0-9]*[a-zA-Z_][a-zA-Z0-9_\']*	{cplval.charptr = strdup(cptext); return(ID); }
\"[^\"]+\"	{cplval.charptr = strdup(cptext); return(ID); }
[1-9][0-9]*	{cplval.intval = atoi(cptext); return(NUM); }
0		{cplval.intval = 0; return(NUM); }
.		cprpterr("illegal character");
%%
