"""
Utility to log data.
"""

import numpy
import matplotlib.pyplot as pylab
import time

class StatCollector(object):
    def __init__(self):
        self.values = {}
        self.counters = {}
        self.images = {}

        self.n_series = 0
        self.timeseries = {}
        pylab.figure(1)
        pylab.figure(2)
        pylab.ion()
        pylab.show()
        self.miny = -.1
        self.maxy = .1

        self.counting = 0
        self.img_frame = 0

    def addValue(self, tag, value):
        if tag in self.values:
            self.values[tag] += value
            self.counters[tag] += 1
        else:
            self.values[tag] = value
            self.counters[tag] = 1

    def addImage(self, tag, image):
        self.images[tag] = image

    def getValues(self):
        rvals = []
        for k,v in self.values.items():
            rvals.append( (k,1.*v/self.counters[k]))

        self.values = {}
        self.counters = {}
        return rvals

    def tic(self):
        self.counting += 1
        print (" ")
        print (" -===-   Logger Status Update [%07d]  -===- " % self.counting)
        print ("      ----------------------------------      ")
        all_values = self.getValues()
        self.n_series = len(all_values)
        for tag, value in all_values:
            if value > self.maxy:
                self.maxy = value + .1
            elif value < self.miny:
                self.miny = value - .1
            print ("%20s = %05.3f" % (tag, value))
            if tag in self.timeseries:
                self.timeseries[tag].append(value)
            else:
                self.timeseries[tag] = [value]



    def step(self):
        pylab.figure(1)
        pylab.clf()
        plot_id = 1
        for tag, value in self.timeseries.items():
            ax = pylab.subplot(self.n_series, 1, plot_id)
            ax.plot(value, 'k')
            ax.set_ylim((self.miny,self.maxy))
            ax.set_title(tag)
            plot_id += 1

        images = self.images.items()
        for img_id in xrange(len(images)):
            name, img = images[img_id]
            if img.ndim == 2:
                pylab.matshow(img, fignum = 2+img_id, cmap='gray')
                pylab.title(name + " frame %03d" % self.img_frame)
            else:
                pylab.matshow(img, fignum = 2+img_id)
                pylab.title(name + " frame %03d" % self.img_frame)


        if len(images) > 0:
            pylab.pause(.01)
            self.img_frame += 1
        else:
            pylab.pause(.001)
            self.img_frame = 0
        self.images = {}

    def wait(self):
        pylab.show()


