function grad_descent(x0,f,alpha)
%grad_descent   Gradient descent method  
%   GRAD_DESCENT(X0,F,LOGF,ALPHA), for a given symbolic objective   
%   function F with starting point X0 and learning rate ALPHA,   
%   performs gradient descent method and visualizes gradient trajectory

% termination tolerance
tol = 1e-6;

% maximum number of allowed iterations
maxiter = 100;

% minimum allowed perturbation
dxmin = 1e-6;

% learning rate
%alpha = 0.4;

% initialize gradient norm, optimization vector, iteration counter, perturbation
gnorm = inf; X = x0; niter = 0; dx = inf;

% define symbolic variables
syms x y 

% define symbolic gradient function
logf = log(f);
g = gradient(logf, [x, y]);

% visualize function and gradient descent trajectory
figure(),
ezcontour(f,[.5,2.5],60); hold on,

% gradient descent algorithm
while gnorm>=tol && niter <= maxiter && dx >= dxmin
    % calculate current gradient
    G = eval(subs(g, [x y], {X}));
    gnorm = norm(G);
    xnew = X + alpha.*G';
    plot([X(1) xnew(1)],[X(2) xnew(2)],'ko-'), hold on
    pause(0.01);
    niter = niter + 1;
    dx = norm(xnew-X);
    X = xnew;
end

plot(X(1),X(2),'*r');
hold off;
title('Gradient Descent Method');
legend('f(x)','Trajectory','Location', 'NorthEast');
set(gca, 'XTick', [.5, 2.5] , ...
    'XTickLabel', {'', ''}      , ...
    'YTick', []                 , ...
    'FontSize', 12             , ...
    'Box', 'on'                 , ...
    'LineWidth',1               );

axis([.5 2.5 .5 2.5]);
