function momentum(x0,addnoise,alpha)
%momentum   Gradient descent with momentum  
%   MOMENTUM(X0,ADDNOISE), for a given starting point X0, performs  
%   momentum method on built-in symbolic objective function with 
%   gaussian noise (ADDNOISE>0) or without gaussian noise (ADDNOISE==0) 
%   and learning rate ALPHA, and visualizes gradient trajectory

% termination tolerance
tol = 1e-6;

% maximum number of allowed iterations
maxiter = 100;

% minimum allowed perturbation
dxmin = 1e-6;

% learning rate
%alpha = 0.4;

% initialize gradient norm, optimization vector, iteration counter, perturbation
gnorm = inf; X= x0; niter = 0; dx = inf;

% define symbolic objective function
f = @(x,y) exp(-(x.*y-1.5).^2/(2*0.02)-x.^2-y.^2);
% define symbolic partial derivatives of the objective function
dfx = @(x,y) - 2*x - 50*y*(x*y - 3/2);
dfy = @(x,y) - 2*y - 50*x*(x*y - 3/2);
m = [0 0]; 

figure,
ezcontour(f,[.5,2.5],60); hold on,
while gnorm>=tol && niter <= maxiter && dx >= dxmin
    G(1) = dfx(X(1),X(2));
    G(2) = dfy(X(1),X(2));
    if (addnoise>0)
        G = G + addnoise*randn(size(G));
    end
    % current update as a convex combination of the gradient and the previous update
    m = 0.9*m + 0.1*G;
    gnorm = norm(G);
    xnew = X + alpha.*m;
    plot([X(1) xnew(1)],[X(2) xnew(2)],'ko-'), hold on
    pause(0.01);
    
    niter = niter + 1;
    dx = norm(xnew-X);
    X = xnew;
end
plot(X(1),X(2),'*r');
if (addnoise>0)
    title('Momentum Method on function with Gaussian noise')
else
    title('Momentum Method on function without noise');
end
%end
hold off;
legend('f(x)','Trajectory','Location', 'NorthEast');
set(gca, 'XTick', [.5, 2.5] , ...
    'XTickLabel', {'', ''}      , ...
    'YTick', []                 , ...
    'FontSize', 12             , ...
    'Box', 'on'                 , ...
    'LineWidth',1               );




