clear all;
close all;

% define symbolic variables and functions 
syms x y 
f = exp(-(x.*y-1.5).^2/(2*0.02)-x.^2-y.^2);

figure(1),

annotation('textarrow',[.518,.518],[0.15,.9]);hold on
annotation('textarrow',[0.25,.8],[.518,.518]);
text(0,0,'[0,0]','HorizontalAlignment','center','BackgroundColor',[1 1 1]);

ezcontour(f,[-3,3],700);
axis equal;hold off
legend('f(x)', 'Location', 'NorthWest');
title('Objective Function');
set(gca, 'XTick', [-3, 3] , ...
    'XTickLabel', {'', ''}      , ...
    'YTick', []                 , ...
    'FontSize', 12             , ...
    'Box', 'on'                 , ...
    'LineWidth',1               );


%% Visualize Gradient

% define symbolic gradient function
syms x y 
f = exp(-(x.*y-1.5).^2/(2*0.02)-x.^2-y.^2);
logf = -(x.*y-1.5).^2/(2*0.02)-x.^2-y.^2;

g = gradient(logf, [x, y]);

g2 = (hessian(logf)+0*[1 0;0 1])^-1*gradient(logf);
[X, Y] = meshgrid(0:.05:3,0:.05:3);

figure(2),
ezcontour(f,[.5,2.5],60); hold on,

G1 = subs(g(1), [x y], {X,Y});
G2 = subs(g(2), [x y], {X,Y});
G1norm = G1 ./ sqrt(G1.^2+G2.^2);
G2norm = G2 ./ sqrt(G1.^2+G2.^2);
quiver(X, Y, G1norm, G2norm);
title('1st Order Gradient');hold off

legend('f(x)','Gradient','Location', 'NorthEast');
set(gca, 'XTick', [.5, 2.5] , ...
    'XTickLabel', {'', ''}      , ...
    'YTick', []                 , ...
    'FontSize', 12             , ...
    'Box', 'on'                 , ...
    'LineWidth',1               );
axis([.5 2.5 .5 2.5]);

figure(3),
ezcontour(f,[.5,2.5],60); hold on,
G3 = subs(g2(1), [x y], {X,Y});
G4 = subs(g2(2), [x y], {X,Y});
G3norm = -G3 ./ sqrt(G3.^2+G4.^2);
G4norm = -G4 ./ sqrt(G3.^2+G4.^2);

quiver(X, Y, G3norm, G4norm);hold off
title('2nd Order Gradient');
legend('f(x)','Gradient','Location', 'NorthEast');
set(gca, 'XTick', [.5, 2.5] , ...
    'XTickLabel', {'', ''}      , ...
    'YTick', []                 , ...
    'FontSize', 12             , ...
    'Box', 'on'                 , ...
    'LineWidth',1               );
axis([.5 2.5 .5 2.5]);

%% Gradient Descent Method
syms x y 
f = exp(-(x.*y-1.5).^2/(2*0.02)-x.^2-y.^2);

x0 =  [1.7 1];
grad_descent(x0,f,0.01); % try 0.01, 0.015

%% Momentum Method
x0 =  [1.7 1];
momentum(x0,0,0.03);

%% Momentum method for optimizing objective function with noise
x0 =  [1.7 1];
momentum(x0,3,0.03);



