function [net, alphas, oldies] = ...
    updatepcanet(net, netexp, netvar, alphas, oldies)
% UPDATEPCANET Updatenet for Bayesian PCA
%
% See also: UPDATENET

% Antti Honkela 1999

w1vnew = .5 ./ netvar.w1;
w1estep = -w1vnew .* netexp.w1;
b1vnew = .5 ./ netvar.b1;
b1estep = -b1vnew .* netexp.b1;

alphas.w1 = alphas.w1 .* (.8 + .25 * (sign(w1estep) == oldies.w1));
alphas.b1 = alphas.b1 .* (.8 + .25 * (sign(b1estep) == oldies.b1));

alphas.w1 = cut(alphas.w1, 1, .001);
alphas.b1 = cut(alphas.b1, 1, .001);

oldies.w1 = sign(w1estep);
oldies.b1 = sign(b1estep);

w1estep = alphas.w1 .* w1estep;
b1estep = alphas.b1 .* b1estep;

w1estep = cut(w1estep, 10, -10);
b1estep = cut(b1estep, 10, -10);
  
net.w1 = probdist(net.w1.e + w1estep, w1vnew);
net.b1 = probdist(net.b1.e + b1estep, b1vnew);
