function v = kldivpca(mydata, mysources, data, net, noisevari, ...
		      sourcevar, missing)
% KLDIVPCA  Kullback-Leibler divergence for Bayesian PCA
%
% See also: KLDIV

% Antti Honkela 1999
if nargin < 7,
  missing = sparse(size(mydata, 1), size(mydata, 2));
end;

noisevar = exp(2*(noisevari.e - noisevari.var));
weightvar = 1;
net.b1 = probdist(net.b1.e(:,1), net.b1.var(:,1));
% mydata.var = mydata.var - mydata.var .* missing;
mydata(find(missing)) = probdist(0, 0);
notmissing = size(mydata, 2) - sum(missing, 2);
sizedata = prod(size(mydata)) - sum(sum(missing));

% 3rd row was    sum(noisevari.e) * size(mydata, 2) + ...
v = -.5 * prod(size(mysources)) -.5 * sum(sum(log(2*pi*mysources.var))) + ...
    .5 * log(2*pi) * sizedata + ...
    sum(noisevari.e .* notmissing) + ...
    .5 * sum(sum((data - mydata.e).^2 + mydata.var, 2) ./ noisevar) + ...
    .5 * log(prod(2*pi*sourcevar)) * size(mysources, 2) + ...
    .5 * sum(sum(mysources.e.^2 + mysources.var, 2) ./ sourcevar);

if nargin == 4
  v = v + ...
      .5 * log(2*pi*weightvar) * prod(size(net.w1)) + ...
      .5 / weightvar * sum(sum(net.w1.e.^2 + net.w1.var)) + ...
      .5 * log(2*pi*weightvar) * prod(size(net.b1)) + ...
      .5 / weightvar * sum(sum(net.b1.e.^2 + net.b1.var));
end
