function [s, b, V, D] = pcanan(x, noise)
% do linear PCA, when data might have NaN -values.
% 
% Usage:
%    [s, b, V, D] = PCANAN(data, noise)
%    returns scaled PCA components of data, biases and the
%    transformation matrices. Noise is the variance of data, which
%    should be set nonzero in case of missing values.

% (c) Tapani Raiko 2000

% Remove the means from the data and calculate covariance matrix
[su, n] = sumnan(x, 2);
% average b is removed
b = su ./ n;
xn = x - repmat(b, 1, size(x, 2));
covm = covnan(x');

% Calculate eigenvalues and vectors and sort by eigenvalues
[V0, D0] = eig(covm);
[S, I] = sort(-diag(D0));
S = -S;

% Normalize sources and sort transformation matrix
V1 = V0 * sqrt(D0);
V = V1(:, I);

s = zeros(size(xn));
for q = 1:size(xn, 2),
  xn2 = zeros(size(xn, 1), 1);
  V2 = zeros(size(V));
  truenumbers = find(~isnan(xn(:, q)));
  V2(truenumbers, :) = V(truenumbers, :);
  xn2(truenumbers) = xn(truenumbers, q);
  s(:, q) = inv(noise * eye(size(V2, 2)) + V2' * V2)...
	    * (V2' * xn2);
end

D = S;