function [transf, bias, sources, kls] = pcaiter(data, dim, iters)

pcadim = dim;
outdim = size(data, 1);
updatesrcs = -10;
updatenet = 0;
updatenoisevar = 0;

missing = sparse(isnan(data));
[pcasources, pcabias, pcaV, pcaD] = nanpca(data, pcadim);
data(find(missing)) = 0;

sources = probdist(pcasources, .0001 * ones(size(pcasources)));
nsources = size(sources, 1);

pcanet.w1 = probdist(pcaV(:,1:pcadim), ...
		     .0001 * ones(size(data, 1), pcadim));
pcanet.b1 = probdist(pcabias, ... % * ones(1,size(data,2)),...
		     .0001 * ones(size(data)));

sourcevar = pcaD(1:pcadim);

oldies.w1 = zeros(size(pcanet.w1));
oldies.b1 = zeros(size(pcanet.b1));

alphas.w1 = .1*ones(size(pcanet.w1));
alphas.b1 = .1*ones(size(pcanet.b1));

noisevar = probdist(.5 * log(.1) * ones(outdim, 1), zeros(outdim, 1));

kls = [];
effsou = (mean(pcanet.w1.e .^2 , 1)' .* mean(sources.e .^2, 2)).^0.25;
for j=1:iters
  pcax = pcanet.w1*sources + pcanet.b1;

  [srcexp, srcvar, netexp, netvar] =...
      feedbackpca(pcax, pcanet, sources, data, noisevar, sourcevar, ...
		  missing);

  newkl = kldivpca(pcax, sources, data, pcanet, noisevar, sourcevar, ...
		      missing);
  kls = [kls newkl]; 
	 
  disp(['Iteration #' num2str(length(kls)) ': ' num2str(newkl)])

  newsources = updatepcasources(sources, srcexp, srcvar);

  if updatesrcs < 0
    updatesrcs = updatesrcs + 1;
    sources = probdist(sources.e, newsources.var);
  else
    sources = newsources;
  end

  [newnet, alphas, oldies] =...
      updatepcanet(pcanet, netexp, netvar, alphas, oldies);

  if updatenet < 0
    updatenet = updatenet + 1;
  else
    pcanet = newnet;
  end

  if updatenoisevar < 0
    updatenoisevar = updatenoisevar + 1;
  else
    noisevar = calcnoisevar(data, pcax, missing);
  end

  sourcevar = mean((sources.e .^2 + sources.var)')';
  
  foundsources = sources.e;
  foundvariances = sources.var;
  
  effsou = [effsou (mean(pcanet.w1.e .^2 , 1)' .* mean(sources.e .^2, 2)).^0.25];
end

pcax = pcanet.w1*sources + pcanet.b1;

newkls = kldivpca(pcax, sources, data, pcanet, noisevar, sourcevar, ...
		  missing);
disp(['Finally after ' num2str(length(kls)) ' iterations: ' num2str(newkls)])

transf = pcanet.w1;
bias = pcanet.b1;
