/**
 * Noiz
 * (c) Kenta Cho (cs8k-cyu@asahi-net.or.jp)
 * http://www.asahi-net.or.jp/~cs8k-cyu/
 *
 * noiz.h(header file)
 */
#include "noiz_rsc.h"

#define TRUE 1
#define FALSE 0
#define randomize() SysRandom(TimGetTicks())
#define randN(N) ((((long) SysRandom(0)) * N) / ((long) sysRandomMax + 1))

#define BULLET_NOT_EXIST -9999

typedef struct {
  int x, y, mx, my;
} Point;

typedef struct {
  Point point0, point1;
  Point prvPoint0, prvPoint1;
  Boolean vctChk;
} Bullet;

#define CTTYPE_MAX 12
#define HISTORY_NUM 4

typedef struct {
  int level;
  int miss;
} History;

typedef struct {
  int ctTypeQue[2][CTTYPE_MAX];
  int cttqStatus[2];
  int cttqSelect;
  int level;
  int miss;
  int lvlTime;
  History history[HISTORY_NUM];
} PrefData;

typedef struct {
  void (*curtainMaker)(int); 
  int maxRank;
} CurtainType;

typedef struct {
  void (*curtainMaker)(int); 
  int rank;
} Curtain;

#define CURTAIN_MAX 8

typedef struct {
  Curtain curtain[CURTAIN_MAX];
  int curtainNmb;
  int lvlTime;
  int level;
  int miss;
} LevelStatus;

#define TITLE 0
#define GAME_IN_PROGRESS 1

typedef struct {
  int status;
} GameStatus;
