/**
 * Noiz
 * (c) Kenta Cho (cs8k-cyu@asahi-net.or.jp)
 * http://www.asahi-net.or.jp/~cs8k-cyu/
 *
 * noiz.c(main routine)
 */

#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#include "noiz.h"

static UInt autoOffTime;

#include "sincos.c"
#include "displaymanager.c"
#include "gamemanager.c"

static int StartApplication(void) {
  Boolean exist;
  autoOffTime = SysSetAutoOffTime(0);
  randomize();
  createScreenBuffer();
  loadBitmaps();
  exist = PrefGetAppPreferencesV10(NOIZ_CID, 1, &prefData, sizeof(prefData));
  initGame();
  if ( exist ) {
    getPrefData();
  } else {
    resetGameStatus();
  }
}

static void StopApplication(void) {
  SysSetAutoOffTime(autoOffTime);
  unloadBitmaps();
  setLevelMissData();
  PrefSetAppPreferencesV10(NOIZ_CID, 1, &prefData, sizeof(prefData));
}

/**
 * event hanlder for title form
 */
static Boolean TitleFormHandleEvent(EventPtr event) {
  Boolean handled = FALSE;
  switch ( event->eType ) {
  case ctlSelectEvent:
    if ( event->data.ctlEnter.controlID == START_BUTTON ) {
      startButtonPushed();
      handled = TRUE;
    } else if ( event->data.ctlEnter.controlID == RESET_BUTTON ) {
      if ( FrmAlert(RESET_DIALOG) == 0 ) {
	resetGameStatus();
	drawTitle();
      }
      handled = TRUE;
    }
    break;
  case frmOpenEvent:
    FrmDrawForm(FrmGetActiveForm());
    drawTitle();
    handled = TRUE;
    break;
  }
  return handled;
}

/**
 * event hanlder for main form
 */
static Boolean MyFormHandleEvent(EventPtr event) {
  SWord px, py;
  Boolean pd;

  Boolean handled = FALSE;
  switch ( event->eType ) {
  case frmOpenEvent:
    FrmDrawForm(FrmGetActiveForm());
    startGame();
    handled = TRUE;
    break;
  }
  return handled;
}

/**
 * activate forms
 */
static Boolean ApplicationHandleEvent(EventPtr event) {
  FormPtr frm;
  Int formID;
  Boolean handled = FALSE;

  if ( event->eType == frmLoadEvent ) {
    formID = event->data.frmLoad.formID;
    frm = FrmInitForm(formID);
    FrmSetActiveForm(frm);
    switch ( formID ) {
    case MAIN_FORM:
      FrmSetEventHandler(frm, MyFormHandleEvent);
      break;
    case TITLE_FORM:
      FrmSetEventHandler(frm, TitleFormHandleEvent);
      break;
    }
    handled = TRUE;
  }
  return handled;
}

// event loop interval
#define INTERVAL 10

static void EventLoop(void) {
  EventType event;
  Word error;
  long ntc, tc;
  int itv;
  ntc = TimGetTicks() + INTERVAL;
  startDrawOffscreen();
  do {
    itv = ntc - TimGetTicks();
    if ( itv < 0 ) itv = 0;
    if ( itv > INTERVAL ) itv = INTERVAL;
    EvtGetEvent(&event, itv);
    if ( !SysHandleEvent(&event) ) {
      if ( !ApplicationHandleEvent(&event) ) {
	if ( gameStatus.status != GAME_IN_PROGRESS ) {
	  FrmDispatchEvent(&event);
	}
      }
    }
    tc = TimGetTicks();
    if ( tc >= ntc ) {
      if ( gameStatus.status == GAME_IN_PROGRESS ) {
	handleGameStatus();
      }
      //ntc = tc + INTERVAL;
      ntc = ((tc+ntc)>>1) + INTERVAL;
    }
  } while ( event.eType != appStopEvent );
}

DWord PilotMain(Word cmd, Ptr cmdPBP, Word launchFlags) {
  if ( cmd != sysAppLaunchCmdNormalLaunch ) return 0;
  StartApplication();
  EventLoop();
  StopApplication();
  return 0;
}
