/**
 * Noiz
 * (c) Kenta Cho (cs8k-cyu@asahi-net.or.jp)
 * http://www.asahi-net.or.jp/~cs8k-cyu/
 *
 * gamemanager.c(manage game status)
 */

static GameStatus gameStatus;
static long gameStartSecond;
static int xp, yp, pxp, pyp;

static CurtainType ctType[2][CTTYPE_MAX];
static int ctTypeQue[2][CTTYPE_MAX];
static int cttqStatus[2];
static int cttqSelect;
static LevelStatus levelStatus;

static int timer = 0;

static PrefData prefData;

#include "curtainmakers.c"

/**
 * get preference data
 */
static void getPrefData() {
  int i, j;
  for ( i=0 ; i<2 ; i++ ) {
    for ( j=0 ; j<CTTYPE_MAX ; j++ ) {
      ctTypeQue[i][j] = prefData.ctTypeQue[i][j];
    }
    cttqStatus[i] = prefData.cttqStatus[i];
  }
  cttqSelect = prefData.cttqSelect;
  levelStatus.level = prefData.level;
  levelStatus.miss = prefData.miss;
  levelStatus.lvlTime = prefData.lvlTime;
}

/**
 * make preference data
 */
static void makePrefData() {
  int i, j;
  for ( i=0 ; i<2 ; i++ ) {
    for ( j=0 ; j<CTTYPE_MAX ; j++ ) {
       prefData.ctTypeQue[i][j] = ctTypeQue[i][j];
    }
    prefData.cttqStatus[i] = cttqStatus[i];
  }
  prefData.cttqSelect = cttqSelect;
  prefData.level = levelStatus.level;
  prefData.miss = levelStatus.miss;
  prefData.lvlTime = levelStatus.lvlTime;
}

/**
 * handle level/miss histories
 */

static void setLevelMissData() {
  prefData.history[0].level = prefData.level+1;
  prefData.history[0].miss = levelStatus.miss;
}

static void setHistory() {
  int i;
  for ( i=HISTORY_NUM-1 ; i>=2 ; i-- ) {
    prefData.history[i].level = prefData.history[i-1].level;
    prefData.history[i].miss = prefData.history[i-1].miss;
  }
  prefData.history[1].level = levelStatus.level; 
  prefData.history[1].miss = levelStatus.miss;
}

/**
 * set curtain type function and max rank
 */
static void initCurtainType() {
  ctType[0][0].curtainMaker = &aimFire;
  ctType[0][0].maxRank = 7;
  ctType[0][1].curtainMaker = &vctFire;
  ctType[0][1].maxRank = 10;
  ctType[0][2].curtainMaker = &extendFire;
  ctType[0][2].maxRank = 10;
  ctType[0][3].curtainMaker = &diaFire;
  ctType[0][3].maxRank = 12;
  ctType[0][4].curtainMaker = &aimLaser;
  ctType[0][4].maxRank = 5;
  ctType[0][5].curtainMaker = &rippleFire;
  ctType[0][5].maxRank = 14;
  ctType[0][6].curtainMaker = &srkVctFire;
  ctType[0][6].maxRank = 10;
  ctType[0][7].curtainMaker = &goutFire;
  ctType[0][7].maxRank = 8;
  ctType[0][8].curtainMaker = &prlFire;
  ctType[0][8].maxRank = 4;
  ctType[0][9].curtainMaker = &rndRollFire;
  ctType[0][9].maxRank = 6;
  ctType[0][10].curtainMaker = &splayFire;
  ctType[0][10].maxRank = 8;
  ctType[0][11].curtainMaker = &aimVrtFire;
  ctType[0][11].maxRank = 5;

  ctType[1][0].curtainMaker = &vrtLaser;
  ctType[1][0].maxRank = 4;
  ctType[1][1].curtainMaker = &rndFire;
  ctType[1][1].maxRank = 8;
  ctType[1][2].curtainMaker = &winder;
  ctType[1][2].maxRank = 10;
  ctType[1][3].curtainMaker = &rdmFire;
  ctType[1][3].maxRank = 3;
  ctType[1][4].curtainMaker = &beeWinder;
  ctType[1][4].maxRank = 8;
  ctType[1][5].curtainMaker = &rollFire;
  ctType[1][5].maxRank = 10;
  ctType[1][6].curtainMaker = &boxFire;
  ctType[1][6].maxRank = 4;
  ctType[1][7].curtainMaker = &beeFire;
  ctType[1][7].maxRank = 12;
  ctType[1][8].curtainMaker = &siegeWinder;
  ctType[1][8].maxRank = 5;
  ctType[1][9].curtainMaker = &vrtRdmFire;
  ctType[1][9].maxRank = 5;
  ctType[1][10].curtainMaker = &rdmLaser;
  ctType[1][10].maxRank = 5;
  ctType[1][11].curtainMaker = &rndVctFire;
  ctType[1][11].maxRank = 7;
}

static void resetGameStatus() {
  int i, j;
  for ( i=0 ; i<2 ; i++ ) {
    for ( j=0 ; j<CTTYPE_MAX ; j++ ) {
      ctTypeQue[i][j] = j;
    }
  }
  prefData.level = levelStatus.level = 0;
  levelStatus.miss = 0;
  cttqStatus[0] = cttqStatus[1] = 0;
  cttqSelect = 0;
  for ( i=1 ; i<HISTORY_NUM ; i++ ) {
    prefData.history[i].level = -1;
  }
  prefData.history[0].level = 1;
  prefData.history[0].miss = 0;
}

static void drawNum(int n, int x, int y) {
  int i;
  x += 18;
  for ( i=0 ; i<3 ; i++ ) {
    WinDrawBitmap(objectBitmapPtr[n%10], x, y);
    n /= 10;
    if ( n <= 0 ) break;
    x -= 9;
  }
}

static void drawTitle() {
  int i, y = 75;
  clearRectangle(0, y, 160, 40);
  WinDrawBitmap(objectBitmapPtr[NOW_BITMAP-FIRST_BITMAP_ID], 1, y);
  for ( i=0 ; i<HISTORY_NUM ; i++ ) {
    if ( prefData.history[i].level > 0 ) {
      WinDrawBitmap(objectBitmapPtr[LEVEL_BITMAP-FIRST_BITMAP_ID], 25, y);
      drawNum(prefData.history[i].level, 66, y);
      drawNum(prefData.history[i].miss, 96, y);
      WinDrawBitmap(objectBitmapPtr[MISS_BITMAP-FIRST_BITMAP_ID], 126, y);
      y += 10;
    } else {
      break;
    }
  }
}

static int drawLevelCount = 0;

static void drawLevel() {
  WinDrawBitmap(objectBitmapPtr[LEVEL_BITMAP-FIRST_BITMAP_ID], 0, 0);
  drawNum(levelStatus.level, 41, 0);
  drawLevelCount--;
}

static void startDrawLevel() {
  drawLevelCount = 20;
}

static int drawMissCount = 0;

static void drawMiss() {
  WinDrawBitmap(objectBitmapPtr[MISS_BITMAP-FIRST_BITMAP_ID], 130, 0);
  drawNum(levelStatus.miss, 100, 0);
  drawMissCount--;
}

static void startDrawMiss() {
  drawMissCount = 20;
}

static void gotoTitle() {
  gameStatus.status = TITLE;
  FrmGotoForm(TITLE_FORM);
}

static void initGame() {
  levelStatus.level = -1;
  initCurtainType();
  gotoTitle();
}

static void startButtonPushed() {
  FrmGotoForm(MAIN_FORM);
}

static void resetBullets() {
  int i;
  for ( i=0 ; i<BULLET_MAX ; i++ ) {
    bullet[i].point0.mx = BULLET_NOT_EXIST;
  }
}

/**
 * rotate curtain type que
 */
static void rollCurtainTypeQue(int ctq[CTTYPE_MAX], int *status, int rDiv) {
  int i;
  int ctptr = ctq[0];
  if ( *status == 0 ) {
    for ( i=0 ; i<CTTYPE_MAX-1 ; i++ ) {
      ctq[i] = ctq[i+1];
    }
    ctq[CTTYPE_MAX-1] = ctptr;
    *status = 1;
  } else {
    int idx = (CTTYPE_MAX/rDiv)*(rDiv-1);
    for ( i=0 ; i<idx ; i++ ) {
      ctq[i] = ctq[i+1];
    }
    ctq[idx] = ctptr;
    *status = 0;
  }
}

#define MIXED_CURTAIN_PRM 96
#define LEVEL_TIME 80
#define LEVEL_TIME_MIN 50

/**
 * go to next leven and set curtain type
 */
static void gotoNextLevel() {
  int i;
  long lvl;
  int lvlPrm;
  CurtainType ct;
  makePrefData();
  levelStatus.level++;

  timer = 0;
  levelStatus.lvlTime = LEVEL_TIME;

  ct = ctType[0][ctTypeQue[0][0]];
  rollCurtainTypeQue(ctTypeQue[0], &(cttqStatus[0]), 2);
  lvl = levelStatus.level;
  levelStatus.curtainNmb = 1;
  if ( lvl <= ct.maxRank ) {
    levelStatus.curtain[0].curtainMaker = ct.curtainMaker;
    levelStatus.curtain[0].rank = lvl;
    return;
  } else {
    levelStatus.curtain[0].curtainMaker = ct.curtainMaker;
    levelStatus.curtain[0].rank = ct.maxRank;
  }
  lvl = (lvl<<8)/ct.maxRank;
  for ( i=1 ; i<CURTAIN_MAX ; i++ ) {
    CurtainType ct;
    ct = ctType[cttqSelect][ctTypeQue[cttqSelect][0]];
    rollCurtainTypeQue
      (ctTypeQue[cttqSelect], &(cttqStatus[cttqSelect]), cttqSelect+2);
    cttqSelect = (cttqSelect+1)&1;
    lvlPrm = 256 + ct.maxRank*MIXED_CURTAIN_PRM;
    levelStatus.curtainNmb++;
    if ( lvl <= lvlPrm ) {
      int rnk;
      levelStatus.curtain[i].curtainMaker = ct.curtainMaker;
      rnk = (lvl-256)/MIXED_CURTAIN_PRM;
      if ( rnk < 1 ) rnk = 1;
      levelStatus.curtain[i].rank = rnk;
      return;
    } else {
      levelStatus.curtain[i].curtainMaker = ct.curtainMaker;
      levelStatus.curtain[i].rank = ct.maxRank;
      lvl <<= 8;
      lvl /= lvlPrm;
    }
  }
}
  
/**
 * restart this level
 */
static void resetLevel() {
  timer = 0;
  prefData.lvlTime -= 2;
  if ( prefData.lvlTime < LEVEL_TIME_MIN ) {
    prefData.lvlTime = LEVEL_TIME_MIN;
  }
  resetBullets();
  getPrefData();
  gotoNextLevel();
}

static void startGame() {
  gameStatus.status = GAME_IN_PROGRESS;
  xp = 80<<4; yp = 120<<4;
  pxp = xp+1; pyp = yp;
  resetBullets();
  gotoNextLevel();
  startDrawLevel();
  gameStartSecond = TimGetSeconds();
}

static void addBullets() {
  int i;
  for ( i=0 ; i<levelStatus.curtainNmb ; i++ ) {
    levelStatus.curtain[i].curtainMaker(levelStatus.curtain[i].rank);
  }
}

#define SCREEN_WIDTH_16 2560
#define SCREEN_HEIGHT_16 2560

static void moveBullets() {
  Bullet *bl;
  int i;
  for ( i=0 ; i<BULLET_MAX ; i++ ) {
    bl = &bullet[i];
    if ( bl->point0.mx != BULLET_NOT_EXIST ) {
      if ( bl->vctChk ) {
	bl->prvPoint0 = bl->point0;
	bl->prvPoint1 = bl->point1;
      }
      bl->point0.x += bl->point0.mx;
      bl->point0.y += bl->point0.my;
      bl->point1.x += bl->point1.mx;
      bl->point1.y += bl->point1.my;
      if ( (bl->point0.x < 0 || bl->point0.x >= SCREEN_WIDTH_16 
	    || bl->point0.y < 0 || bl->point0.y >= SCREEN_HEIGHT_16 ) &&
	   (bl->point1.x < 0 || bl->point1.x >= SCREEN_WIDTH_16
	    || bl->point1.y < 0 || bl->point1.y >= SCREEN_HEIGHT_16 ) ) {
	bl->point0.mx = BULLET_NOT_EXIST;
      } else {
	WinDrawLine((bl->point0.x>>4), (bl->point0.y>>4), 
		    (bl->point1.x>>4), (bl->point1.y>>4));
      }
    }
  }
}

static void hitBullet() {
  prefData.miss++;
  resetLevel();
  startDrawMiss();
}

#define CLS_WIDTH 10

#define POWER_OFF_TICKS_LENGTH 300
static int powerOffTicks = POWER_OFF_TICKS_LENGTH;

/**
 * move pen position and check collision
 */
static void movePen() {
  SWord px, py;
  Boolean pd;
  int i;
  Bullet *bl;
  int a1x, a1y, a2x, a2y, b1x, b1y, b2x, b2y;
  long a, b, c, d, e, f, dnm;
  long mk;
  int x, y;

  pxp = xp; pyp = yp;
  EvtGetPen(&px, &py, &pd);
  if ( pd ) {
    if ( py < SCREEN_HEIGHT ) {
      xp = (px<<4)+8; yp = (py<<4)+8;
    }
    //EvtResetAutoOffTimer();
    if ( powerOffTicks <= 0 ) {
      SysSetAutoOffTime(0);
    }
    powerOffTicks = POWER_OFF_TICKS_LENGTH;
  } else {
    powerOffTicks--;
    if ( powerOffTicks == 0 ) {
      SysSetAutoOffTime(autoOffTime);
    }
  }
  WinDrawLine(pxp>>4, pyp>>4, xp>>4, yp>>4);
  if ( xp==pxp && yp==pyp ) {
    pxp = xp+1;
  }

  if ( xp < pxp ) {
    a1x =  xp-CLS_WIDTH; a2x = pxp+CLS_WIDTH;
  } else {
    a1x = pxp-CLS_WIDTH; a2x =  xp+CLS_WIDTH;
  }
  if ( yp < pyp ) {
    a1y =  yp-CLS_WIDTH; a2y = pyp+CLS_WIDTH;
  } else {
    a1y = pyp-CLS_WIDTH; a2y =  yp+CLS_WIDTH;
  }
  for ( i=0 ; i<BULLET_MAX ; i++ ) {
    bl = &bullet[i];
    if ( bl->point0.mx != BULLET_NOT_EXIST ) {
      if ( bl->vctChk ) {
	a = bl->point0.y - bl->point1.y;
	b = bl->point1.x - bl->point0.x;
	c = (long)bl->point1.x*bl->point0.y 
	  - (long)bl->point1.y*bl->point0.x;
	mk = a*pxp + b*pyp - c; 
	if ( mk > 0 ) mk = 1;
	else mk = -1;

	a = bl->prvPoint0.y - bl->prvPoint1.y;
	b = bl->prvPoint1.x - bl->prvPoint0.x;
	c = (long)bl->prvPoint1.x*bl->prvPoint0.y 
	  - (long)bl->prvPoint1.y*bl->prvPoint0.x;
	mk *= (a*pxp + b*pyp - c);

	if ( mk < 0 ) {
	  a = bl->point0.y - bl->prvPoint0.y;
	  b = bl->prvPoint0.x - bl->point0.x;
	  c = (long)bl->prvPoint0.x*bl->point0.y 
	    - (long)bl->prvPoint0.y*bl->point0.x;
	  mk = a*pxp + b*pyp - c;
	  if ( mk > 0 ) mk = 1;
	  else mk = -1;
	  a = bl->point1.y - bl->prvPoint1.y;
	  b = bl->prvPoint1.x - bl->point1.x;
	  c = (long)bl->prvPoint1.x*bl->point1.y 
	    - (long)bl->prvPoint1.y*bl->point1.x;
	  mk *= (a*pxp + b*pyp - c);
	  if ( mk < 0 ) {
	    hitBullet();
	    return;
	  }
	}
      }
      if ( bl->point0.y < bl->point1.y ) {
	b1y = bl->point0.y-CLS_WIDTH; b2y = bl->point1.y+CLS_WIDTH;
      } else {
	b1y = bl->point1.y-CLS_WIDTH; b2y = bl->point0.y+CLS_WIDTH;
      }
      if ( a2y>=b1y && b2y>=a1y ) {
	if ( bl->point0.x < bl->point1.x ) {
	  b1x = bl->point0.x-CLS_WIDTH; b2x = bl->point1.x+CLS_WIDTH;
	} else {
	  b1x = bl->point1.x-CLS_WIDTH; b2x = bl->point0.x+CLS_WIDTH;
	}
	if ( a2x>=b1x && b2x>=a1x ) {
	  a = yp - pyp;
	  b = pxp - xp;
	  c = (long)pxp*yp - (long)pyp*xp;
	  d = bl->point0.y - bl->point1.y;
	  e = bl->point1.x - bl->point0.x;
	  f = (long)bl->point1.x*bl->point0.y 
	    - (long)bl->point1.y*bl->point0.x;
	  dnm = b*d - a*e;
	  if ( dnm != 0 ) {
	    x = (b*f - c*e) / dnm;
	    y = (c*d - a*f) / dnm;
	    if ( a1x<=x && x<=a2x && a1y<=y && y<=a2y &&
		 b1x<=x && x<=b2x && b1y<=y && y<=b2y ) {
	      hitBullet();
	      return;
	    }
	  }
	}
      }
    }
  }
}

static void handleGameStatus() {
  movePen();
  endDrawOffscreen();
  flipDisplay();
  startDrawOffscreen();
  clearDisplay();
  if ( drawLevelCount > 0 ) drawLevel();
  if ( drawMissCount > 0 ) drawMiss();
  addBullets();
  moveBullets();
  if ( gameStatus.status == GAME_IN_PROGRESS ) {
    timer++;
    if ( timer >= levelStatus.lvlTime ) {
      gotoNextLevel();
      if ( (levelStatus.level%25)==0 ) {
	setHistory();
      }
      startDrawLevel();
    }
  }
}
