/**
 * Noiz
 * (c) Kenta Cho (cs8k-cyu@asahi-net.or.jp)
 * http://www.asahi-net.or.jp/~cs8k-cyu/
 *
 * displaymanager.c(handle screen buffer)
 */

WinHandle screenBufferH;
RectangleType sourceBounds;

#define SCREEN_WIDTH 160
#define SCREEN_HEIGHT 160

// bitmap handlers
static VoidHand objectBitmapHandles[bitmapTypeCount];
static BitmapPtr objectBitmapPtr[bitmapTypeCount];
static WinHandle objectWindowHandles[bitmapTypeCount];

/**
 * create off screen buffer
 */
static void createScreenBuffer() {
  Word error;
  WinHandle oldDrawWinH;

  screenBufferH = WinCreateOffscreenWindow
    (SCREEN_WIDTH, SCREEN_HEIGHT, screenFormat, &error);
  sourceBounds.topLeft.x = sourceBounds.topLeft.y = 0;
  sourceBounds.extent.x = SCREEN_WIDTH;
  sourceBounds.extent.y = SCREEN_HEIGHT;
  oldDrawWinH = WinGetDrawWindow();
  WinSetDrawWindow(screenBufferH);
  WinEraseRectangle(&sourceBounds, 0);
  WinSetDrawWindow(oldDrawWinH);
}

static void clearDisplay() {
  WinEraseRectangle(&sourceBounds, 0);
}

static WinHandle oldDrawWinH;

static void startDrawOffscreen() {
  oldDrawWinH = WinGetDrawWindow();
  WinSetDrawWindow(screenBufferH);
}

static void endDrawOffscreen() {
  WinSetDrawWindow(oldDrawWinH);
}

static void flipDisplay() {
  WinCopyRectangle
    (screenBufferH, 0, &sourceBounds, 0, 0, scrCopy);
} 

/**
 * load bitmaps and hold these handlers
 */
static void loadBitmaps() {
  int i;
  WinHandle oldDrawWinH;
  Word error;
  oldDrawWinH = WinGetDrawWindow();
  for ( i=0; i<bitmapTypeCount; i++ ) {
    objectBitmapHandles[i] = DmGetResource(bitmapRsc, FIRST_BITMAP_ID+i);
    objectBitmapPtr[i] = MemHandleLock(objectBitmapHandles[i]);
    objectWindowHandles[i] = WinCreateOffscreenWindow
      (objectBitmapPtr[i]->width, objectBitmapPtr[i]->height,
       screenFormat, &error);
    ErrFatalDisplayIf(error, "Error loading images");
    WinSetDrawWindow(objectWindowHandles[i]);
    WinDrawBitmap(objectBitmapPtr[i], 0, 0);
  }
  WinSetDrawWindow(oldDrawWinH);
}

/**
 * relase bitmap handlers
 */
static void unloadBitmaps() {
  int i;
  for ( i=0; i<bitmapTypeCount; i++ ) {
    MemPtrUnlock(objectBitmapPtr[i]);
    DmReleaseResource(objectBitmapHandles[i]);
    if (objectWindowHandles[i]) 
      WinDeleteWindow(objectWindowHandles[i], false);
  }
}

static void clearRectangle(int x, int y, int width, int height)  {
  RectangleType rect;
  rect.topLeft.x = x;
  rect.topLeft.y = y;
  rect.extent.x = width;
  rect.extent.y = height;
  WinEraseRectangle(&rect, 0);
}
