/**
 * Noiz
 * (c) Kenta Cho (cs8k-cyu@asahi-net.or.jp)
 * http://www.asahi-net.or.jp/~cs8k-cyu/
 *
 * curtainmakers.c(make curtain fire)
 */

#define BULLET_MAX 128

static Bullet bullet[BULLET_MAX];
static int bulletIdx = BULLET_MAX-1;

static int getDeg(int x, int y) {
  long tx, ty;
  int f, od, tn;
  if ( x==0 && y==0 ) {
    return 0;
  }

  if ( x < 0 ) {
    tx = -x;
    if ( y < 0 ) {
      ty = -y;
      if ( tx > ty ) {
	f = 1;
	od = DIV*3/4; tn = ty*256/tx;
      } else {
	f = -1;
	od = DIV; tn = tx*256/ty;
      }
    } else {
      ty = y;
      if ( tx > ty ) {
	f = -1;
	od = DIV*3/4; tn=ty*256/tx;
      } else {
	f=1;
	od = DIV/2; tn=tx*256/ty;
      }
    }
  } else {
    tx = x;
    if ( y < 0 ) {
      ty = -y;
      if ( tx > ty ) {
	f = -1;
	od = DIV/4; tn = ty*256/tx;
      } else {
	f = 1;
	od = 0; tn = tx*256/ty;
      }
    } else {
      ty = y;
      if ( tx > ty ) {
	f = 1;
	od = DIV/4; tn = ty*256/tx;
      } else {
	f = -1;
	od = DIV/2; tn = tx*256/ty;
      }
    }
  }
  return(od+tantbl[tn]*f);
}

static Bullet* nextBullet() {
  Bullet *bl;
  if ( bullet[bulletIdx].point0.mx != BULLET_NOT_EXIST ) {
    int i;
    for ( i=0 ; i<BULLET_MAX ; i++ ) {
      bulletIdx--; if ( bulletIdx < 0 ) bulletIdx += BULLET_MAX;
      if ( bullet[bulletIdx].point0.mx == BULLET_NOT_EXIST ) break;
    }
    if ( i == BULLET_MAX ) return 0;
  }
  bl = &bullet[bulletIdx];
  bulletIdx--; if ( bulletIdx < 0 ) bulletIdx += BULLET_MAX;
  return bl;
}

#define AIMFIRE_DEG 4

static void aimFire(int rank) {
  int d;
  int i;
  Bullet *bl;
  int x, y;

  if ( (timer&7) != 0 ) return;
  x = randN(160<<4); y = randN(32<<4);
  d = getDeg(xp-x, yp-y); 
  d -= (rank-1)*AIMFIRE_DEG;
  if ( d < 0 ) d += 256; 
  for ( i=0 ; i<rank ; i++ ) {
    if ( (bl = nextBullet()) == 0 ) return;
    if ( d >= 256 ) d -= 256;
    bl->point0.x = x; bl->point0.y = y;
    bl->point1.x = x + ((sintbl[d]*4)>>4); 
    bl->point1.y = y - ((costbl[d]*4)>>4);
    bl->point0.mx = bl->point1.mx = (sintbl[d]*4)>>4;
    bl->point0.my = bl->point1.my = -(costbl[d]*4)>>4;
    bl->vctChk = FALSE;
    d += AIMFIRE_DEG*2; 
  }
}

static void extendFire(int rank) {
  int d;
  int i;
  Bullet *bl;
  int x, y;
  int r;

  if ( (timer&15) != 2 ) return;
  r = (rank-3)/3; if ( r < 0 ) r = 0;
  x = randN(160<<4); y = randN(32<<4);
  d = getDeg(xp-x, yp-y); 
  d -= r*AIMFIRE_DEG*2;
  if ( d < 0 ) d += 256; 
  for ( i=-r ; i<=r ; i++ ) {
    if ( (bl = nextBullet()) == 0 ) return;
    if ( d >= 256 ) d -= 256;
    bl->point0.x = bl->point1.x = x;
    bl->point0.y = bl->point1.y = y;
    bl->point0.mx = (sintbl[d]*4)>>4;
    bl->point0.my = -(costbl[d]*4)>>4;
    bl->point1.mx = bl->point0.mx*(3-abs(i)+6)/6;
    bl->point1.my = bl->point0.my*(3-abs(i)+6)/6;
    bl->vctChk = FALSE;
    d += AIMFIRE_DEG*2; 
  }
}

static void vctFire(int rank) {
  int d;
  int d1, d2;
  Bullet *bl;
  int x, y;

  if ( (timer&7) != 4 ) return;
  if ( (bl = nextBullet()) == 0 ) return;
  x = randN(160<<4); y = randN(32<<4);
  d = getDeg(xp-x, yp-y); 
  d1 = d-4;
  if ( d1 < 0 ) d1 += 256;
  else if ( d1 >= 256 ) d1 -= 256;
  d2 = d+4;
  if ( d2 < 0 ) d2 += 256;
  else if ( d2 >= 256 ) d2 -= 256;
  bl->point0.x = bl->point1.x = x;
  bl->point0.y = bl->point1.y = y;
  if ( rank <= 5 ) {
    bl->point0.mx = (sintbl[d1]*4)>>4;
    bl->point0.my = -(costbl[d1]*4)>>4;
    bl->point1.mx = (sintbl[d2]*4)>>4;
    bl->point1.my = -(costbl[d2]*4)>>4;
  } else {
    bl->point0.mx = (sintbl[d1]*6)>>4;
    bl->point0.my = -(costbl[d1]*6)>>4;
    bl->point1.mx = (sintbl[d2]*6)>>4;
    bl->point1.my = -(costbl[d2]*6)>>4;
  }
  bl->point0.x += bl->point0.mx;
  bl->point0.y += bl->point0.my;
  bl->point1.x += bl->point1.mx;
  bl->point1.y += bl->point1.my;
  bl->vctChk = TRUE;
}

static void diaFire(int rank) {
  int d;
  int d1, d2;
  Bullet *bl;
  int x, y;
  int wd = 3;

  if ( (timer&15) != 6 ) return;
  if ( (bl = nextBullet()) == 0 ) return;
  x = randN(160<<4); y = randN(32<<4);
  d = getDeg(xp-x, yp-y); 
  if ( rank >= 10 ) wd = 9;
  else if ( rank >= 6 ) wd = 6;
  d1 = d-wd;
  if ( d1 < 0 ) d1 += 256;
  else if ( d1 >= 256 ) d1 -= 256;
  d2 = d+wd;
  if ( d2 < 0 ) d2 += 256;
  else if ( d2 >= 256 ) d2 -= 256;
  bl->point0.x = bl->point1.x = x;
  bl->point0.y = bl->point1.y = y;
  bl->point0.mx = (sintbl[d]*18)>>6;
  bl->point0.my = -(costbl[d]*18)>>6;
  bl->point1.mx = (sintbl[d1]*17)>>6;
  bl->point1.my = -(costbl[d1]*17)>>6;
  bl->point0.x += bl->point0.mx;
  bl->point0.y += bl->point0.my;
  bl->point1.x += bl->point1.mx;
  bl->point1.y += bl->point1.my;
  bl->vctChk = TRUE;
  if ( (bl = nextBullet()) == 0 ) return;
  bl->point0.x = bl->point1.x = x;
  bl->point0.y = bl->point1.y = y;
  bl->point0.mx = (sintbl[d]*18)>>6;
  bl->point0.my = -(costbl[d]*18)>>6;
  bl->point1.mx = (sintbl[d2]*17)>>6;
  bl->point1.my = -(costbl[d2]*17)>>6;
  bl->point0.x += bl->point0.mx;
  bl->point0.y += bl->point0.my;
  bl->point1.x += bl->point1.mx;
  bl->point1.y += bl->point1.my;
  bl->vctChk = TRUE;
  if ( (bl = nextBullet()) == 0 ) return;
  bl->point0.x = bl->point1.x = x;
  bl->point0.y = bl->point1.y = y;
  bl->point0.mx = (sintbl[d]*16)>>6;
  bl->point0.my = -(costbl[d]*16)>>6;
  bl->point1.mx = (sintbl[d1]*17)>>6;
  bl->point1.my = -(costbl[d1]*17)>>6;
  bl->point0.x += bl->point0.mx;
  bl->point0.y += bl->point0.my;
  bl->point1.x += bl->point1.mx;
  bl->point1.y += bl->point1.my;
  bl->vctChk = FALSE;
  if ( (bl = nextBullet()) == 0 ) return;
  bl->point0.x = bl->point1.x = x;
  bl->point0.y = bl->point1.y = y;
  bl->point0.mx = (sintbl[d]*16)>>6;
  bl->point0.my = -(costbl[d]*16)>>6;
  bl->point1.mx = (sintbl[d2]*17)>>6;
  bl->point1.my = -(costbl[d2]*17)>>6;
  bl->point0.x += bl->point0.mx;
  bl->point0.y += bl->point0.my;
  bl->point1.x += bl->point1.mx;
  bl->point1.y += bl->point1.my;
  bl->vctChk = FALSE;
}

static void aimLaser(int rank) {
  int d;
  Bullet *bl;
  int x, y;

  if ( (timer&7) != 1 ) return;
  x = randN(160<<4); y = 0;
  d = getDeg(xp-x, yp-y); 
  if ( d >= 256 ) d -= 256;
  if ( (bl = nextBullet()) == 0 ) return;
  bl->point0.x = x; bl->point0.y = y;
  bl->point1.x = x - ((sintbl[d]*(10+5*rank))>>4); 
  bl->point1.y = y + ((costbl[d]*(10+5*rank))>>4);
  bl->point0.mx = bl->point1.mx = (sintbl[d]*6)>>4;
  bl->point0.my = bl->point1.my = -(costbl[d]*6)>>4;
  bl->vctChk = FALSE;
}

static int rfx, rfy, rfmx, rfmy, rfspd;

static void rippleFire(int rank) {
  int d;
  Bullet *bl;
  int rpNmb = 16-5;
  if ( rank >= 11 ) rpNmb = 16-12;
  else if ( rank >= 6 ) rpNmb = 16-8;
  
  if ( (timer&15) == 0 ) {
    rfx = randN(120<<4)+(20<<4); rfy = randN(32<<4)+(16<<4);
    d = randN(256);
    rfmx = (sintbl[d]*5)>>4; rfmy = -(costbl[d]*5)>>4;
    rfspd = 16;
  }
  if ( (timer&15) < rpNmb ) return;
  if ( (bl = nextBullet()) == 0 ) return;
  d = getDeg(xp-rfx, yp-rfy); 
  if ( d >= 256 ) d -= 256;
  bl->point0.x = rfx; bl->point0.y = rfy;
  bl->point1.x = rfx + ((sintbl[d]*4)>>4); 
  bl->point1.y = rfy - ((costbl[d]*4)>>4);
  bl->point0.mx = bl->point1.mx = (sintbl[d]*rfspd)>>6;
  bl->point0.my = bl->point1.my = -(costbl[d]*rfspd)>>6;
  bl->vctChk = FALSE;
  rfx += rfmx; rfy += rfmy;
  rfspd++;
}

static void srkVctFire(int rank) {
  int d;
  Bullet *bl;
  int x, y;
  int vw;
  int i;
  int mx, my;

  if ( (timer&7) != 3 ) return;
  if ( (bl = nextBullet()) == 0 ) return;
  x = randN(160<<4); y = randN(32<<4);
  d = getDeg(xp-x, yp-y); 
  if ( d >= 256 ) d -= 256;
  vw = (rank/2)*6 + 8;
  mx = ((costbl[d]*vw)>>4)/4;
  my = ((sintbl[d]*vw)>>4)/4;
  x -= mx*2; y -= my*2;
  for ( i=0 ; i<5 ; i++ ) {
    if ( (bl = nextBullet()) == 0 ) return;
    d = getDeg(xp-x, yp-y); 
    if ( d >= 256 ) d -= 256;
    bl->point0.x = x; bl->point0.y = y;
    bl->point1.x = x + ((sintbl[d]*4)>>4); 
    bl->point1.y = y - ((costbl[d]*4)>>4);
    bl->point0.mx = bl->point1.mx = (sintbl[d]*4)>>4;
    bl->point0.my = bl->point1.my = -(costbl[d]*4)>>4;
    bl->vctChk = FALSE;
    x += mx ; y += my;
  }
}

static void goutFire(int rank) {
  int d;
  int d1, d2;
  int i;
  Bullet *bl;
  int x, y;

  if ( (timer&15) != 5 ) return;
  if ( (bl = nextBullet()) == 0 ) return;
  x = randN(160<<4); y = randN(32<<4);
  d = getDeg(xp-x, yp-y); 
  if ( d >= 256 ) d -= 256;
  bl->point0.x = bl->point1.x = x;
  bl->point0.y = bl->point1.y = y;
  if ( rank <= 4 ) {
    bl->point0.mx = (sintbl[d]*5)>>4;
    bl->point0.my = -(costbl[d]*5)>>4;
    bl->point1.mx = (sintbl[d]*7)>>4;
    bl->point1.my = -(costbl[d]*7)>>4;
  } else {
    bl->point0.mx = (sintbl[d]*6)>>4;
    bl->point0.my = -(costbl[d]*6)>>4;
    bl->point1.mx = (sintbl[d]*8)>>4;
    bl->point1.my = -(costbl[d]*8)>>4;
  }
  bl->vctChk = FALSE;
  for ( i=0 ; i<9 ; i++ ) {
    int td, spd;
    if ( (bl = nextBullet()) == 0 ) return;
    td = d + randN(16)-8;
    if ( td < 0 ) td += 256; 
    if ( td >= 256 ) td -= 256;
    bl->point0.x = x; bl->point0.y = y;
    bl->point1.x = x + ((sintbl[td]*6)>>4); 
    bl->point1.y = y - ((costbl[td]*6)>>4);
    if ( rank <= 4 ) {
      spd = randN(8)+20;
    } else {
      spd = randN(8)+24;
    }
    bl->point0.mx = bl->point1.mx = (sintbl[td]*spd)>>6;
    bl->point0.my = bl->point1.my = -(costbl[td]*spd)>>6;
    bl->vctChk = FALSE;
  }
}

static void prlFire(int rank) {
  int d;
  Bullet *bl;
  int x, y;
  int i;
  int mx, my;
  int sp;

  if ( (timer&7) != 0 ) return;
  x = randN(160<<4); y = randN(32<<4);
  d = getDeg(xp-x, yp-y); 
  if ( d >= 256 ) d -= 256;
  sp = 3 + rank;
  mx = ((costbl[d]*4)>>4);
  my = ((sintbl[d]*4)>>4);
  x -= mx; y -= my;
  for ( i=0 ; i<2 ; i++ ) {
    if ( (bl = nextBullet()) == 0 ) return;
    bl->point0.x = x; bl->point0.y = y;
    bl->point1.x = x + ((sintbl[d]*sp)>>4); 
    bl->point1.y = y - ((costbl[d]*sp)>>4);
    bl->point0.mx = bl->point1.mx = (sintbl[d]*sp)>>4;
    bl->point0.my = bl->point1.my = -(costbl[d]*sp)>>4;
    bl->vctChk = FALSE;
    x += mx*2; y += my*2;
  }
}

static int rrfcx, rrfcy, rrfd;

static void rndRollFire(int rank) {
  int d;
  Bullet *bl;
  int cnt;
  int bn, wd;

  bn = rank+1; 
  cnt = (timer&15);
  if ( cnt >= bn ) return;
  wd = 4+rank;
  if ( cnt == 0 ) {
    rrfcx = randN(128<<4)+(16<<4); rrfcy = randN(24<<4)+(8<<4);
    rrfd = getDeg(xp-rrfcx, yp-rrfcy); 
    if ( rrfd >= 256 ) rrfd -= 256;
  }
  d = 128*cnt/bn;
  if ( (bl = nextBullet()) == 0 ) return;
  bl->point0.x = rrfcx + ((sintbl[d]*wd)>>4); 
  bl->point0.y = rrfcy + ((costbl[d]*wd)>>6);
  bl->point1.x = bl->point0.x + ((sintbl[rrfd]*5)>>4); 
  bl->point1.y = bl->point0.y - ((costbl[rrfd]*5)>>4);
  bl->point0.mx = bl->point1.mx = (sintbl[rrfd]*5)>>4;
  bl->point0.my = bl->point1.my = -(costbl[rrfd]*5)>>4;
  bl->vctChk = FALSE;
  d += 128;
  if ( (bl = nextBullet()) == 0 ) return;
  bl->point0.x = rrfcx + ((sintbl[d]*wd)>>4); 
  bl->point0.y = rrfcy - ((costbl[d]*wd)>>6);
  bl->point1.x = bl->point0.x + ((sintbl[rrfd]*5)>>4); 
  bl->point1.y = bl->point0.y - ((costbl[rrfd]*5)>>4);
  bl->point0.mx = bl->point1.mx = (sintbl[rrfd]*5)>>4;
  bl->point0.my = bl->point1.my = -(costbl[rrfd]*5)>>4;
  bl->vctChk = FALSE;
}

static int slfx, slfy, slfd;

static void splayFire(int rank) {
  int d;
  int i;
  Bullet *bl;
  int x, y;
  int bn, sp;
  int cnt;

  cnt = (timer&15);
  bn = rank+1;
  if ( cnt >= bn ) return;
  sp = 4+cnt;
  if ( cnt == 0 ) {
    slfx = randN(160<<4); slfy = randN(32<<4);
    d = slfd = getDeg(xp-slfx, yp-slfy);
  } else {
    d = slfd - 48*cnt/bn;
    if ( d < 0 ) d += 256; 
    if ( (bl = nextBullet()) == 0 ) return;
    bl->point0.x = slfx; bl->point0.y = slfy;
    bl->point1.x = slfx + ((sintbl[d]*sp)>>4); 
    bl->point1.y = slfy - ((costbl[d]*sp)>>4);
    bl->point0.mx = bl->point1.mx = (sintbl[d]*sp)>>4;
    bl->point0.my = bl->point1.my = -(costbl[d]*sp)>>4;
    bl->vctChk = FALSE;
    d = slfd + 48*cnt/bn;
  }
  if ( (bl = nextBullet()) == 0 ) return;
  if ( d >= 256 ) d -= 256;
  bl->point0.x = slfx; bl->point0.y = slfy;
  bl->point1.x = slfx + ((sintbl[d]*sp)>>4); 
  bl->point1.y = slfy - ((costbl[d]*sp)>>4);
  bl->point0.mx = bl->point1.mx = (sintbl[d]*sp)>>4;
  bl->point0.my = bl->point1.my = -(costbl[d]*sp)>>4;
  bl->vctChk = FALSE;
}

static void aimVrtFire(int rank) {
  int d;
  int i;
  Bullet *bl;
  int x, y;

  if ( (timer&15) != 4 ) return;
  x = randN(120<<4)+(20<<4); y = randN(16<<4)+(16<<4);
  for ( i=0 ; i<rank ; i++ ) {
    if ( (bl = nextBullet()) == 0 ) return;
    x += randN(1024)-512; y += randN(256)-128;
    d = getDeg(xp-x, yp-y); 
    if ( d >= 256 ) d -= 256;
    bl->point0.x = x; bl->point0.y = y;
    bl->point1.x = x;
    bl->point1.y = y + 96;
    bl->point0.mx = bl->point1.mx = (sintbl[d]*5)>>4;
    bl->point0.my = bl->point1.my = -(costbl[d]*5)>>4;
    bl->vctChk = TRUE;
    d += AIMFIRE_DEG*2; 
  }
}


#define VL_SPEED 12

static int vlx[4] = {20<<4, 50<<4, 80<<4, 110<<4};

static void vrtLaser(int rank) {
  int i;
  Bullet *bl;

  if ( (timer&31) == 0 ) {
    for ( i=0 ; i<rank ; i++ ) {
      vlx[i] = randN(160)<<4;
    }
  }  
  if ( (timer&31) > 22 ) return;
  for ( i=0 ; i<rank ; i++ ) {
    if ( (bl = nextBullet()) == 0 ) return;
    bl->point0.x = bl->point1.x = vlx[i];
    bl->point0.y = 0;
    bl->point1.y = -(VL_SPEED<<4);
    bl->point0.mx = bl->point1.mx = 0;
    bl->point0.my = bl->point1.my = (VL_SPEED<<4);
    bl->vctChk = FALSE;
  }
}

static int wdrDeg = 128;
static int wdCnt = 0;

static void winder(int rank) {
  int d;
  int i;
  Bullet *bl;
  int x, y;
  int wdOfs;
  int wdNmb = rank/2;
  if ( wdNmb < 1 ) wdNmb = 1;

  x = (80<<4); y = 0;
  d = wdrDeg;
  if ( wdNmb > 1 ) {
    wdOfs = 100/wdNmb;
    d -= (wdNmb-1)*wdOfs/2;
  }
  if ( d < 0 ) d += 256; 
  for ( i=0 ; i<wdNmb ; i++ ) {
    if ( (bl = nextBullet()) == 0 ) return;
    if ( d >= 256 ) d -= 256;
    bl->point0.x = x; bl->point0.y = y;
    bl->point1.x = x + ((sintbl[d]*8)>>4); 
    bl->point1.y = y - ((costbl[d]*8)>>4);
    bl->point0.mx = bl->point1.mx = (sintbl[d]*8)>>4;
    bl->point0.my = bl->point1.my = -(costbl[d]*8)>>4;
    bl->vctChk = FALSE;
    d += wdOfs; 
  }
  if ( wdCnt<6 || wdCnt>=34 ) wdrDeg += 2;
  else if ( wdCnt>=14 && wdCnt<26 ) wdrDeg -= 2;
  wdCnt++; if ( wdCnt >= 40 ) wdCnt -= 40;
}

static int bwDeg = 0;
static int bwCnt = 0;

static void beeWinder(int rank) {
  int d;
  Bullet *bl;
  int x, y;
  int degMag = rank/2;
  if ( degMag <= 0 ) degMag = 1;

  x = (80<<4); y = 0;
  d = 152-bwDeg*degMag;
  if ( (bl = nextBullet()) == 0 ) return;
  bl->point0.x = x; bl->point0.y = y;
  bl->point1.x = x + ((sintbl[d]*8)>>4); 
  bl->point1.y = y - ((costbl[d]*8)>>4);
  bl->point0.mx = bl->point1.mx = (sintbl[d]*8)>>4;
  bl->point0.my = bl->point1.my = -(costbl[d]*8)>>4;
  bl->vctChk = FALSE;
  d = 104+bwDeg*degMag;
  if ( (bl = nextBullet()) == 0 ) return;
  bl->point0.x = x; bl->point0.y = y;
  bl->point1.x = x + ((sintbl[d]*8)>>4); 
  bl->point1.y = y - ((costbl[d]*8)>>4);
  bl->point0.mx = bl->point1.mx = (sintbl[d]*8)>>4;
  bl->point0.my = bl->point1.my = -(costbl[d]*8)>>4;
  bl->vctChk = FALSE;

  if ( bwCnt<5 || bwCnt>=15 ) bwDeg++;
  else bwDeg--;
  bwCnt++; if ( bwCnt >= 20 ) bwCnt -= 20;
}

static int bfCntOfs[4] = {0, 32, 16, 48};

static void boxFire(int rank) {
  int d;
  Bullet *bl;
  int x, y;
  int i;
  int cnt;

  for ( i=0 ; i<rank ; i++ ) {
    cnt = (timer+bfCntOfs[i])&63;
    if ( cnt < 16 ) {
      x = cnt*10; y = 0;
      d = 128 + cnt*4;
    } else if ( cnt < 32 ) {
      cnt -= 16;
      x = 159; y = cnt*10;
      d = 192 + cnt*4;
    } else if ( cnt < 48 ) {
      cnt -= 32;
      x = 159 - cnt*10; y = 159;
      d = 32 + cnt*2;
    } else {
      cnt -= 48;
      x = 0; y = 159 - cnt*10;
      d = 96 + cnt*2;
    }
    x <<= 4; y <<= 4;
    if ( (bl = nextBullet()) == 0 ) return;
    bl->point0.x = x; bl->point0.y = y;
    bl->point1.x = x + ((sintbl[d]*12)>>4); 
    bl->point1.y = y - ((costbl[d]*12)>>4);
    bl->point0.mx = bl->point1.mx = (sintbl[d]*12)>>4;
    bl->point0.my = bl->point1.my = -(costbl[d]*12)>>4;
    bl->vctChk = FALSE;
  }
}

static int rndOfsTbl[4] = {80, 55, 40, 35};

static void rndFire(int rank) {
  int d;
  Bullet *bl;
  int x;
  int i;
  int xofs;
  
  int ridx = (rank/2)-1; if ( ridx < 0 ) ridx = 0;
  xofs = rndOfsTbl[ridx];
  x = (timer&31)*5;
  if ( x!=0 && (x%xofs) == 0 ) {
    d = 64;
    for ( i=0 ; i<14 ; i++ ) {
      if ( (bl = nextBullet()) == 0 ) return;
      d += 8;
      bl->point0.x = (x<<4); bl->point0.y = 0;
      bl->point1.x = (x<<4) + ((sintbl[d]*4)>>4); 
      bl->point1.y = - ((costbl[d]*4)>>4);
      bl->point0.mx = bl->point1.mx = (sintbl[d]*4)>>4;
      bl->point0.my = bl->point1.my = -(costbl[d]*4)>>4;
      bl->vctChk = FALSE;
    }
  }
}

static int rlfx = 80, rlfy = 10;

static void rollFire(int rank) {
  int d;
  Bullet *bl;
  int i;
  int cnt;
  int dofs;

  cnt = (timer&31);
  if ( cnt == 0 ) {
    rlfx = (randN(80)+40)<<4; rlfy = (randN(32)+16)<<4;
  }
  dofs = 512/rank;
  d = cnt*8;
  for ( i=0 ; i<(rank/2) ; i++ ) {
    if ( (bl = nextBullet()) == 0 ) return;
    bl->point0.x = rlfx; bl->point0.y = rlfy;
    bl->point1.x = rlfx + ((sintbl[d]*4)>>4); 
    bl->point1.y = rlfy - ((costbl[d]*4)>>4);
    bl->point0.mx = bl->point1.mx = (sintbl[d]*4)>>4;
    bl->point0.my = bl->point1.my = -(costbl[d]*4)>>4;
    bl->vctChk = FALSE;
    d += dofs; if ( d >= 256 ) d -= 256;
  }
}

static void rdmFire(int rank) {
  int d;
  Bullet *bl;
  int x, y;

  if ( (timer&3) > rank ) return;
  x = randN(160<<4); y = randN(32<<4);
  d = randN(160) + 48;
  if ( (bl = nextBullet()) == 0 ) return;
  bl->point0.x = x; bl->point0.y = y;
  bl->point1.x = x + ((sintbl[d]*4)>>4); 
  bl->point1.y = y - ((costbl[d]*4)>>4);
  bl->point0.mx = bl->point1.mx = (sintbl[d]*4)>>4;
  bl->point0.my = bl->point1.my = -(costbl[d]*4)>>4;
  bl->vctChk = FALSE;
}

static void beeFire(int rank) {
  int d;
  Bullet *bl;
  int x, y;
  int i;

  if ( (timer&15) >= (rank/2) ) return;
  switch ( randN(4) ) {
  case 0:
  case 1:
    x = randN(160<<4); y = randN(16<<4);
    d = 104;
    break;
  case 2:
    //x = randN(16<<4); y = randN(160<<4);
    //d = 40;
    x = randN(16<<4); y = randN(120<<4);
    d = 50;
    break;
  case 3:
    //x = (160<<4)-1-randN(16<<4); y = randN(160<<4);
    //d = 168;
    x = (160<<4)-1-randN(16<<4); y = randN(120<<4);
    d = 158;
    break;
  }
  for ( i=0 ; i<3 ; i++ ) {
    if ( (bl = nextBullet()) == 0 ) return;
    bl->point0.x = x; bl->point0.y = y;
    bl->point1.x = x + ((sintbl[d]*4)>>4); 
    bl->point1.y = y - ((costbl[d]*4)>>4);
    bl->point0.mx = bl->point1.mx = (sintbl[d]*4)>>4;
    bl->point0.my = bl->point1.my = -(costbl[d]*4)>>4;
    bl->vctChk = FALSE;
    d += 24;
  }
}

static void siegeWinder(int rank) {
  int d;
  Bullet *bl;
  int x, y;
  int sd = (8-rank)*4;

  x = (80<<4); y = 0;
  d = getDeg(xp-x, yp-y); 
  d -= sd;
  if ( d < 0 ) d += 256;
  if ( (bl = nextBullet()) == 0 ) return;
  bl->point0.x = x; bl->point0.y = y;
  bl->point1.x = x + ((sintbl[d]*15)>>4); 
  bl->point1.y = y - ((costbl[d]*15)>>4);
  bl->point0.mx = bl->point1.mx = (sintbl[d]*15)>>4;
  bl->point0.my = bl->point1.my = -(costbl[d]*15)>>4;
  bl->vctChk = FALSE;
  if ( (bl = nextBullet()) == 0 ) return;
  d += sd*2;
  if ( d >= 256 ) d -= 256;
  bl->point0.x = x; bl->point0.y = y;
  bl->point1.x = x + ((sintbl[d]*15)>>4); 
  bl->point1.y = y - ((costbl[d]*15)>>4);
  bl->point0.mx = bl->point1.mx = (sintbl[d]*15)>>4;
  bl->point0.my = bl->point1.my = -(costbl[d]*15)>>4;
  bl->vctChk = FALSE;
}

static void vrtRdmFire(int rank) {
  Bullet *bl;
  int x, y;
  int sp;

  if ( (timer&7) >= rank ) return;
  if ( (bl = nextBullet()) == 0 ) return;
  x = randN(160<<4); y = randN(32<<4);
  sp = randN(32)+32;
  bl->point0.x = x; bl->point0.y = y;
  bl->point1.x = x;
  bl->point1.y = y - sp;
  bl->point0.mx = bl->point1.mx = 0;
  bl->point0.my = bl->point1.my = sp;
  bl->vctChk = FALSE;
}

static void rdmLaser(int rank) {
  int d;
  int i;
  Bullet *bl;
  int x, y;

  if ( (timer&15) != 0 ) return;
  x = 80<<4; y = 0;
  for ( i=0 ; i<rank ; i++ ) {
    if ( (bl = nextBullet()) == 0 ) return;
    d = 80+randN(96);
    if ( d >= 256 ) d -= 256;
    bl->point0.x = x; bl->point0.y = y;
    bl->point1.x = x - ((sintbl[d]*(15+6*i))>>4); 
    bl->point1.y = y + ((costbl[d]*(15+6*i))>>4);
    bl->point0.mx = bl->point1.mx = (sintbl[d]*(6+i))>>4;
    bl->point0.my = bl->point1.my = -(costbl[d]*(6+i))>>4;
    bl->vctChk = FALSE;
  }
}

static void rndVctFire(int rank) {
  int d, d1, d2;
  int i;
  Bullet *bl;
  int x, y;

  if ( (timer&15) != 0 ) return;
  x = 80<<4; y = 0;
  if ( ((timer/16)&1) == 0 ) {
    d = 74;
  } else {
    d = 74+12;
  }
  for ( i=0 ; i<5 ; i++ ) {
    if ( (bl = nextBullet()) == 0 ) return;
    d1 = d-rank;
    d2 = d+rank;
    bl->point0.x = bl->point1.x = x;
    bl->point0.y = bl->point1.y = y;
    bl->point0.mx = (sintbl[d1]*4)>>4;
    bl->point0.my = -(costbl[d1]*4)>>4;
    bl->point1.mx = (sintbl[d2]*4)>>4;
    bl->point1.my = -(costbl[d2]*4)>>4;
    bl->point0.x += bl->point0.mx;
    bl->point0.y += bl->point0.my;
    bl->point1.x += bl->point1.mx;
    bl->point1.y += bl->point1.my;
    bl->vctChk = TRUE;
    d += 24;
  }
}
