/******************************************************************************\
   Go81 Plays the game of go on PalmOS devices.
   Copyright (C) 2002-2004 Tapani Raiko

    this program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    this program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS for A PARTICULAR PURPOSE.  See the
    GNU General public License for more details.

    You should have received a copy of the GNU General public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
\******************************************************************************/
#ifndef tapani_common_h_included
#define tapani_common_h_included

#include "go81_id.h"

#ifdef _CONSOLE
#include <stdlib.h>
#include <memory.h>
#include <stdio.h>
#include <time.h>
#include <ctype.h>
#else
// PalmOS stuff:
#include <Common.h>
#include <System/SysAll.h>
#include <UI/UIAll.h>
#endif

#define DEBUG 0

//disable warnings for conversions from double to float
//#pragma warning( disable : 4244 4305 )
//int to boolean  
//#pragma warning( disable : 4800 )  

#define Pi 3.14159265358979323846

#define MAX(x, y) ((x) > (y) ? (x) : (y))
#define MIN(x, y) ((x) < (y) ? (x) : (y))
#define ABS(x) ((x) < 0 ? (-x) : (x))
#define uchar unsigned char
#define lint signed long int



#ifndef _CONSOLE  // PALM:

#define NULL 0

#define PNEW(x) (x *)MemPtrNew(sizeof(x))
#define PNEW_SIZE(x) (void *)MemPtrNew(x)
#define PDEL(x) if (x!=NULL) MemPtrFree(x)

int rand(void)
{ 
  return SysRandom(0); 
}

void Panic()
{
  FrmAlert(alertID_panic);
}

#else // CONSOLE:

#define PNEW(x) (x *)malloc(sizeof(x))
#define PNEW_SIZE(x) (void *)malloc(x)
#define PDEL(x) if (x!=NULL) free(x)

void Panic()
{
  fprintf(stderr,"\nPanic!\n");
}
//#define my_memcpy(X,Y,Z) memcpy((void *)X,(void *)Y,Z)
//#define my_strcpy(X,Y,Z) strcpy((void *)X,(void *)Y,Z)
//#define my_memset(X,Y,Z) memset((void *)X,Y,Z)
//#define sysRandomMax 99999999
#define Boolean bool
#endif

void my_memcpy(char *where,char *what,int howmuch)
{
  int i;
 
  for (i=0;i<howmuch;i++) {
    where[i]=what[i];
  }
}

void my_strcpy(char *where,char *what,int howmuch)
{
  int i;
 
  for (i=0;i<howmuch;i++) {
    where[i]=what[i];
    if (what[i]==0) break;
  }
}

void my_memset(char *where,char what,int howmuch)
{
  int i;
  for (i=0;i<howmuch;i++) {
    where[i] = what;
  }
}

#endif



