/******************************************************************************\
   Go81 Plays the game of go on PalmOS devices.
   Copyright (C) 2002-2004 Tapani Raiko

    this program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    this program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS for A PARTICULAR PURPOSE.  See the
    GNU General public License for more details.

    You should have received a copy of the GNU General public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
\******************************************************************************/

// ---------------------------------------------------------------------------

// (C) Tapani Raiko 2002-2003
// for PalmOS
// This class defines a set of integers which is stored as a sorted linked Set.
// It manages its own memory which must be initialized with IntSetInit(lint _maxn)
// Typical set operations such as the union and the intersection are implemented.

#include "intset.h"

static IntSet *is = NULL;
static lint maxn, cur;

int IntSetInit(lint _maxn)
{
  lint q;
  cur = 0;
  PDEL(is);
  maxn = _maxn;
  is = (IntSet *)PNEW_SIZE(maxn*sizeof(IntSet));
  if (is==NULL)
  {
    Panic();
    return -1;
  }
  for (q=0;q<maxn;q++) 
    is[q].next = INTSET_UNUSED;
  return 0;
}

IntSet::IntSet()
{
  next = INTSET_UNUSED;
}

IntSet::~IntSet()
{
}


// find a new place for an atom
// returns the new index or INTSET_ERROR if out of memory
IntSet *IntSetNewAtom()
{
  while (cur<maxn)
  {
    if (is[cur].next == INTSET_UNUSED) 
    {
      is[cur].next = INTSET_END;
      return &is[cur];
    }
    cur++;
  }
  cur = 0;
  while (cur<maxn)
  {
    if (is[cur].next == INTSET_UNUSED) 
    {
      is[cur].next = INTSET_END;
      return &is[cur];
    }
    cur++;
  }
  Panic();

  return INTSET_ERROR;
}

// mark a set as unused
void IntSetDelete(IntSet *pil)
{
  if (pil != INTSET_UNUSED && pil != INTSET_END && pil != INTSET_ERROR) 
  {
    IntSetDelete(pil->next);
    pil->next = INTSET_UNUSED;
  }
}


// returns 1 if added, 0 if already existed.
lint 
IntSetAdd(IntSet **atthis, lint add)
{
  while (*atthis != INTSET_END && (*atthis)->i < add)
  {
    atthis = &((*atthis)->next);
  }
  if (*atthis == INTSET_END || (*atthis)->i != add)
  {
    IntSet *newset = IntSetNewAtom();

    newset->i = add;
    newset->next = *atthis;
    *atthis = newset;
    return 1;
  }

  return 0;
}

// returns number of added ints.
lint 
IntSetUnion(IntSet **atthis, IntSet *il)
{
  lint count = 0;

  while (il != INTSET_END)
  {
    while (*atthis != INTSET_END && (*atthis)->i < il->i)
    {
      atthis = &((*atthis)->next);
    }
    if (*atthis == INTSET_END || (*atthis)->i != il->i)
    {
      IntSet *newset = IntSetNewAtom();
      newset->i = il->i;
      newset->next = *atthis;
      *atthis = newset;
      count++;
    }
    il = il->next;
  }

  return count;
}


/*
// returns number of remaining ints.
lint
IntSetIntersection(IntSet **atthis, IntSet *il)
{
  IntSet *remove;
  lint count = 0;

  while (*atthis != INTSET_END && il != INTSET_END)
  {
    if ((*atthis)->i < il->i)
    {
      //remove and skip to next with this
      remove = *atthis;
      *atthis = remove->next;
      remove->next = INTSET_END;
      IntSetDelete(remove);
    }
    else if ((*atthis)->i == il->i)
    {
      //save and skip to next with both
      atthis = &((*atthis)->next);
      il = il->next;
      count++;
    }
    else if ((*atthis)->i > il->i)
    {
      //skip to next with il
      il = il->next;
    }
  }

  return count;
}
*/

// returns number of removed ints.
lint 
IntSetRemove(IntSet **atthis, lint remo)
{
  IntSet *remove;

  while (*atthis != INTSET_END && (*atthis)->i < remo)
  {
    atthis = &((*atthis)->next);
  }
  if (*atthis != INTSET_END && (*atthis)->i == remo)
  {
    remove = *atthis;
    *atthis = remove->next;
    remove->next = INTSET_END;
    IntSetDelete(remove);
    return 1;
  }

  return 0;
}


bool
IntSetContains(IntSet *il, lint contained)
{
  while (il != INTSET_END && il->i < contained)
    il = il->next;
  if (il != INTSET_END && il->i == contained)
    return true;

  return false;
}


bool 
IntSetIsSubset(IntSet *il, IntSet *sub)
{
  while (sub != INTSET_END) {
    while (il != INTSET_END && il->i < sub->i)
      il = il->next;
    if (il != INTSET_END && il->i == sub->i)
      sub = sub->next;
    else
      return false;
  }

  return true;
}  


// returns number of ints
lint 
IntSetCount(IntSet *il)
{
  lint count = 0;

  while (il != INTSET_END)
  {
    il = il->next;
    count++;
  }

  return count;
}

/*
IntSet *
IntSetFindPairsSpecial(IntSet *il, lint remainder, lint add1, lint add2)
{
  IntSet *cursor = il;
  IntSet *result = INTSET_END;
  while (cursor != INTSET_END)
  {
    if (cursor->i < il->i + remainder)
    {
      cursor = cursor->next;
    }
    else if (cursor->i == il->i + remainder)
    {
      IntSetAdd(&result, il->i + add1);
      IntSetAdd(&result, il->i + add2);
      cursor = cursor->next;
      il = il->next;
    }
    else
    {
      il = il->next;
    }  
  }
  return result;
}*/

IntSet *
IntSetCopy(IntSet *il)
{
  if (il == INTSET_UNUSED || il == INTSET_END || il == INTSET_ERROR)
    return il; 
  IntSet *ne = INTSET_END;
  IntSetUnion(&ne, il);
  return ne;
}



