/******************************************************************************\
   Go81 Plays the game of go on PalmOS devices.
   Copyright (C) 2002-2004 Tapani Raiko

    this program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    this program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS for A PARTICULAR PURPOSE.  See the
    GNU General public License for more details.

    You should have received a copy of the GNU General public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
\******************************************************************************/
// (C) Tapani Raiko 2002-2003
// for PalmOS
// This class defines a set of integers which is stored as a sorted linked list.
// It manages its own memory which must be initialized with IntSetInit(lint _maxn)
// Typical set operations such as the union and the intersection are implemented.

#ifndef intset_h_included
#define intset_h_included
#include "tapani_common.h"

#define INTSET_END     ((IntSet *)NULL)
#define INTSET_UNUSED  ((IntSet *)-1)
#define INTSET_ERROR   ((IntSet *)-2)


class IntSet
{
public:
  IntSet();
  ~IntSet();
  lint i;
  IntSet *next;
};

int IntSetInit(lint _maxn);

// find a new place for an atom
// returns the new index or INTSET_ERROR if out of memory
IntSet *IntSetNewAtom();

// mark a set as unused
void IntSetDelete(IntSet *pil);

// returns 1 if added, 0 if already existed.
lint IntSetAdd(IntSet **atthis, lint add);

// returns number of added ints.
lint IntSetUnion(IntSet **atthis, IntSet *il);

// returns number of remaining ints.
lint IntSetIntersection(IntSet **atthis, IntSet *il);

// returns number of removed ints.
lint IntSetRemove(IntSet **atthis, lint remo);

bool IntSetContains(IntSet *il, lint contained);

bool IntSetIsSubset(IntSet *il, IntSet *sub);

// returns number of ints
lint 
IntSetCount(IntSet *il);

// related to a diagonal pair of eyes
//IntSet *
//IntSetFindPairsSpecial(IntSet *il, lint remainder, lint add1, lint add2);

IntSet *
IntSetCopy(IntSet *il);

#endif

