#ifndef Y_H_INCLUDED
#define Y_H_INCLUDED true

// order matters, do not change
#define Y_EMPTY 0
#define Y_BLACK 1
#define Y_WHITE 2
#define Y_BORDER 3

//#define GAME_OF_Y
//#define GAME_OF_HEX
#define GAME_OF_STAR
// Y-boards: SIZE2 SIZE3 SIZE4 Hex-boards: HEX9 HEX11
//#define SIZE4
//#define HEX11
#define STAR6

#ifdef SIZE2
// bent 2: (the bent board of size 2 has 27 points)
#define BSIZE 28
#define BOARD_FILENAME "board2.bmp"
#endif
#ifdef SIZE3
// bent 3: (the bent board of size 3 has 55 points)
#define BSIZE 56
#define BOARD_FILENAME "board4.bmp"
#endif
#ifdef SIZE4
// bent 4: (the bent board of size 4 has 93 points)
#define BSIZE 94
#define BOARD_FILENAME "board4.bmp"
#endif
#ifdef HEX9
// hex 9 by 9 has 81 points
#define BSIZE 82
#define BOARD_FILENAME "hex9.bmp"
#endif
#ifdef HEX11
// hex 11 by 11 has 121 points
#define BSIZE 122
#define BOARD_FILENAME "hex11.bmp"
#endif
#ifdef STAR6
// star6 has 105 points
#define BSIZE 106
#define BOARD_FILENAME "star6.bmp"
#endif


#ifdef GAME_OF_Y
#define BAMBUROW 18
#define NEIGHROW 6
#define GAME_NAME "Game of Y"
#endif
#ifdef GAME_OF_HEX
#define BAMBUROW 18
#define NEIGHROW 6
#define GAME_NAME "Hex"
#endif
#ifdef GAME_OF_STAR
#define BAMBUROW 24
#define NEIGHROW 7
#define GAME_NAME "*Star"
#endif

#define MAXRULESIZE 10
#define MAXNRULES 100
#define RANDOMNESS 1.0
#define NEWRULE_THRESHOLD 5


// x and y vary from 1 to bsize on board
class MoveValue
{
  public:
  int point; //x+TSIZE*Y
  float value;
};

class Heap
{
public:
  MoveValue mv[BSIZE];  // 1..n
  int n;
  int DeleteTop();
  void Sift(int i);
  void Insert(int point, float value);


};

class YRule
{
public:
  int size; //number of added stones on the board (pattern size)
  int pattern[MAXRULESIZE];  // index: 0..size-1, value: x + BSIZE*colour
  int values[BSIZE][4]; // black wins, black loses, white wins, white loses
  Heap heap[3];  //unused, black, white
};



/*
rule
 - lista pisteist ja niiden vreist
 - lista ennusteista(?)
 - lukumrt (voitot ja hvit)
 - lista tt snt erikoistavista snnist (jos joku ptee, ei tt kytet)
 
yhdistelless maxent-tyyliin jakaumia tulo merkitsee counttien yhteenlaskua.
tytynee painottaa pidempi ruleja enempi.

eiku yhdistellnkin vaan max-tyyliin. simppeli.
*/

//--------UCT ----------

#define MAX_UCT_NDESC 100000
int BLACK_UCT_NPRED=20;
int BLACK_UCT_NDESC=1000;
int WHITE_UCT_NPRED=20;
int WHITE_UCT_NDESC=1000;
#define BLACK_ONOFF_BAMBU 1
#define WHITE_ONOFF_BAMBU 1
#define ONOFF_PATTERN 0


long int uct_ndesc=400;
long int uct_npred=20;
int newwins[2], newtries;
int depthstat[BSIZE];
int onoff_bambu = 1;

class UCTnode
{
public:
  long int hash1;
  int ntries[BSIZE];
  int nwins[BSIZE];
  int tries;
  //  int wins;
  int nstones;
};

#include <map>

std::map<long int, UCTnode *> uct;
// example use: uct[hash] = uctnodes[nodes++];

void uct_createnode(int *board, long int hash1, int npred);
void descend(int *board, long int hash0, int npred);
int SelectMoveUCT();

//--------------------

char symbols[4]={'.','B','W','_'};

void EventLoop(void);
void drawboard(int *board);
int ConsoleCommand();

void f_spread(int *board, int *spread, int colour, int bsize);
int ApplyMove(int x);
int MouseButtonPressed(int mouse_x,int mouse_y);
 
void InitAI();
int ComputerCanMove();
float Values2Information(int values[4]);
int IsGeneralisationOf(YRule rule1, YRule rule2);
int AddNewRule(int rul,int x,int colour);
int compare(const void * a, const void * b);
float Values2Worth(int values[4],int colour);

int RandomAnalysis();
void InitBoard(void);

float sqr(float x) {
    return x*x;
}

#ifdef SIZE4

#define SIDELENGTH 9

const float coordinates[] = {
 0.4958, 1.0000
,0.6053, 0.9478
,0.7153, 0.8768
,0.8160, 0.7851
,0.8988, 0.6748
,0.9571, 0.5508
,0.9901, 0.4209
,1.0000, 0.2935
,0.9935, 0.1757
,0.8921, 0.1100
,0.7739, 0.0532
,0.6417, 0.0145
,0.5018, 0.0000
,0.3617, 0.0129
,0.2291, 0.0502
,0.1101, 0.1056
,0.0080, 0.1702
,0.0000, 0.2879
,0.0084, 0.4155
,0.0397, 0.5457
,0.0966, 0.6704
,0.1781, 0.7816
,0.2777, 0.8744
,0.3868, 0.9466
,0.4963, 0.9049
,0.6060, 0.8516
,0.7079, 0.7786
,0.7940, 0.6870
,0.8581, 0.5806
,0.8981, 0.4630
,0.9137, 0.3414
,0.9080, 0.2227
,0.8056, 0.1574
,0.6896, 0.1084
,0.5649, 0.0820
,0.4378, 0.0813
,0.3127, 0.1064
,0.1961, 0.1541
,0.0929, 0.2182
,0.0857, 0.3368
,0.0998, 0.4586
,0.1384, 0.5766
,0.2012, 0.6838
,0.2862, 0.7763
,0.3872, 0.8504
,0.4968, 0.8156
,0.6011, 0.7608
,0.6904, 0.6851
,0.7569, 0.5948
,0.8053, 0.4944
,0.8295, 0.3819
,0.8278, 0.2670
,0.7267, 0.2070
,0.6146, 0.1700
,0.5008, 0.1592
,0.3869, 0.1687
,0.2744, 0.2045
,0.1725, 0.2634
,0.1694, 0.3782
,0.1922, 0.4910
,0.2394, 0.5920
,0.3048, 0.6830
,0.3931, 0.7596
,0.4973, 0.7314
,0.5908, 0.6719
,0.6545, 0.5938
,0.7056, 0.5090
,0.7445, 0.4169
,0.7522, 0.3088
,0.6524, 0.2603
,0.5509, 0.2458
,0.4497, 0.2453
,0.3480, 0.2586
,0.2477, 0.3061
,0.2540, 0.4142
,0.2917, 0.5067
,0.3418, 0.5921
,0.4045, 0.6709
,0.4978, 0.6503
,0.5525, 0.5820
,0.6026, 0.5076
,0.6448, 0.4289
,0.6795, 0.3491
,0.5911, 0.3374
,0.4998, 0.3324
,0.4084, 0.3364
,0.3199, 0.3471
,0.3535, 0.4273
,0.3947, 0.5065
,0.4439, 0.5814
,0.4987, 0.5035
,0.5479, 0.4218
,0.4505, 0.4213};

const int neighbours[] = {
  2, 25, 24,  0,  0,  0
, 1,  3, 26, 25,  0,  0
, 2,  4, 27, 26,  0,  0
, 5,  3, 27, 28,  0,  0
, 4, 28,  6, 29,  0,  0
, 5,  7, 30, 29,  0,  0
, 6,  8, 31, 30,  0,  0
, 9,  7, 31, 32,  0,  0
, 8, 32, 10,  0,  0,  0
,11,  9, 33, 32,  0,  0
,10, 12, 33, 34,  0,  0
,11, 13, 34, 35,  0,  0
,35, 36, 12, 14,  0,  0
,15, 13, 37, 36,  0,  0
,14, 16, 37, 38,  0,  0
,15, 17, 38, 39,  0,  0
,18, 39, 16,  0,  0,  0
,17, 19, 40, 39,  0,  0
,20, 18, 40, 41,  0,  0
,19, 21, 41, 42,  0,  0
,22, 43, 42, 20,  0,  0
,21, 23, 44, 43,  0,  0
,24, 22, 44, 45,  0,  0
,23,  1, 45, 25,  0,  0
,46,  1, 45, 26,  2, 24
, 3, 46,  2, 27, 25, 47
,48,  3, 26,  4, 28, 47
,48,  5, 49, 27,  4, 29
,50,  5, 49, 30, 28,  6
, 7, 50,  6, 31, 29, 51
,52,  7, 30,  8, 32, 51
,52,  9, 33, 31,  8, 10
,11, 52, 53, 32, 10, 34
,54, 11, 53, 35, 12, 33
,13, 54, 34, 55, 12, 36
,56, 13, 37, 55, 35, 14
,15, 56, 57, 36, 14, 38
,58, 15, 57, 39, 16, 37
,58, 17, 38, 40, 18, 16
,19, 58, 41, 18, 39, 59
,60, 19, 42, 59, 20, 40
,60, 21, 41, 61, 43, 20
,62, 21, 61, 44, 22, 42
,23, 62, 45, 22, 43, 63
,46, 23, 25, 63, 24, 44
,25, 64, 47, 63, 26, 45
,46, 48, 26, 64, 65, 27
,28, 65, 27, 49, 47, 66
,50, 48, 66, 28, 29, 67
,29, 68, 49, 51, 67, 30
,50, 52, 30, 68, 69, 31
,32, 69, 31, 33, 51, 53
,52, 54, 69, 33, 70, 34
,70, 35, 34, 55, 53, 71
,56, 54, 71, 35, 36, 72
,36, 73, 55, 37, 72, 57
,56, 58, 73, 37, 74, 38
,74, 39, 59, 38, 40, 57
,58, 60, 41, 75, 74, 40
,42, 75, 76, 59, 61, 41
,62, 60, 43, 77, 42, 76
,78, 43, 63, 77, 44, 61
,62, 46, 45, 64, 78, 44
,79, 46, 47, 63, 65, 78
,48, 79, 66, 47, 64, 80
,48, 81, 65, 49, 80, 67
,81, 50, 66, 82, 68, 49
,50, 83, 51, 67, 82, 69
,52, 83, 53, 51, 68, 70
,54, 83, 71, 53, 69, 84
,54, 85, 70, 55, 84, 72
,85, 56, 71, 86, 73, 55
,56, 87, 57, 72, 86, 74
,58, 87, 59, 57, 75, 73
,87, 60, 76, 59, 88, 74
,60, 89, 61, 75, 88, 77
,89, 62, 61, 78, 90, 76
,62, 79, 77, 63, 64, 90
,64, 65, 78, 80, 90,  0
,81, 79, 91, 66, 65, 90
,80, 82, 67, 92, 66, 91
,83, 81, 67, 92, 68, 84
,82, 68, 69, 70, 84,  0
,85, 83, 92, 71, 82, 70
,84, 86, 92, 72, 93, 71
,85, 87, 72, 93, 88, 73
,75, 88, 86, 73, 74,  0
,89, 87, 93, 76, 75, 86
,90, 88, 77, 93, 76, 91
,89, 79, 77, 91, 78, 80
,81, 89, 80, 92, 90, 93
,85, 81, 91, 82, 84, 93
,89, 85, 91, 88, 86, 92};

const int bambu[] = {
  26,  2, 25, 45, 25, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 24,  1, 25, 27,  3, 26, 46, 26, 25,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 25,  2, 26, 28,  4, 27, 47, 27, 26,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 26,  3, 27, 29,  5, 28, 48, 27, 28,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 27,  4, 28, 30,  6, 29, 49, 28, 29,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 28,  5, 29, 31,  7, 30, 50, 30, 29,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 29,  6, 30, 32,  8, 31, 51, 31, 30,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 10,  9, 32, 30,  7, 31, 52, 31, 32,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 31,  8, 32, 33, 32, 10,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  8,  9, 32, 34, 11, 33, 52, 33, 32,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 32, 10, 33, 35, 12, 34, 53, 33, 34,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 33, 11, 34, 36, 13, 35, 54, 34, 35,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 34, 35, 12, 37, 36, 14, 55, 35, 36,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 35, 13, 36, 38, 15, 37, 56, 37, 36,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 36, 14, 37, 39, 16, 38, 57, 37, 38,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 18, 17, 39, 37, 15, 38, 58, 38, 39,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 38, 39, 16, 40, 18, 39,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 16, 17, 39, 41, 19, 40, 58, 40, 39,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 39, 18, 40, 42, 20, 41, 59, 40, 41,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 40, 19, 41, 43, 21, 42, 60, 41, 42,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 41, 42, 20, 44, 22, 43, 61, 43, 42,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 42, 21, 43, 45, 23, 44, 62, 44, 43,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 25, 24, 45, 43, 22, 44, 63, 44, 45,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  2,  1, 25, 44, 23, 45, 46, 45, 25,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  3, 26,  2, 23, 45, 24, 47, 46, 26, 63, 46, 45,  0,  1,  2,  0,  1, 24
,  1,  2, 25,  4,  3, 27, 45, 46, 25, 48, 27, 47, 64, 46, 47,  0,  3,  2
,  2,  3, 26,  5,  4, 28, 46, 26, 47, 49, 48, 28, 65, 48, 47,  0,  3,  4
,  3, 27,  4,  6,  5, 29, 47, 48, 27, 50, 49, 29, 66, 48, 49,  0,  5,  4
,  4,  5, 28,  7, 30,  6, 48, 49, 28, 51, 50, 30, 67, 50, 49,  0,  5,  6
,  5,  6, 29,  8,  7, 31, 49, 50, 29, 52, 31, 51, 68, 50, 51,  0,  7,  6
,  6,  7, 30,  9,  8, 32, 33, 52, 32, 50, 30, 51, 69, 52, 51,  0,  7,  8
,  7, 31,  8, 11, 33, 10, 51, 52, 31, 53, 52, 33,  0,  9,  8,  0,  9, 10
,  9, 32, 10, 12, 11, 34, 31, 52, 32, 54, 53, 34, 69, 52, 53,  0, 11, 10
, 10, 11, 33, 13, 35, 12, 52, 53, 33, 55, 54, 35, 70, 54, 53,  0, 11, 12
, 11, 34, 12, 14, 13, 36, 53, 54, 34, 56, 55, 36, 71, 54, 55,  0, 13, 12
, 12, 13, 35, 15, 37, 14, 54, 55, 35, 57, 56, 37, 72, 56, 55,  0, 13, 14
, 13, 36, 14, 16, 15, 38, 55, 56, 36, 58, 57, 38, 73, 56, 57,  0, 15, 14
, 14, 15, 37, 17, 39, 16, 40, 58, 39, 56, 57, 37, 74, 58, 57,  0, 15, 16
, 15, 38, 16, 19, 40, 18, 57, 58, 38, 59, 58, 40,  0, 17, 16,  0, 17, 18
, 17, 18, 39, 20, 19, 41, 38, 58, 39, 60, 41, 59, 74, 58, 59,  0, 19, 18
, 18, 19, 40, 21, 42, 20, 58, 59, 40, 61, 60, 42, 75, 60, 59,  0, 19, 20
, 19, 41, 20, 22, 21, 43, 59, 60, 41, 62, 61, 43, 76, 60, 61,  0, 21, 20
, 20, 21, 42, 23, 44, 22, 60, 61, 42, 63, 62, 44, 77, 62, 61,  0, 21, 22
, 21, 22, 43, 24, 23, 45, 46, 45, 63, 61, 62, 43, 78, 62, 63,  0, 23, 22
,  1, 25, 24, 22, 23, 44, 26, 46, 25, 62, 63, 44, 64, 46, 63,  0, 23, 24
,  2, 25, 26, 24, 25, 45, 27, 47, 26, 44, 63, 45, 65, 64, 47, 78, 64, 63
,  3, 26, 27, 25, 46, 26, 28, 48, 27, 63, 46, 64, 66, 48, 65, 79, 64, 65
,  4, 28, 27, 26, 27, 47, 29, 28, 49, 64, 65, 47, 67, 49, 66, 80, 65, 66
,  5, 28, 29, 27, 48, 28, 30, 50, 29, 65, 48, 66, 68, 50, 67, 81, 66, 67
,  6, 29, 30, 28, 29, 49, 31, 51, 30, 66, 49, 67, 69, 68, 51, 82, 68, 67
,  7, 30, 31, 29, 50, 30, 32, 52, 31, 53, 52, 69, 67, 50, 68, 83, 68, 69
,  8, 32, 31, 10, 32, 33, 30, 31, 51, 34, 33, 53, 68, 69, 51, 70, 69, 53
, 11, 33, 34, 32, 52, 33, 35, 54, 34, 51, 52, 69, 71, 54, 70, 83, 69, 70
, 12, 35, 34, 33, 34, 53, 36, 35, 55, 69, 70, 53, 72, 55, 71, 84, 70, 71
, 13, 35, 36, 34, 54, 35, 37, 56, 36, 70, 54, 71, 73, 56, 72, 85, 71, 72
, 14, 36, 37, 35, 36, 55, 38, 37, 57, 71, 55, 72, 74, 73, 57, 86, 73, 72
, 15, 37, 38, 36, 56, 37, 39, 58, 38, 59, 58, 74, 72, 56, 73, 87, 73, 74
, 16, 39, 38, 18, 39, 40, 37, 38, 57, 41, 59, 40, 73, 74, 57, 75, 74, 59
, 19, 41, 40, 39, 58, 40, 42, 60, 41, 57, 58, 74, 76, 60, 75, 87, 75, 74
, 20, 42, 41, 40, 59, 41, 43, 42, 61, 74, 75, 59, 77, 76, 61, 88, 75, 76
, 21, 43, 42, 41, 60, 42, 44, 62, 43, 75, 60, 76, 78, 62, 77, 89, 77, 76
, 22, 43, 44, 42, 43, 61, 45, 63, 44, 64, 78, 63, 76, 77, 61, 90, 78, 77
, 23, 45, 44, 25, 46, 45, 43, 62, 44, 47, 46, 64, 77, 62, 78, 79, 64, 78
, 26, 46, 47, 45, 46, 63, 48, 47, 65, 62, 63, 78, 80, 79, 65, 90, 79, 78
, 27, 48, 47, 46, 47, 64, 49, 48, 66, 78, 79, 64, 81, 66, 80, 90, 79, 80
, 28, 48, 49, 47, 48, 65, 50, 49, 67, 79, 65, 80, 82, 81, 67, 91, 81, 80
, 29, 50, 49, 48, 66, 49, 51, 50, 68, 80, 81, 66, 83, 82, 68, 92, 81, 82
, 30, 50, 51, 49, 50, 67, 52, 51, 69, 70, 83, 69, 81, 67, 82, 84, 83, 82
, 31, 52, 51, 33, 52, 53, 50, 51, 68, 54, 53, 70, 82, 83, 68, 84, 83, 70
, 34, 54, 53, 52, 53, 69, 55, 54, 71, 68, 83, 69, 82, 83, 84, 85, 71, 84
, 35, 54, 55, 53, 54, 70, 56, 55, 72, 83, 70, 84, 86, 85, 72, 92, 85, 84
, 36, 56, 55, 54, 71, 55, 57, 56, 73, 84, 85, 71, 87, 86, 73, 93, 85, 86
, 37, 56, 57, 55, 56, 72, 58, 57, 74, 75, 87, 74, 85, 72, 86, 88, 87, 86
, 38, 58, 57, 40, 58, 59, 56, 57, 73, 60, 59, 75, 86, 87, 73, 88, 87, 75
, 41, 60, 59, 58, 59, 74, 61, 60, 76, 73, 87, 74, 86, 87, 88, 89, 76, 88
, 42, 60, 61, 59, 60, 75, 62, 61, 77, 87, 75, 88, 90, 89, 77, 93, 89, 88
, 43, 62, 61, 60, 61, 76, 63, 62, 78, 79, 78, 90, 88, 89, 76, 91, 89, 90
, 44, 62, 63, 46, 63, 64, 61, 62, 77, 65, 79, 64, 80, 79, 90, 89, 77, 90
, 47, 64, 65, 63, 64, 78, 66, 65, 80, 77, 78, 90, 91, 80, 90,  0,  0,  0
, 48, 66, 65, 64, 79, 65, 67, 81, 66, 78, 79, 90, 89, 91, 90, 92, 81, 91
, 49, 67, 66, 65, 80, 66, 68, 82, 67, 84, 82, 92, 90, 80, 91, 93, 92, 91
, 50, 67, 68, 66, 81, 67, 69, 83, 68, 70, 83, 84, 85, 92, 84, 91, 81, 92
, 51, 68, 69, 53, 69, 70, 67, 82, 68, 71, 70, 84, 92, 82, 84,  0,  0,  0
, 54, 71, 70, 68, 83, 82, 69, 83, 70, 72, 85, 71, 81, 92, 82, 93, 85, 92
, 55, 72, 71, 70, 84, 71, 73, 86, 72, 82, 84, 92, 88, 86, 93, 91, 92, 93
, 56, 72, 73, 71, 85, 72, 74, 87, 73, 75, 87, 88, 89, 93, 88, 92, 85, 93
, 57, 73, 74, 59, 75, 74, 72, 86, 73, 76, 75, 88, 93, 88, 86,  0,  0,  0
, 60, 76, 75, 73, 87, 86, 74, 87, 75, 77, 89, 76, 85, 93, 86, 91, 89, 93
, 61, 77, 76, 75, 88, 76, 78, 90, 77, 80, 90, 91, 86, 88, 93, 92, 93, 91
, 62, 77, 78, 64, 79, 78, 65, 79, 80, 76, 89, 77, 81, 91, 80, 93, 89, 91
, 66, 81, 80, 77, 89, 90, 79, 80, 90, 82, 81, 92, 85, 92, 93, 88, 89, 93
, 67, 81, 82, 71, 85, 84, 80, 81, 91, 83, 82, 84, 86, 85, 93, 89, 91, 93
, 72, 85, 86, 76, 89, 88, 81, 91, 92, 84, 85, 92, 87, 88, 86, 90, 89, 91};

#endif
// size 4

#ifdef SIZE3

#define SIDELENGTH 7

const float coordinates[] = {
  0.5025, 1.0000
, 0.6499, 0.9253
, 0.7902, 0.8159
, 0.9037, 0.6729
, 0.9736, 0.5058
, 1.0000, 0.3334
, 0.9920, 0.1727
, 0.8515, 0.0865
, 0.6834, 0.0236
, 0.4987, 0.0000
, 0.3142, 0.0250
, 0.1467, 0.0890
, 0.0068, 0.1762
, 0.0000, 0.3370
, 0.0277, 0.5092
, 0.0989, 0.6758
, 0.2134, 0.8179
, 0.3546, 0.9264
, 0.5020, 0.8757
, 0.6447, 0.7982
, 0.7643, 0.6866
, 0.8453, 0.5497
, 0.8841, 0.3934
, 0.8809, 0.2352
, 0.7403, 0.1544
, 0.5806, 0.1100
, 0.4177, 0.1105
, 0.2584, 0.1562
, 0.1184, 0.2379
, 0.1164, 0.3962
, 0.1564, 0.5522
, 0.2383, 0.6885
, 0.3588, 0.7992
, 0.5016, 0.7610
, 0.6283, 0.6776
, 0.7102, 0.5658
, 0.7683, 0.4408
, 0.7784, 0.2930
, 0.6405, 0.2285
, 0.4996, 0.2157
, 0.3587, 0.2295
, 0.2213, 0.2950
, 0.2325, 0.4428
, 0.2915, 0.5673
, 0.3743, 0.6785
, 0.5012, 0.6525
, 0.5727, 0.5583
, 0.6338, 0.4550
, 0.6816, 0.3476
, 0.5615, 0.3348
, 0.4385, 0.3352
, 0.3185, 0.3489
, 0.3671, 0.4559
, 0.4290, 0.5588
, 0.5004, 0.4497};


const int neighbours[] = {
  18, 19,  2,  0,  0,  0
, 20,  1, 19,  3,  0,  0
,  4, 20, 21,  2,  0,  0
,  3, 21, 22,  5,  0,  0
, 23,  4, 22,  6,  0,  0
,  7, 23, 24,  5,  0,  0
,  6, 24,  8,  0,  0,  0
, 25,  7, 24,  9,  0,  0
, 25, 10, 26,  8,  0,  0
, 27, 26, 11,  9,  0,  0
, 28, 10, 27, 12,  0,  0
, 28, 13, 29, 11,  0,  0
, 14, 29, 12,  0,  0,  0
, 13, 30, 15, 29,  0,  0
, 16, 30, 31, 14,  0,  0
, 17, 32, 15, 31,  0,  0
, 16, 33, 18, 32,  0,  0
,  1, 33, 19, 17,  0,  0
, 33,  1, 20, 18, 34,  2
, 19, 34, 35, 21,  3,  2
, 20,  4, 36,  3, 35, 22
, 36,  4, 23, 21, 37,  5
, 22, 37, 38, 24,  6,  5
, 23,  7, 25,  6, 38,  8
, 39, 26,  9,  8, 24, 38
, 40, 10, 25, 27, 39,  9
, 10, 28, 40, 11, 41, 26
, 42, 29, 12, 11, 27, 41
, 30, 13, 28, 14, 42, 12
, 15, 14, 29, 42, 43, 31
, 44, 30, 16, 32, 15, 43
, 33, 16, 44, 17, 45, 31
, 18, 17, 32, 45, 34, 19
, 46, 33, 20, 45, 19, 35
, 20, 46, 36, 34, 21, 47
, 21, 35, 47, 48, 37, 22
, 49, 36, 23, 48, 22, 38
, 23, 25, 49, 37, 39, 24
, 40, 49, 25, 50, 26, 38
, 41, 27, 26, 39, 50, 51
, 28, 52, 40, 42, 27, 51
, 30, 52, 28, 43, 29, 41
, 44, 52, 30, 53, 31, 42
, 45, 32, 31, 43, 53, 54
, 33, 46, 44, 34, 32, 54
, 34, 45, 35, 54, 47,  0
, 36, 55, 46, 35, 54, 48
, 36, 49, 55, 37, 47, 50
, 37, 48, 50, 39, 38,  0
, 55, 49, 40, 48, 51, 39
, 55, 40, 52, 53, 41, 50
, 53, 43, 42, 41, 51,  0
, 52, 44, 55, 43, 54, 51
, 44, 46, 55, 45, 53, 47
, 54, 53, 51, 50, 48, 47};

const int bambu[] = {
  20, 19,  2, 33, 18, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 18,  1, 19, 21, 20,  3, 34, 20, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 19, 20,  2, 22,  4, 21, 35, 20, 21,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 20,  3, 21, 23, 22,  5, 36, 21, 22,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 21,  4, 22, 24, 23,  6, 37, 23, 22,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  8,  7, 24, 22, 23,  5, 38, 23, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 23,  6, 24, 25, 24,  8,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  6,  7, 24, 26, 25,  9, 38, 25, 24,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 24, 25,  8, 27, 10, 26, 39, 25, 26,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 25, 26,  9, 28, 27, 11, 40, 27, 26,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 26, 10, 27, 29, 28, 12, 41, 28, 27,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 14, 13, 29, 27, 28, 11, 42, 28, 29,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 28, 29, 12, 30, 14, 29,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 12, 13, 29, 31, 30, 15, 42, 30, 29,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 29, 30, 14, 32, 16, 31, 43, 30, 31,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 30, 15, 31, 33, 17, 32, 44, 32, 31,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 19, 33, 18, 31, 16, 32, 45, 33, 32,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  2,  1, 19, 32, 33, 17, 34, 33, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  3, 20,  2, 17, 33, 18, 35, 20, 34, 45, 33, 34,  0,  1,  2,  0,  1, 18
,  1, 19,  2,  4, 21,  3, 33, 19, 34, 36, 35, 21, 46, 34, 35,  0,  3,  2
,  2, 20,  3,  5,  4, 22, 34, 20, 35, 37, 36, 22, 47, 36, 35,  0,  4,  3
,  3,  4, 21,  6, 23,  5, 35, 36, 21, 38, 23, 37, 48, 36, 37,  0,  4,  5
,  4, 22,  5,  7, 24,  6, 25, 38, 24, 36, 22, 37, 49, 37, 38,  0,  6,  5
,  5, 23,  6,  9, 25,  8, 37, 23, 38, 39, 25, 38,  0,  7,  6,  0,  7,  8
,  7,  8, 24, 10, 26,  9, 23, 24, 38, 40, 39, 26, 49, 39, 38,  0,  9,  8
,  8, 25,  9, 11, 10, 27, 38, 25, 39, 41, 40, 27, 50, 40, 39,  0, 10,  9
,  9, 10, 26, 12, 28, 11, 39, 40, 26, 42, 28, 41, 51, 40, 41,  0, 10, 11
, 10, 11, 27, 13, 29, 12, 30, 42, 29, 40, 27, 41, 52, 42, 41,  0, 12, 11
, 11, 28, 12, 15, 30, 14, 41, 28, 42, 43, 30, 42,  0, 13, 12,  0, 13, 14
, 13, 14, 29, 16, 15, 31, 28, 29, 42, 44, 43, 31, 52, 42, 43,  0, 15, 14
, 14, 30, 15, 17, 16, 32, 42, 30, 43, 45, 44, 32, 53, 44, 43,  0, 16, 15
, 15, 16, 31, 18, 33, 17, 34, 33, 45, 43, 44, 31, 54, 44, 45,  0, 16, 17
,  1, 18, 19, 16, 17, 32, 20, 34, 19, 44, 32, 45, 46, 45, 34,  0, 18, 17
,  2, 20, 19, 18, 33, 19, 21, 20, 35, 32, 33, 45, 47, 46, 35, 54, 46, 45
,  3, 20, 21, 19, 20, 34, 22, 36, 21, 45, 46, 34, 48, 36, 47, 54, 46, 47
,  4, 21, 22, 20, 21, 35, 23, 37, 22, 46, 35, 47, 49, 48, 37, 55, 47, 48
,  5, 23, 22, 21, 36, 22, 24, 23, 38, 39, 49, 38, 47, 36, 48, 50, 49, 48
,  6, 23, 24,  8, 25, 24, 22, 23, 37, 26, 25, 39, 48, 49, 37, 50, 49, 39
,  9, 25, 26, 24, 25, 38, 27, 40, 26, 37, 49, 38, 48, 49, 50, 51, 40, 50
, 10, 27, 26, 25, 26, 39, 28, 41, 27, 49, 39, 50, 52, 41, 51, 55, 50, 51
, 11, 28, 27, 26, 40, 27, 29, 28, 42, 43, 52, 42, 50, 40, 51, 53, 52, 51
, 12, 28, 29, 14, 30, 29, 27, 28, 41, 31, 30, 43, 51, 52, 41, 53, 52, 43
, 15, 30, 31, 29, 30, 42, 32, 44, 31, 41, 52, 42, 51, 52, 53, 54, 44, 53
, 16, 32, 31, 30, 31, 43, 33, 45, 32, 46, 45, 54, 52, 43, 53, 55, 53, 54
, 17, 33, 32, 19, 33, 34, 31, 44, 32, 35, 46, 34, 47, 46, 54, 53, 44, 54
, 20, 34, 35, 33, 34, 45, 36, 35, 47, 44, 45, 54, 55, 54, 47,  0,  0,  0
, 21, 36, 35, 34, 46, 35, 37, 36, 48, 45, 46, 54, 50, 55, 48, 53, 55, 54
, 22, 36, 37, 35, 36, 47, 38, 49, 37, 39, 49, 50, 51, 55, 50, 54, 55, 47
, 23, 37, 38, 25, 39, 38, 36, 37, 48, 40, 50, 39, 55, 48, 50,  0,  0,  0
, 26, 40, 39, 37, 49, 48, 38, 49, 39, 41, 40, 51, 47, 55, 48, 53, 55, 51
, 27, 40, 41, 39, 40, 50, 42, 52, 41, 43, 52, 53, 48, 55, 50, 54, 55, 53
, 28, 42, 41, 30, 43, 42, 40, 41, 51, 44, 53, 43, 55, 53, 51,  0,  0,  0
, 31, 44, 43, 41, 52, 51, 42, 52, 43, 45, 44, 54, 47, 55, 54, 50, 55, 51
, 32, 44, 45, 34, 46, 45, 35, 46, 47, 43, 44, 53, 48, 55, 47, 51, 55, 53
, 36, 48, 47, 40, 51, 50, 44, 54, 53, 46, 54, 47, 49, 50, 48, 52, 53, 51};


#endif

#ifdef SIZE2

#define SIDELENGTH 5

const float coordinates[] = {
  0.5025, 1.0000
, 0.7280, 0.8753
, 0.9128, 0.6762
, 1.0000, 0.4239
, 0.9991, 0.1759
, 0.7727, 0.0526
, 0.4989, 0.0000
, 0.2255, 0.0544
, 0.0000, 0.1791
, 0.0009, 0.4271
, 0.0898, 0.6788
, 0.2761, 0.8767
, 0.5018, 0.8205
, 0.7013, 0.6870
, 0.8157, 0.4973
, 0.8359, 0.2662
, 0.6146, 0.1687
, 0.3845, 0.1694
, 0.1639, 0.2683
, 0.1857, 0.4993
, 0.3014, 0.6883
, 0.5012, 0.6576
, 0.6071, 0.5097
, 0.6878, 0.3481
, 0.5001, 0.3349
, 0.3126, 0.3493
, 0.3943, 0.5104};

const int neighbours[] = {
  12, 13,  2,  0,  0,  0
,  1, 13, 14,  3,  0,  0
,  2, 14, 15,  4,  0,  0
,  5, 16, 15,  3,  0,  0
,  4, 16,  6,  0,  0,  0
,  5, 16, 17,  7,  0,  0
,  6, 17, 18,  8,  0,  0
,  9, 19, 18,  7,  0,  0
, 10, 19,  8,  0,  0,  0
,  9, 19, 20, 11,  0,  0
, 10, 20, 21, 12,  0,  0
,  1, 13, 21, 11,  0,  0
,  1,  2, 14, 22, 21, 12
,  2, 13, 22, 23, 15,  3
,  4, 16, 24, 23, 14,  3
,  5,  6, 17, 24, 15,  4
,  6, 16, 24, 25, 18,  7
,  8, 19, 26, 25, 17,  7
,  9, 10, 20, 26, 18,  8
, 10, 19, 26, 27, 21, 11
, 12, 13, 22, 27, 20, 11
, 13, 14, 23, 27, 21,  0
, 24, 15, 14, 22, 27, 25
, 16, 17, 25, 23, 15,  0
, 24, 17, 18, 26, 27, 23
, 19, 20, 27, 25, 18,  0
, 26, 20, 21, 22, 23, 25};
/*
  12, 13,  2,  0,  0,  0
,  3,  1, 14, 13,  0,  0
,  2, 14, 15,  4,  0,  0
,  5,  3, 16, 15,  0,  0
,  4, 16,  6,  0,  0,  0
,  7,  5, 17, 16,  0,  0
, 18, 17,  8,  6,  0,  0
,  9,  7, 19, 18,  0,  0
, 10, 19,  8,  0,  0,  0
, 11,  9, 19, 20,  0,  0
, 12, 21, 10, 20,  0,  0
,  1, 11, 21, 13,  0,  0
, 22,  1, 14, 21, 12,  2
,  3, 22, 23, 13,  2, 15
, 24,  3, 16, 23, 14,  4
,  5, 24,  6, 15,  4, 17
, 24,  7,  6, 18, 25, 16
,  7, 26, 17,  8, 19, 25
, 26,  9,  8, 10, 20, 18
, 26, 11, 19, 21, 27, 10
, 22, 11, 20, 12, 13, 27
, 13, 21, 14, 27, 23,  0
, 24, 22, 25, 14, 15, 27
, 15, 23, 25, 17, 16,  0
, 24, 26, 17, 27, 23, 18
, 27, 20, 19, 18, 25,  0
, 26, 22, 25, 20, 21, 23};
*/

const int bambu[] = {
  14, 13,  2, 21, 12, 13,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 12,  1, 13, 15,  3, 14, 22, 14, 13,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 13,  2, 14, 16, 15,  4, 23, 14, 15,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  6,  5, 16, 14,  3, 15, 24, 16, 15,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 15,  4, 16, 17, 16,  6,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  4,  5, 16, 18,  7, 17, 24, 17, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 16, 17,  6, 19, 18,  8, 25, 18, 17,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 10,  9, 19, 17,  7, 18, 26, 19, 18,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 18, 19,  8, 20, 10, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  8,  9, 19, 21, 11, 20, 26, 19, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 13, 12, 21, 19, 10, 20, 27, 21, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  2,  1, 13, 20, 11, 21, 22, 21, 13,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  3, 14,  2, 11, 21, 12, 23, 22, 14, 27, 22, 21,  0,  1,  2,  0,  1, 12
,  1, 13,  2,  4,  3, 15, 21, 22, 13, 24, 23, 15, 27, 22, 23,  0,  3,  2
,  2,  3, 14,  5, 16,  4, 17, 24, 16, 22, 23, 14, 25, 24, 23,  0,  3,  4
,  3, 15,  4,  7,  6, 17, 23, 24, 15, 25, 24, 17,  0,  5,  4,  0,  5,  6
,  5,  6, 16,  8,  7, 18, 15, 24, 16, 23, 24, 25, 26, 18, 25,  0,  7,  6
,  6,  7, 17,  9,  8, 19, 20, 26, 19, 24, 17, 25, 27, 26, 25,  0,  7,  8
,  7,  8, 18, 11, 10, 20, 25, 26, 18, 27, 26, 20,  0,  9,  8,  0,  9, 10
,  9, 19, 10, 12, 11, 21, 18, 26, 19, 22, 21, 27, 25, 26, 27,  0, 11, 10
,  1, 12, 13, 10, 11, 20, 14, 22, 13, 23, 22, 27, 26, 20, 27,  0, 11, 12
,  2, 13, 14, 12, 13, 21, 15, 14, 23, 20, 21, 27, 25, 27, 23,  0,  0,  0
,  3, 14, 15, 13, 22, 14, 16, 24, 15, 17, 24, 25, 21, 22, 27, 26, 25, 27
,  4, 15, 16,  6, 17, 16, 14, 15, 23, 18, 25, 17, 27, 23, 25,  0,  0,  0
,  7, 17, 18, 15, 24, 23, 16, 24, 17, 19, 26, 18, 20, 26, 27, 22, 27, 23
,  8, 19, 18, 10, 20, 19, 17, 18, 25, 21, 27, 20, 23, 27, 25,  0,  0,  0
, 11, 20, 21, 13, 22, 21, 14, 22, 23, 18, 26, 25, 19, 26, 20, 24, 25, 23};


#endif

#ifdef HEX9

#define SIDELENGTH 9

const float coordinates[] = {
  0.0000, 0.0000
, 0.0986, 0.0264
, 0.1972, 0.0528
, 0.2958, 0.0793
, 0.3944, 0.1057
, 0.4930, 0.1321
, 0.5916, 0.1585
, 0.6901, 0.1850
, 0.7887, 0.2114
, 0.0264, 0.0986
, 0.1250, 0.1250
, 0.2236, 0.1514
, 0.3222, 0.1778
, 0.4208, 0.2043
, 0.5194, 0.2307
, 0.6180, 0.2571
, 0.7166, 0.2835
, 0.8151, 0.3100
, 0.0528, 0.1972
, 0.1514, 0.2236
, 0.2500, 0.2500
, 0.3486, 0.2764
, 0.4472, 0.3028
, 0.5458, 0.3293
, 0.6444, 0.3557
, 0.7430, 0.3821
, 0.8416, 0.4085
, 0.0792, 0.2957
, 0.1778, 0.3222
, 0.2764, 0.3486
, 0.3750, 0.3750
, 0.4736, 0.4014
, 0.5722, 0.4278
, 0.6708, 0.4543
, 0.7694, 0.4807
, 0.8680, 0.5071
, 0.1056, 0.3943
, 0.2042, 0.4207
, 0.3028, 0.4472
, 0.4014, 0.4736
, 0.5000, 0.5000
, 0.5986, 0.5264
, 0.6972, 0.5528
, 0.7958, 0.5793
, 0.8944, 0.6057
, 0.1320, 0.4929
, 0.2306, 0.5193
, 0.3292, 0.5457
, 0.4278, 0.5722
, 0.5264, 0.5986
, 0.6250, 0.6250
, 0.7236, 0.6514
, 0.8222, 0.6778
, 0.9208, 0.7043
, 0.1584, 0.5915
, 0.2570, 0.6179
, 0.3556, 0.6443
, 0.4542, 0.6707
, 0.5528, 0.6972
, 0.6514, 0.7236
, 0.7500, 0.7500
, 0.8486, 0.7764
, 0.9472, 0.8028
, 0.1849, 0.6900
, 0.2834, 0.7165
, 0.3820, 0.7429
, 0.4806, 0.7693
, 0.5792, 0.7957
, 0.6778, 0.8222
, 0.7764, 0.8486
, 0.8750, 0.8750
, 0.9736, 0.9014
, 0.2113, 0.7886
, 0.3099, 0.8150
, 0.4084, 0.8415
, 0.5070, 0.8679
, 0.6056, 0.8943
, 0.7042, 0.9207
, 0.8028, 0.9472
, 0.9014, 0.9736
, 1.0000, 1.0000};

const int neighbours[] = {
   2, 10,  0,  0,  0,  0
,  3, 11, 10,  1,  0,  0
,  4, 12, 11,  2,  0,  0
,  5, 13, 12,  3,  0,  0
,  6, 14, 13,  4,  0,  0
,  7, 15, 14,  5,  0,  0
,  8, 16, 15,  6,  0,  0
,  9, 17, 16,  7,  0,  0
, 18, 17,  8,  0,  0,  0
, 11, 19,  1,  2,  0,  0
, 12, 20, 19, 10,  2,  3
, 13, 21, 20, 11,  3,  4
, 14, 22, 21, 12,  4,  5
, 15, 23, 22, 13,  5,  6
, 16, 24, 23, 14,  6,  7
, 17, 25, 24, 15,  7,  8
, 18, 26, 25, 16,  8,  9
, 27, 26, 17,  9,  0,  0
, 20, 28, 10, 11,  0,  0
, 21, 29, 28, 19, 11, 12
, 22, 30, 29, 20, 12, 13
, 23, 31, 30, 21, 13, 14
, 24, 32, 31, 22, 14, 15
, 25, 33, 32, 23, 15, 16
, 26, 34, 33, 24, 16, 17
, 27, 35, 34, 25, 17, 18
, 36, 35, 26, 18,  0,  0
, 29, 37, 19, 20,  0,  0
, 30, 38, 37, 28, 20, 21
, 31, 39, 38, 29, 21, 22
, 32, 40, 39, 30, 22, 23
, 33, 41, 40, 31, 23, 24
, 34, 42, 41, 32, 24, 25
, 35, 43, 42, 33, 25, 26
, 36, 44, 43, 34, 26, 27
, 45, 44, 35, 27,  0,  0
, 38, 46, 28, 29,  0,  0
, 39, 47, 46, 37, 29, 30
, 40, 48, 47, 38, 30, 31
, 41, 49, 48, 39, 31, 32
, 42, 50, 49, 40, 32, 33
, 43, 51, 50, 41, 33, 34
, 44, 52, 51, 42, 34, 35
, 45, 53, 52, 43, 35, 36
, 54, 53, 44, 36,  0,  0
, 47, 55, 37, 38,  0,  0
, 48, 56, 55, 46, 38, 39
, 49, 57, 56, 47, 39, 40
, 50, 58, 57, 48, 40, 41
, 51, 59, 58, 49, 41, 42
, 52, 60, 59, 50, 42, 43
, 53, 61, 60, 51, 43, 44
, 54, 62, 61, 52, 44, 45
, 63, 62, 53, 45,  0,  0
, 56, 64, 46, 47,  0,  0
, 57, 65, 64, 55, 47, 48
, 58, 66, 65, 56, 48, 49
, 59, 67, 66, 57, 49, 50
, 60, 68, 67, 58, 50, 51
, 61, 69, 68, 59, 51, 52
, 62, 70, 69, 60, 52, 53
, 63, 71, 70, 61, 53, 54
, 72, 71, 62, 54,  0,  0
, 65, 73, 55, 56,  0,  0
, 66, 74, 73, 64, 56, 57
, 67, 75, 74, 65, 57, 58
, 68, 76, 75, 66, 58, 59
, 69, 77, 76, 67, 59, 60
, 70, 78, 77, 68, 60, 61
, 71, 79, 78, 69, 61, 62
, 72, 80, 79, 70, 62, 63
, 81, 80, 71, 63,  0,  0
, 74, 64, 65,  0,  0,  0
, 75, 73, 65, 66,  0,  0
, 76, 74, 66, 67,  0,  0
, 77, 75, 67, 68,  0,  0
, 78, 76, 68, 69,  0,  0
, 79, 77, 69, 70,  0,  0
, 80, 78, 70, 71,  0,  0
, 81, 79, 71, 72,  0,  0
, 80, 72,  0,  0,  0,  0};

const int bambu[] = {
  11,  2, 10,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 12,  3, 11, 19, 11, 10, -2, 10,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 10, 11,  2, 13,  4, 12, 20, 12, 11,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 11, 12,  3, 14,  5, 13, 21, 13, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 12, 13,  4, 15,  6, 14, 22, 14, 13,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 13, 14,  5, 16,  7, 15, 23, 15, 14,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 14, 15,  6, 17,  8, 16, 24, 16, 15,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 15, 16,  7, 18,  9, 17, 25, 17, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 16, 17,  8, 26, 18, 17,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  3, 11,  2, 20, 11, 19, -1,  1,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  1, 10,  2,  4, 12,  3, 21, 12, 20, 28, 20, 19, -1,  2,  3, -2, 19, 10
,  2, 11,  3,  5, 13,  4, 19, 20, 11, 22, 13, 21, 29, 21, 20, -1,  3,  4
,  3, 12,  4,  6, 14,  5, 20, 21, 12, 23, 14, 22, 30, 22, 21, -1,  4,  5
,  4, 13,  5,  7, 15,  6, 21, 22, 13, 24, 15, 23, 31, 23, 22, -1,  5,  6
,  5, 14,  6,  8, 16,  7, 22, 23, 14, 25, 16, 24, 32, 24, 23, -1,  6,  7
,  6, 15,  7,  9, 17,  8, 23, 24, 15, 26, 17, 25, 33, 25, 24, -1,  7,  8
,  7, 16,  8, 24, 25, 16, 27, 18, 26, 34, 26, 25, -1,  8,  9, -2, 18,  9
,  8, 17,  9, 25, 26, 17, 35, 27, 26,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  2, 10, 11, 12, 20, 11, 29, 20, 28,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  3, 11, 12, 10, 19, 11, 13, 21, 12, 30, 21, 29, 37, 29, 28, -2, 28, 19
,  4, 12, 13, 11, 20, 12, 14, 22, 13, 28, 29, 20, 31, 22, 30, 38, 30, 29
,  5, 13, 14, 12, 21, 13, 15, 23, 14, 29, 30, 21, 32, 23, 31, 39, 31, 30
,  6, 14, 15, 13, 22, 14, 16, 24, 15, 30, 31, 22, 33, 24, 32, 40, 32, 31
,  7, 15, 16, 14, 23, 15, 17, 25, 16, 31, 32, 23, 34, 25, 33, 41, 33, 32
,  8, 16, 17, 15, 24, 16, 18, 26, 17, 32, 33, 24, 35, 26, 34, 42, 34, 33
,  9, 17, 18, 16, 25, 17, 33, 34, 25, 36, 27, 35, 43, 35, 34, -2, 27, 18
, 17, 26, 18, 34, 35, 26, 44, 36, 35,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 11, 19, 20, 21, 29, 20, 38, 29, 37,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 12, 20, 21, 19, 28, 20, 22, 30, 21, 39, 30, 38, 46, 38, 37, -2, 37, 28
, 13, 21, 22, 20, 29, 21, 23, 31, 22, 37, 38, 29, 40, 31, 39, 47, 39, 38
, 14, 22, 23, 21, 30, 22, 24, 32, 23, 38, 39, 30, 41, 32, 40, 48, 40, 39
, 15, 23, 24, 22, 31, 23, 25, 33, 24, 39, 40, 31, 42, 33, 41, 49, 41, 40
, 16, 24, 25, 23, 32, 24, 26, 34, 25, 40, 41, 32, 43, 34, 42, 50, 42, 41
, 17, 25, 26, 24, 33, 25, 27, 35, 26, 41, 42, 33, 44, 35, 43, 51, 43, 42
, 18, 26, 27, 25, 34, 26, 42, 43, 34, 45, 36, 44, 52, 44, 43, -2, 36, 27
, 26, 35, 27, 43, 44, 35, 53, 45, 44,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 20, 28, 29, 30, 38, 29, 47, 38, 46,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 21, 29, 30, 28, 37, 29, 31, 39, 30, 48, 39, 47, 55, 47, 46, -2, 46, 37
, 22, 30, 31, 29, 38, 30, 32, 40, 31, 46, 47, 38, 49, 40, 48, 56, 48, 47
, 23, 31, 32, 30, 39, 31, 33, 41, 32, 47, 48, 39, 50, 41, 49, 57, 49, 48
, 24, 32, 33, 31, 40, 32, 34, 42, 33, 48, 49, 40, 51, 42, 50, 58, 50, 49
, 25, 33, 34, 32, 41, 33, 35, 43, 34, 49, 50, 41, 52, 43, 51, 59, 51, 50
, 26, 34, 35, 33, 42, 34, 36, 44, 35, 50, 51, 42, 53, 44, 52, 60, 52, 51
, 27, 35, 36, 34, 43, 35, 51, 52, 43, 54, 45, 53, 61, 53, 52, -2, 45, 36
, 35, 44, 36, 52, 53, 44, 62, 54, 53,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 29, 37, 38, 39, 47, 38, 56, 47, 55,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 30, 38, 39, 37, 46, 38, 40, 48, 39, 57, 48, 56, 64, 56, 55, -2, 55, 46
, 31, 39, 40, 38, 47, 39, 41, 49, 40, 55, 56, 47, 58, 49, 57, 65, 57, 56
, 32, 40, 41, 39, 48, 40, 42, 50, 41, 56, 57, 48, 59, 50, 58, 66, 58, 57
, 33, 41, 42, 40, 49, 41, 43, 51, 42, 57, 58, 49, 60, 51, 59, 67, 59, 58
, 34, 42, 43, 41, 50, 42, 44, 52, 43, 58, 59, 50, 61, 52, 60, 68, 60, 59
, 35, 43, 44, 42, 51, 43, 45, 53, 44, 59, 60, 51, 62, 53, 61, 69, 61, 60
, 36, 44, 45, 43, 52, 44, 60, 61, 52, 63, 54, 62, 70, 62, 61, -2, 54, 45
, 44, 53, 45, 61, 62, 53, 71, 63, 62,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 38, 46, 47, 48, 56, 47, 65, 56, 64,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 39, 47, 48, 46, 55, 47, 49, 57, 48, 66, 57, 65, 73, 65, 64, -2, 64, 55
, 40, 48, 49, 47, 56, 48, 50, 58, 49, 64, 65, 56, 67, 58, 66, 74, 66, 65
, 41, 49, 50, 48, 57, 49, 51, 59, 50, 65, 66, 57, 68, 59, 67, 75, 67, 66
, 42, 50, 51, 49, 58, 50, 52, 60, 51, 66, 67, 58, 69, 60, 68, 76, 68, 67
, 43, 51, 52, 50, 59, 51, 53, 61, 52, 67, 68, 59, 70, 61, 69, 77, 69, 68
, 44, 52, 53, 51, 60, 52, 54, 62, 53, 68, 69, 60, 71, 62, 70, 78, 70, 69
, 45, 53, 54, 52, 61, 53, 69, 70, 61, 72, 63, 71, 79, 71, 70, -2, 63, 54
, 53, 62, 54, 70, 71, 62, 80, 72, 71,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 47, 55, 56, 57, 65, 56, 74, 65, 73,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 48, 56, 57, 55, 64, 56, 58, 66, 57, 75, 66, 74, -1, 74, 73, -2, 73, 64
, 49, 57, 58, 56, 65, 57, 59, 67, 58, 73, 74, 65, 76, 67, 75, -1, 75, 74
, 50, 58, 59, 57, 66, 58, 60, 68, 59, 74, 75, 66, 77, 68, 76, -1, 76, 75
, 51, 59, 60, 58, 67, 59, 61, 69, 60, 75, 76, 67, 78, 69, 77, -1, 77, 76
, 52, 60, 61, 59, 68, 60, 62, 70, 61, 76, 77, 68, 79, 70, 78, -1, 78, 77
, 53, 61, 62, 60, 69, 61, 63, 71, 62, 77, 78, 69, 80, 71, 79, -1, 79, 78
, 54, 62, 63, 61, 70, 62, 78, 79, 70, 81, 72, 80, -1, 80, 79, -2, 72, 63
, 62, 71, 63, 79, 80, 71, -1, 81, 80,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 56, 64, 65, 66, 74, 65,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 57, 65, 66, 64, 73, 65, 67, 75, 66,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 58, 66, 67, 65, 74, 66, 68, 76, 67,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 59, 67, 68, 66, 75, 67, 69, 77, 68,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 60, 68, 69, 67, 76, 68, 70, 78, 69,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 61, 69, 70, 68, 77, 69, 71, 79, 70,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 62, 70, 71, 69, 78, 70, 72, 80, 71,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 63, 71, 72, 70, 79, 71, -2, 81, 72,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 71, 80, 72,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};


#endif
// hex9

#ifdef HEX11

#define SIDELENGTH 11

const float coordinates[] = {
  0.0000, 0.0000
, 0.0789, 0.0211
, 0.1577, 0.0423
, 0.2366, 0.0634
, 0.3155, 0.0846
, 0.3944, 0.1057
, 0.4732, 0.1268
, 0.5521, 0.1480
, 0.6310, 0.1691
, 0.7098, 0.1902
, 0.7887, 0.2114
, 0.0211, 0.0789
, 0.1000, 0.1000
, 0.1789, 0.1211
, 0.2577, 0.1423
, 0.3366, 0.1634
, 0.4155, 0.1846
, 0.4944, 0.2057
, 0.5732, 0.2268
, 0.6521, 0.2480
, 0.7310, 0.2691
, 0.8098, 0.2902
, 0.0423, 0.1577
, 0.1211, 0.1789
, 0.2000, 0.2000
, 0.2789, 0.2211
, 0.3577, 0.2423
, 0.4366, 0.2634
, 0.5155, 0.2846
, 0.5944, 0.3057
, 0.6732, 0.3268
, 0.7521, 0.3480
, 0.8310, 0.3691
, 0.0634, 0.2366
, 0.1423, 0.2577
, 0.2211, 0.2789
, 0.3000, 0.3000
, 0.3789, 0.3211
, 0.4577, 0.3423
, 0.5366, 0.3634
, 0.6155, 0.3846
, 0.6944, 0.4057
, 0.7732, 0.4268
, 0.8521, 0.4480
, 0.0845, 0.3155
, 0.1634, 0.3366
, 0.2423, 0.3577
, 0.3211, 0.3789
, 0.4000, 0.4000
, 0.4789, 0.4211
, 0.5577, 0.4423
, 0.6366, 0.4634
, 0.7155, 0.4846
, 0.7944, 0.5057
, 0.8732, 0.5268
, 0.1056, 0.3943
, 0.1845, 0.4155
, 0.2634, 0.4366
, 0.3423, 0.4577
, 0.4211, 0.4789
, 0.5000, 0.5000
, 0.5789, 0.5211
, 0.6577, 0.5423
, 0.7366, 0.5634
, 0.8155, 0.5846
, 0.8944, 0.6057
, 0.1268, 0.4732
, 0.2056, 0.4943
, 0.2845, 0.5155
, 0.3634, 0.5366
, 0.4423, 0.5577
, 0.5211, 0.5789
, 0.6000, 0.6000
, 0.6789, 0.6211
, 0.7577, 0.6423
, 0.8366, 0.6634
, 0.9155, 0.6845
, 0.1479, 0.5520
, 0.2268, 0.5732
, 0.3056, 0.5943
, 0.3845, 0.6155
, 0.4634, 0.6366
, 0.5423, 0.6577
, 0.6211, 0.6789
, 0.7000, 0.7000
, 0.7789, 0.7211
, 0.8577, 0.7423
, 0.9366, 0.7634
, 0.1690, 0.6309
, 0.2479, 0.6520
, 0.3268, 0.6732
, 0.4056, 0.6943
, 0.4845, 0.7155
, 0.5634, 0.7366
, 0.6423, 0.7577
, 0.7211, 0.7789
, 0.8000, 0.8000
, 0.8789, 0.8211
, 0.9577, 0.8423
, 0.1901, 0.7098
, 0.2690, 0.7309
, 0.3479, 0.7520
, 0.4268, 0.7732
, 0.5056, 0.7943
, 0.5845, 0.8155
, 0.6634, 0.8366
, 0.7423, 0.8577
, 0.8211, 0.8789
, 0.9000, 0.9000
, 0.9789, 0.9211
, 0.2113, 0.7886
, 0.2901, 0.8098
, 0.3690, 0.8309
, 0.4479, 0.8520
, 0.5268, 0.8732
, 0.6056, 0.8943
, 0.6845, 0.9155
, 0.7634, 0.9366
, 0.8423, 0.9577
, 0.9211, 0.9789
, 1.0000, 1.0000};

const int neighbours[] = {
   2, 12,  0,  0,  0,  0
,  3, 13, 12,  1,  0,  0
,  4, 14, 13,  2,  0,  0
,  5, 15, 14,  3,  0,  0
,  6, 16, 15,  4,  0,  0
,  7, 17, 16,  5,  0,  0
,  8, 18, 17,  6,  0,  0
,  9, 19, 18,  7,  0,  0
, 10, 20, 19,  8,  0,  0
, 11, 21, 20,  9,  0,  0
, 22, 21, 10,  0,  0,  0
, 13, 23,  1,  2,  0,  0
, 14, 24, 23, 12,  2,  3
, 15, 25, 24, 13,  3,  4
, 16, 26, 25, 14,  4,  5
, 17, 27, 26, 15,  5,  6
, 18, 28, 27, 16,  6,  7
, 19, 29, 28, 17,  7,  8
, 20, 30, 29, 18,  8,  9
, 21, 31, 30, 19,  9, 10
, 22, 32, 31, 20, 10, 11
, 33, 32, 21, 11,  0,  0
, 24, 34, 12, 13,  0,  0
, 25, 35, 34, 23, 13, 14
, 26, 36, 35, 24, 14, 15
, 27, 37, 36, 25, 15, 16
, 28, 38, 37, 26, 16, 17
, 29, 39, 38, 27, 17, 18
, 30, 40, 39, 28, 18, 19
, 31, 41, 40, 29, 19, 20
, 32, 42, 41, 30, 20, 21
, 33, 43, 42, 31, 21, 22
, 44, 43, 32, 22,  0,  0
, 35, 45, 23, 24,  0,  0
, 36, 46, 45, 34, 24, 25
, 37, 47, 46, 35, 25, 26
, 38, 48, 47, 36, 26, 27
, 39, 49, 48, 37, 27, 28
, 40, 50, 49, 38, 28, 29
, 41, 51, 50, 39, 29, 30
, 42, 52, 51, 40, 30, 31
, 43, 53, 52, 41, 31, 32
, 44, 54, 53, 42, 32, 33
, 55, 54, 43, 33,  0,  0
, 46, 56, 34, 35,  0,  0
, 47, 57, 56, 45, 35, 36
, 48, 58, 57, 46, 36, 37
, 49, 59, 58, 47, 37, 38
, 50, 60, 59, 48, 38, 39
, 51, 61, 60, 49, 39, 40
, 52, 62, 61, 50, 40, 41
, 53, 63, 62, 51, 41, 42
, 54, 64, 63, 52, 42, 43
, 55, 65, 64, 53, 43, 44
, 66, 65, 54, 44,  0,  0
, 57, 67, 45, 46,  0,  0
, 58, 68, 67, 56, 46, 47
, 59, 69, 68, 57, 47, 48
, 60, 70, 69, 58, 48, 49
, 61, 71, 70, 59, 49, 50
, 62, 72, 71, 60, 50, 51
, 63, 73, 72, 61, 51, 52
, 64, 74, 73, 62, 52, 53
, 65, 75, 74, 63, 53, 54
, 66, 76, 75, 64, 54, 55
, 77, 76, 65, 55,  0,  0
, 68, 78, 56, 57,  0,  0
, 69, 79, 78, 67, 57, 58
, 70, 80, 79, 68, 58, 59
, 71, 81, 80, 69, 59, 60
, 72, 82, 81, 70, 60, 61
, 73, 83, 82, 71, 61, 62
, 74, 84, 83, 72, 62, 63
, 75, 85, 84, 73, 63, 64
, 76, 86, 85, 74, 64, 65
, 77, 87, 86, 75, 65, 66
, 88, 87, 76, 66,  0,  0
, 79, 89, 67, 68,  0,  0
, 80, 90, 89, 78, 68, 69
, 81, 91, 90, 79, 69, 70
, 82, 92, 91, 80, 70, 71
, 83, 93, 92, 81, 71, 72
, 84, 94, 93, 82, 72, 73
, 85, 95, 94, 83, 73, 74
, 86, 96, 95, 84, 74, 75
, 87, 97, 96, 85, 75, 76
, 88, 98, 97, 86, 76, 77
, 99, 98, 87, 77,  0,  0
, 90,100, 78, 79,  0,  0
, 91,101,100, 89, 79, 80
, 92,102,101, 90, 80, 81
, 93,103,102, 91, 81, 82
, 94,104,103, 92, 82, 83
, 95,105,104, 93, 83, 84
, 96,106,105, 94, 84, 85
, 97,107,106, 95, 85, 86
, 98,108,107, 96, 86, 87
, 99,109,108, 97, 87, 88
,110,109, 98, 88,  0,  0
,101,111, 89, 90,  0,  0
,102,112,111,100, 90, 91
,103,113,112,101, 91, 92
,104,114,113,102, 92, 93
,105,115,114,103, 93, 94
,106,116,115,104, 94, 95
,107,117,116,105, 95, 96
,108,118,117,106, 96, 97
,109,119,118,107, 97, 98
,110,120,119,108, 98, 99
,121,120,109, 99,  0,  0
,112,100,101,  0,  0,  0
,113,111,101,102,  0,  0
,114,112,102,103,  0,  0
,115,113,103,104,  0,  0
,116,114,104,105,  0,  0
,117,115,105,106,  0,  0
,118,116,106,107,  0,  0
,119,117,107,108,  0,  0
,120,118,108,109,  0,  0
,121,119,109,110,  0,  0
,120,110,  0,  0,  0,  0};



const int bambu[] = {
  13,  2, 12,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 14,  3, 13, 23, 13, 12, -2, 12,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 12, 13,  2, 15,  4, 14, 24, 14, 13,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 13, 14,  3, 16,  5, 15, 25, 15, 14,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 14, 15,  4, 17,  6, 16, 26, 16, 15,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 15, 16,  5, 18,  7, 17, 27, 17, 16,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 16, 17,  6, 19,  8, 18, 28, 18, 17,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 17, 18,  7, 20,  9, 19, 29, 19, 18,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 18, 19,  8, 21, 10, 20, 30, 20, 19,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 19, 20,  9, 22, 11, 21, 31, 21, 20,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 20, 21, 10, 32, 22, 21,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  3, 13,  2, 24, 13, 23, -1,  1,  2,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  1, 12,  2,  4, 14,  3, 25, 14, 24, 34, 24, 23, -1,  2,  3, -2, 23, 12
,  2, 13,  3,  5, 15,  4, 23, 24, 13, 26, 15, 25, 35, 25, 24, -1,  3,  4
,  3, 14,  4,  6, 16,  5, 24, 25, 14, 27, 16, 26, 36, 26, 25, -1,  4,  5
,  4, 15,  5,  7, 17,  6, 25, 26, 15, 28, 17, 27, 37, 27, 26, -1,  5,  6
,  5, 16,  6,  8, 18,  7, 26, 27, 16, 29, 18, 28, 38, 28, 27, -1,  6,  7
,  6, 17,  7,  9, 19,  8, 27, 28, 17, 30, 19, 29, 39, 29, 28, -1,  7,  8
,  7, 18,  8, 10, 20,  9, 28, 29, 18, 31, 20, 30, 40, 30, 29, -1,  8,  9
,  8, 19,  9, 11, 21, 10, 29, 30, 19, 32, 21, 31, 41, 31, 30, -1,  9, 10
,  9, 20, 10, 30, 31, 20, 33, 22, 32, 42, 32, 31, -1, 10, 11, -2, 22, 11
, 10, 21, 11, 31, 32, 21, 43, 33, 32,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  2, 12, 13, 14, 24, 13, 35, 24, 34,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  3, 13, 14, 12, 23, 13, 15, 25, 14, 36, 25, 35, 45, 35, 34, -2, 34, 23
,  4, 14, 15, 13, 24, 14, 16, 26, 15, 34, 35, 24, 37, 26, 36, 46, 36, 35
,  5, 15, 16, 14, 25, 15, 17, 27, 16, 35, 36, 25, 38, 27, 37, 47, 37, 36
,  6, 16, 17, 15, 26, 16, 18, 28, 17, 36, 37, 26, 39, 28, 38, 48, 38, 37
,  7, 17, 18, 16, 27, 17, 19, 29, 18, 37, 38, 27, 40, 29, 39, 49, 39, 38
,  8, 18, 19, 17, 28, 18, 20, 30, 19, 38, 39, 28, 41, 30, 40, 50, 40, 39
,  9, 19, 20, 18, 29, 19, 21, 31, 20, 39, 40, 29, 42, 31, 41, 51, 41, 40
, 10, 20, 21, 19, 30, 20, 22, 32, 21, 40, 41, 30, 43, 32, 42, 52, 42, 41
, 11, 21, 22, 20, 31, 21, 41, 42, 31, 44, 33, 43, 53, 43, 42, -2, 33, 22
, 21, 32, 22, 42, 43, 32, 54, 44, 43,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 13, 23, 24, 25, 35, 24, 46, 35, 45,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 14, 24, 25, 23, 34, 24, 26, 36, 25, 47, 36, 46, 56, 46, 45, -2, 45, 34
, 15, 25, 26, 24, 35, 25, 27, 37, 26, 45, 46, 35, 48, 37, 47, 57, 47, 46
, 16, 26, 27, 25, 36, 26, 28, 38, 27, 46, 47, 36, 49, 38, 48, 58, 48, 47
, 17, 27, 28, 26, 37, 27, 29, 39, 28, 47, 48, 37, 50, 39, 49, 59, 49, 48
, 18, 28, 29, 27, 38, 28, 30, 40, 29, 48, 49, 38, 51, 40, 50, 60, 50, 49
, 19, 29, 30, 28, 39, 29, 31, 41, 30, 49, 50, 39, 52, 41, 51, 61, 51, 50
, 20, 30, 31, 29, 40, 30, 32, 42, 31, 50, 51, 40, 53, 42, 52, 62, 52, 51
, 21, 31, 32, 30, 41, 31, 33, 43, 32, 51, 52, 41, 54, 43, 53, 63, 53, 52
, 22, 32, 33, 31, 42, 32, 52, 53, 42, 55, 44, 54, 64, 54, 53, -2, 44, 33
, 32, 43, 33, 53, 54, 43, 65, 55, 54,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 24, 34, 35, 36, 46, 35, 57, 46, 56,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 25, 35, 36, 34, 45, 35, 37, 47, 36, 58, 47, 57, 67, 57, 56, -2, 56, 45
, 26, 36, 37, 35, 46, 36, 38, 48, 37, 56, 57, 46, 59, 48, 58, 68, 58, 57
, 27, 37, 38, 36, 47, 37, 39, 49, 38, 57, 58, 47, 60, 49, 59, 69, 59, 58
, 28, 38, 39, 37, 48, 38, 40, 50, 39, 58, 59, 48, 61, 50, 60, 70, 60, 59
, 29, 39, 40, 38, 49, 39, 41, 51, 40, 59, 60, 49, 62, 51, 61, 71, 61, 60
, 30, 40, 41, 39, 50, 40, 42, 52, 41, 60, 61, 50, 63, 52, 62, 72, 62, 61
, 31, 41, 42, 40, 51, 41, 43, 53, 42, 61, 62, 51, 64, 53, 63, 73, 63, 62
, 32, 42, 43, 41, 52, 42, 44, 54, 43, 62, 63, 52, 65, 54, 64, 74, 64, 63
, 33, 43, 44, 42, 53, 43, 63, 64, 53, 66, 55, 65, 75, 65, 64, -2, 55, 44
, 43, 54, 44, 64, 65, 54, 76, 66, 65,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 35, 45, 46, 47, 57, 46, 68, 57, 67,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 36, 46, 47, 45, 56, 46, 48, 58, 47, 69, 58, 68, 78, 68, 67, -2, 67, 56
, 37, 47, 48, 46, 57, 47, 49, 59, 48, 67, 68, 57, 70, 59, 69, 79, 69, 68
, 38, 48, 49, 47, 58, 48, 50, 60, 49, 68, 69, 58, 71, 60, 70, 80, 70, 69
, 39, 49, 50, 48, 59, 49, 51, 61, 50, 69, 70, 59, 72, 61, 71, 81, 71, 70
, 40, 50, 51, 49, 60, 50, 52, 62, 51, 70, 71, 60, 73, 62, 72, 82, 72, 71
, 41, 51, 52, 50, 61, 51, 53, 63, 52, 71, 72, 61, 74, 63, 73, 83, 73, 72
, 42, 52, 53, 51, 62, 52, 54, 64, 53, 72, 73, 62, 75, 64, 74, 84, 74, 73
, 43, 53, 54, 52, 63, 53, 55, 65, 54, 73, 74, 63, 76, 65, 75, 85, 75, 74
, 44, 54, 55, 53, 64, 54, 74, 75, 64, 77, 66, 76, 86, 76, 75, -2, 66, 55
, 54, 65, 55, 75, 76, 65, 87, 77, 76,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 46, 56, 57, 58, 68, 57, 79, 68, 78,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 47, 57, 58, 56, 67, 57, 59, 69, 58, 80, 69, 79, 89, 79, 78, -2, 78, 67
, 48, 58, 59, 57, 68, 58, 60, 70, 59, 78, 79, 68, 81, 70, 80, 90, 80, 79
, 49, 59, 60, 58, 69, 59, 61, 71, 60, 79, 80, 69, 82, 71, 81, 91, 81, 80
, 50, 60, 61, 59, 70, 60, 62, 72, 61, 80, 81, 70, 83, 72, 82, 92, 82, 81
, 51, 61, 62, 60, 71, 61, 63, 73, 62, 81, 82, 71, 84, 73, 83, 93, 83, 82
, 52, 62, 63, 61, 72, 62, 64, 74, 63, 82, 83, 72, 85, 74, 84, 94, 84, 83
, 53, 63, 64, 62, 73, 63, 65, 75, 64, 83, 84, 73, 86, 75, 85, 95, 85, 84
, 54, 64, 65, 63, 74, 64, 66, 76, 65, 84, 85, 74, 87, 76, 86, 96, 86, 85
, 55, 65, 66, 64, 75, 65, 85, 86, 75, 88, 77, 87, 97, 87, 86, -2, 77, 66
, 65, 76, 66, 86, 87, 76, 98, 88, 87,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 57, 67, 68, 69, 79, 68, 90, 79, 89,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 58, 68, 69, 67, 78, 68, 70, 80, 69, 91, 80, 90,100, 90, 89, -2, 89, 78
, 59, 69, 70, 68, 79, 69, 71, 81, 70, 89, 90, 79, 92, 81, 91,101, 91, 90
, 60, 70, 71, 69, 80, 70, 72, 82, 71, 90, 91, 80, 93, 82, 92,102, 92, 91
, 61, 71, 72, 70, 81, 71, 73, 83, 72, 91, 92, 81, 94, 83, 93,103, 93, 92
, 62, 72, 73, 71, 82, 72, 74, 84, 73, 92, 93, 82, 95, 84, 94,104, 94, 93
, 63, 73, 74, 72, 83, 73, 75, 85, 74, 93, 94, 83, 96, 85, 95,105, 95, 94
, 64, 74, 75, 73, 84, 74, 76, 86, 75, 94, 95, 84, 97, 86, 96,106, 96, 95
, 65, 75, 76, 74, 85, 75, 77, 87, 76, 95, 96, 85, 98, 87, 97,107, 97, 96
, 66, 76, 77, 75, 86, 76, 96, 97, 86, 99, 88, 98,108, 98, 97, -2, 88, 77
, 76, 87, 77, 97, 98, 87,109, 99, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 68, 78, 79, 80, 90, 79,101, 90,100,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 69, 79, 80, 78, 89, 79, 81, 91, 80,102, 91,101,111,101,100, -2,100, 89
, 70, 80, 81, 79, 90, 80, 82, 92, 81,100,101, 90,103, 92,102,112,102,101
, 71, 81, 82, 80, 91, 81, 83, 93, 82,101,102, 91,104, 93,103,113,103,102
, 72, 82, 83, 81, 92, 82, 84, 94, 83,102,103, 92,105, 94,104,114,104,103
, 73, 83, 84, 82, 93, 83, 85, 95, 84,103,104, 93,106, 95,105,115,105,104
, 74, 84, 85, 83, 94, 84, 86, 96, 85,104,105, 94,107, 96,106,116,106,105
, 75, 85, 86, 84, 95, 85, 87, 97, 86,105,106, 95,108, 97,107,117,107,106
, 76, 86, 87, 85, 96, 86, 88, 98, 87,106,107, 96,109, 98,108,118,108,107
, 77, 87, 88, 86, 97, 87,107,108, 97,110, 99,109,119,109,108, -2, 99, 88
, 87, 98, 88,108,109, 98,120,110,109,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 79, 89, 90, 91,101, 90,112,101,111,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 80, 90, 91, 89,100, 90, 92,102, 91,113,102,112, -1,112,111, -2,111,100
, 81, 91, 92, 90,101, 91, 93,103, 92,111,112,101,114,103,113, -1,113,112
, 82, 92, 93, 91,102, 92, 94,104, 93,112,113,102,115,104,114, -1,114,113
, 83, 93, 94, 92,103, 93, 95,105, 94,113,114,103,116,105,115, -1,115,114
, 84, 94, 95, 93,104, 94, 96,106, 95,114,115,104,117,106,116, -1,116,115
, 85, 95, 96, 94,105, 95, 97,107, 96,115,116,105,118,107,117, -1,117,116
, 86, 96, 97, 95,106, 96, 98,108, 97,116,117,106,119,108,118, -1,118,117
, 87, 97, 98, 96,107, 97, 99,109, 98,117,118,107,120,109,119, -1,119,118
, 88, 98, 99, 97,108, 98,118,119,108,121,110,120, -1,120,119, -2,110, 99
, 98,109, 99,119,120,109, -1,121,120,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 90,100,101,102,112,101,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 91,101,102,100,111,101,103,113,102,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 92,102,103,101,112,102,104,114,103,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 93,103,104,102,113,103,105,115,104,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 94,104,105,103,114,104,106,116,105,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 95,105,106,104,115,105,107,117,106,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 96,106,107,105,116,106,108,118,107,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 97,107,108,106,117,107,109,119,108,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 98,108,109,107,118,108,110,120,109,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 99,109,110,108,119,109, -2,121,110,  0,  0,  0,  0,  0,  0,  0,  0,  0
,109,120,110,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0};

#endif
// hex size 11

#ifdef STAR6

const float coordinates[] = {
  0.0000, 0.6378
, 0.5057, 1.0000
, 1.0000, 0.6214
, 0.1830, 0.0318
, 0.7984, 0.0217
, 0.3404, 0.5173
, 0.1729, 0.5761
, 0.1529, 0.7771
, 0.3262, 0.9008
, 0.5028, 0.8118
, 0.5000, 0.6311
, 0.3282, 0.7082
, 0.6821, 0.8950
, 0.8515, 0.7656
, 0.8253, 0.5654
, 0.6560, 0.5121
, 0.6741, 0.7026
, 0.0360, 0.4308
, 0.0989, 0.2232
, 0.2919, 0.1832
, 0.3978, 0.3280
, 0.2155, 0.3742
, 0.9576, 0.4156
, 0.8883, 0.2102
, 0.6943, 0.1766
, 0.5929, 0.3248
, 0.7765, 0.3650
, 0.3850, 0.0053
, 0.5956, 0.0018
, 0.4928, 0.1630
, 0.4207, 0.4894
, 0.4987, 0.5451
, 0.4160, 0.5804
, 0.0871, 0.6065
, 0.0737, 0.7080
, 0.1616, 0.6771
, 0.5043, 0.9049
, 0.4166, 0.9530
, 0.4143, 0.8575
, 0.3323, 0.6129
, 0.2476, 0.6451
, 0.2575, 0.5463
, 0.2413, 0.7436
, 0.3260, 0.8040
, 0.2376, 0.8420
, 0.4140, 0.7638
, 0.4145, 0.6716
, 0.5014, 0.7204
, 0.5750, 0.4869
, 0.5824, 0.5777
, 0.5934, 0.9501
, 0.5927, 0.8546
, 0.9119, 0.5930
, 0.9285, 0.6939
, 0.8397, 0.6659
, 0.5868, 0.6687
, 0.5902, 0.7610
, 0.6793, 0.7982
, 0.7621, 0.7350
, 0.7689, 0.8333
, 0.7528, 0.6368
, 0.6671, 0.6075
, 0.7398, 0.5384
, 0.0155, 0.5356
, 0.1030, 0.5039
, 0.1397, 0.1250
, 0.2378, 0.1083
, 0.1945, 0.2022
, 0.4487, 0.3968
, 0.3619, 0.4203
, 0.1257, 0.4011
, 0.1564, 0.2999
, 0.0639, 0.3258
, 0.2500, 0.2766
, 0.3058, 0.3493
, 0.3453, 0.2565
, 0.2762, 0.4469
, 0.1900, 0.4747
, 0.5441, 0.3952
, 0.6316, 0.4159
, 0.9814, 0.5197
, 0.8929, 0.4909
, 0.7460, 0.1000
, 0.8445, 0.1134
, 0.7922, 0.1923
, 0.7181, 0.4396
, 0.8051, 0.4646
, 0.8671, 0.3889
, 0.8333, 0.2888
, 0.9265, 0.3116
, 0.7390, 0.2685
, 0.6855, 0.3430
, 0.6431, 0.2516
, 0.4952, 0.3189
, 0.2821, 0.0168
, 0.3378, 0.0932
, 0.6989, 0.0099
, 0.6455, 0.0881
, 0.4439, 0.2443
, 0.3914, 0.1691
, 0.4400, 0.0839
, 0.5431, 0.0822
, 0.4903, 0.0000
, 0.5943, 0.1658
, 0.5442, 0.2426};

const int neighbours[] = {
  34, 64, 35,  0,  0,  0,  0
, 37, 38, 51,  0,  0,  0,  0
, 53, 54, 81,  0,  0,  0,  0
, 66, 67, 95,  0,  0,  0,  0
, 83, 84, 97,  0,  0,  0,  0
, 31, 40, 77, 33, 42, 70,  0
, 34, 41, 78, 36, 42, 65,  0
, 35, 43, 36, 45,  0,  0,  0
, 38, 44, 39, 45,  0,  0,  0
, 37, 46, 57, 39, 48, 52,  0
, 32, 47, 56, 33, 48, 50,  0
, 40, 41, 43, 44, 46, 47,  0
, 51, 58, 52, 60,  0,  0,  0
, 54, 59, 55, 60,  0,  0,  0
, 53, 61, 87, 55, 63, 82,  0
, 49, 62, 86, 50, 63, 80,  0
, 56, 57, 58, 59, 61, 62,  0
, 64, 71, 65, 73,  0,  0,  0
, 66, 72, 68, 73,  0,  0,  0
, 67, 74,100, 68, 76, 96,  0
, 69, 75, 99, 70, 76, 94,  0
, 71, 72, 74, 75, 77, 78,  0
, 81, 88, 82, 90,  0,  0,  0
, 84, 89, 85, 90,  0,  0,  0
, 83, 91,104, 85, 93, 98,  0
, 79, 92,105, 80, 93, 94,  0
, 86, 87, 88, 89, 91, 92,  0
, 95,101, 96,103,  0,  0,  0
, 97,102, 98,103,  0,  0,  0
, 99,100,101,102,104,105,  0
,  6, 33, 70, 32, 69, 49, 79
, 11, 50, 33, 31, 49, 69, 79
,  6, 11, 31, 47, 32, 40,  0
,  1,  7, 36, 65, 64, 35,  0
,  8,  1, 36, 34,  0,  0,  0
,  7,  8, 34, 41, 35, 43,  0
,  2, 10, 39, 52, 38, 51,  0
,  9,  2, 39, 37,  0,  0,  0
, 10,  9, 37, 44, 38, 46,  0
, 12,  6, 42, 33, 47, 41,  0
,  7, 12, 36, 42, 40, 43,  0
,  6,  7, 40, 77, 41, 78,  0
,  8, 12, 45, 36, 41, 44,  0
,  9, 12, 39, 45, 43, 46,  0
,  8,  9, 43, 44,  0,  0,  0
, 10, 12, 48, 39, 44, 47,  0
, 11, 12, 33, 48, 46, 40,  0
, 10, 11, 46, 56, 47, 57,  0
, 16, 80, 50, 32, 79, 31, 69
, 11, 16, 32, 62, 49, 56,  0
, 13,  2, 52, 37,  0,  0,  0
, 10, 13, 37, 57, 51, 58,  0
,  3, 15, 55, 82, 54, 81,  0
, 14,  3, 55, 53,  0,  0,  0
, 15, 14, 53, 59, 54, 61,  0
, 17, 11, 48, 50, 62, 57,  0
, 10, 17, 52, 48, 56, 58,  0
, 13, 17, 60, 52, 57, 59,  0
, 14, 17, 55, 60, 58, 61,  0
, 13, 14, 58, 59,  0,  0,  0
, 15, 17, 63, 55, 59, 62,  0
, 16, 17, 50, 63, 61, 56,  0
, 15, 16, 61, 86, 62, 87,  0
,  1, 18, 65, 34,  0,  0,  0
, 18,  7, 64, 78, 34, 71,  0
,  4, 19, 68, 67,  0,  0,  0
, 20,  4, 96, 68, 66, 95,  0
, 19, 20, 66, 72, 67, 74,  0
, 21, 94, 70, 31, 32, 49, 79
,  6, 21, 31, 75, 69, 77,  0
, 22, 18, 73, 65, 78, 72,  0
, 19, 22, 68, 73, 71, 74,  0
, 18, 19, 71, 72,  0,  0,  0
, 20, 22, 76, 68, 72, 75,  0
, 21, 22, 70, 76, 74, 77,  0
, 20, 21, 74, 99, 75,100,  0
,  6, 22, 42, 70, 75, 78,  0
,  7, 22, 65, 42, 77, 71,  0
, 26, 80, 94, 31, 32, 49, 69
, 16, 26, 49, 92, 79, 86,  0
, 23,  3, 82, 53,  0,  0,  0
, 15, 23, 53, 87, 81, 88,  0
,  5, 25, 85, 98, 84, 97,  0
, 24,  5, 85, 83,  0,  0,  0
, 25, 24, 83, 89, 84, 91,  0
, 27, 16, 63, 80, 92, 87,  0
, 15, 27, 82, 63, 86, 88,  0
, 23, 27, 90, 82, 87, 89,  0
, 24, 27, 85, 90, 88, 91,  0
, 23, 24, 88, 89,  0,  0,  0
, 25, 27, 93, 85, 89, 92,  0
, 26, 27, 80, 93, 91, 86,  0
, 25, 26, 91,104, 92,105,  0
, 21, 26, 69,105, 79, 99,  0
, 28,  4, 96, 67,  0,  0,  0
, 20, 28, 67,100, 95,101,  0
, 29,  5, 98, 83,  0,  0,  0
, 25, 29, 83,102, 97,104,  0
, 30, 21, 76, 94,105,100,  0
, 20, 30, 96, 76, 99,101,  0
, 28, 30,103, 96,100,102,  0
, 29, 30, 98,103,101,104,  0
, 28, 29,101,102,  0,  0,  0
, 25, 30, 93, 98,102,105,  0
, 26, 30, 94, 93,104, 99,  0};

const int bambu[] = {
  36, 34, 35, 65, 34, 64,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 39, 37, 38, 52, 37, 51,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 55, 53, 54, 82, 53, 81,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 68, 66, 67, 96, 67, 95,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 85, 83, 84, 98, 83, 97,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 32, 31, 33, 41, 40, 42, 47, 40, 33, 69, 31, 70, 75, 77, 70, 78, 77, 42,  0,  0,  0,  0,  0,  0
, 35, 34, 36, 40, 41, 42, 43, 41, 36, 64, 34, 65, 71, 78, 65, 77, 78, 42,  0,  0,  0,  0,  0,  0
, 34, 35, 36, 41, 43, 36, 44, 43, 45,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 37, 38, 39, 43, 44, 45, 46, 44, 39,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 38, 37, 39, 44, 46, 39, 47, 46, 48, 51, 37, 52, 56, 57, 48, 58, 57, 52,  0,  0,  0,  0,  0,  0
, 31, 32, 33, 40, 47, 33, 46, 47, 48, 49, 32, 50, 57, 56, 48, 62, 56, 50,  0,  0,  0,  0,  0,  0
, 33, 40, 47, 36, 41, 43, 39, 44, 46, 42, 40, 41, 45, 43, 44, 48, 46, 47,  0,  0,  0,  0,  0,  0
, 37, 51, 52, 57, 58, 52, 59, 58, 60,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 53, 54, 55, 58, 59, 60, 61, 59, 55,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 54, 53, 55, 59, 61, 55, 62, 61, 63, 81, 53, 82, 86, 87, 63, 88, 87, 82,  0,  0,  0,  0,  0,  0
, 32, 49, 50, 56, 62, 50, 61, 62, 63, 79, 49, 80, 87, 86, 63, 92, 86, 80,  0,  0,  0,  0,  0,  0
, 48, 56, 57, 50, 56, 62, 52, 57, 58, 55, 59, 61, 60, 58, 59, 63, 61, 62,  0,  0,  0,  0,  0,  0
, 34, 64, 65, 72, 71, 73, 78, 71, 65,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 67, 66, 68, 71, 72, 73, 74, 72, 68,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 66, 67, 68, 72, 74, 68, 75, 74, 76, 95, 67, 96, 99,100, 76,101,100, 96,  0,  0,  0,  0,  0,  0
, 31, 69, 70, 74, 75, 76, 77, 75, 70, 79, 69, 94,100, 99, 76,105, 99, 94,  0,  0,  0,  0,  0,  0
, 42, 77, 78, 65, 71, 78, 68, 72, 74, 70, 75, 77, 73, 71, 72, 76, 74, 75,  0,  0,  0,  0,  0,  0
, 53, 81, 82, 87, 88, 82, 89, 88, 90,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 83, 84, 85, 88, 89, 90, 91, 89, 85,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 84, 83, 85, 89, 91, 85, 92, 91, 93, 97, 83, 98,102,104, 98,105,104, 93,  0,  0,  0,  0,  0,  0
, 49, 79, 80, 69, 79, 94, 86, 92, 80, 91, 92, 93, 99,105, 94,104,105, 93,  0,  0,  0,  0,  0,  0
, 63, 86, 87, 80, 86, 92, 82, 87, 88, 85, 89, 91, 90, 88, 89, 93, 91, 92,  0,  0,  0,  0,  0,  0
, 67, 95, 96,100,101, 96,102,101,103,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 83, 97, 98,101,102,103,104,102, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 76, 99,100, 93,104,105, 94, 99,105, 96,100,101, 98,102,104,103,101,102,  0,  0,  0,  0,  0,  0
, 11, 33, 32, 21, 70, 69, 40,  6, 33, 50, 32, 49, 77,  6, 70, 80, 49, 79, 94, 69, 79,  0,  0,  0
,  6, 33, 31, 16, 50, 49, 47, 11, 33, 56, 11, 50, 70, 31, 69, 80, 49, 79, 94, 69, 79,  0,  0,  0
, 12, 47, 40, 42,  6, 40, 48, 11, 47, 49, 31, 32, 50, 11, 32, 69, 31, 32, 70,  6, 31, 79, 31, 32
,  8, 36, 35, 18, 65, 64, 41,  7, 36, 78,  7, 65,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  7, 36, 34, 43,  8, 36, 64,  1, 34,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  1, 34, 35, 12, 41, 43, 42,  7, 41, 45,  8, 43, 65,  7, 34,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  9, 39, 38, 13, 52, 51, 46, 10, 39, 57, 10, 52,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 10, 39, 37, 44,  9, 39, 51,  2, 37,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  2, 37, 38, 12, 44, 46, 45,  9, 44, 48, 10, 46, 52, 10, 37,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  7, 42, 41, 11, 33, 47, 31,  6, 33, 43, 12, 41, 46, 12, 47, 77,  6, 42,  0,  0,  0,  0,  0,  0
,  6, 42, 40,  8, 36, 43, 34,  7, 36, 44, 12, 43, 47, 12, 40, 78,  7, 42,  0,  0,  0,  0,  0,  0
, 12, 40, 41, 22, 77, 78, 33,  6, 40, 36,  7, 41, 65,  7, 78, 70,  6, 77,  0,  0,  0,  0,  0,  0
,  7, 36, 41,  9, 45, 44, 35,  8, 36, 40, 12, 41, 46, 12, 44,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  8, 45, 43, 10, 39, 46, 38,  9, 39, 41, 12, 43, 47, 12, 46,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 12, 43, 44, 36,  8, 43, 39,  9, 44,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  9, 39, 44, 11, 48, 47, 37, 10, 39, 40, 12, 47, 43, 12, 44, 57, 10, 48,  0,  0,  0,  0,  0,  0
,  6, 33, 40, 10, 48, 46, 32, 11, 33, 41, 12, 40, 44, 12, 46, 56, 11, 48,  0,  0,  0,  0,  0,  0
, 12, 46, 47, 17, 56, 57, 33, 11, 47, 39, 10, 46, 50, 11, 56, 52, 10, 57,  0,  0,  0,  0,  0,  0
, 11, 50, 32, 26, 80, 79, 33, 32, 31, 62, 16, 50, 70, 31, 69, 86, 16, 80, 94, 79, 69,  0,  0,  0
, 17, 62, 56, 31, 32, 49, 33, 11, 32, 48, 11, 56, 63, 16, 62, 69, 32, 49, 79, 32, 49, 80, 16, 49
, 10, 52, 37, 38,  2, 37, 58, 13, 52,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  2, 37, 51, 17, 57, 58, 39, 10, 37, 48, 10, 57, 60, 13, 58,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 14, 55, 54, 23, 82, 81, 61, 15, 55, 87, 15, 82,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 15, 55, 53, 59, 14, 55, 81,  3, 53,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  3, 53, 54, 17, 59, 61, 60, 14, 59, 63, 15, 61, 82, 15, 53,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 10, 48, 57, 16, 50, 62, 32, 11, 50, 47, 11, 48, 58, 17, 57, 61, 17, 62,  0,  0,  0,  0,  0,  0
, 11, 48, 56, 13, 52, 58, 37, 10, 52, 46, 10, 48, 59, 17, 58, 62, 17, 56,  0,  0,  0,  0,  0,  0
, 10, 52, 57, 14, 60, 59, 51, 13, 52, 56, 17, 57, 61, 17, 59,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 13, 60, 58, 15, 55, 61, 54, 14, 55, 57, 17, 58, 62, 17, 61,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 17, 58, 59, 52, 13, 58, 55, 14, 59,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 14, 55, 59, 16, 63, 62, 53, 15, 55, 56, 17, 62, 58, 17, 59, 87, 15, 63,  0,  0,  0,  0,  0,  0
, 11, 50, 56, 15, 63, 61, 49, 16, 50, 57, 17, 56, 59, 17, 61, 86, 16, 63,  0,  0,  0,  0,  0,  0
, 17, 61, 62, 27, 86, 87, 50, 16, 62, 55, 15, 61, 80, 16, 86, 82, 15, 87,  0,  0,  0,  0,  0,  0
,  7, 65, 34, 35,  1, 34, 71, 18, 65,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  1, 64, 34, 22, 78, 71, 36,  7, 34, 42,  7, 78, 73, 18, 71,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 20, 68, 67, 72, 19, 68, 95,  4, 67,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 19, 68, 66, 28, 96, 95, 74, 20, 68,100, 20, 96,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  4, 66, 67, 22, 72, 74, 73, 19, 72, 76, 20, 74, 96, 20, 67,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  6, 70, 31, 26, 94, 79, 33, 31, 32, 50, 32, 49, 75, 21, 70, 80, 49, 79, 99, 21, 94,  0,  0,  0
, 22, 75, 77, 32, 31, 69, 33,  6, 31, 42,  6, 77, 49, 31, 69, 76, 21, 75, 79, 31, 69, 94, 21, 69
,  7, 65, 78, 19, 73, 72, 64, 18, 65, 74, 22, 72, 77, 22, 78,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 18, 73, 71, 20, 68, 74, 66, 19, 68, 75, 22, 74, 78, 22, 71,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 22, 71, 72, 65, 18, 71, 68, 19, 72,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 19, 68, 72, 21, 76, 75, 67, 20, 68, 71, 22, 72, 77, 22, 75,100, 20, 76,  0,  0,  0,  0,  0,  0
,  6, 70, 77, 20, 76, 74, 69, 21, 70, 72, 22, 74, 78, 22, 77, 99, 21, 76,  0,  0,  0,  0,  0,  0
, 22, 74, 75, 30, 99,100, 68, 20, 74, 70, 21, 75, 94, 21, 99, 96, 20,100,  0,  0,  0,  0,  0,  0
,  7, 42, 78, 21, 70, 75, 31,  6, 70, 40,  6, 42, 71, 22, 78, 74, 22, 75,  0,  0,  0,  0,  0,  0
,  6, 42, 77, 18, 65, 71, 34,  7, 65, 41,  7, 42, 72, 22, 71, 75, 22, 77,  0,  0,  0,  0,  0,  0
, 16, 80, 49, 21, 94, 69, 33, 31, 32, 50, 32, 49, 70, 31, 69, 92, 26, 80,105, 26, 94,  0,  0,  0
, 27, 92, 86, 31, 49, 79, 32, 49, 79, 50, 16, 49, 63, 16, 86, 69, 49, 79, 93, 26, 92, 94, 26, 79
, 15, 82, 53, 54,  3, 53, 88, 23, 82,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  3, 53, 81, 27, 87, 88, 55, 15, 53, 63, 15, 87, 90, 23, 88,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 24, 85, 84, 29, 98, 97, 91, 25, 85,104, 25, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 25, 85, 83, 89, 24, 85, 97,  5, 83,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  5, 83, 84, 27, 89, 91, 90, 24, 89, 93, 25, 91, 98, 25, 83,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 15, 63, 87, 26, 80, 92, 49, 16, 80, 62, 16, 63, 88, 27, 87, 91, 27, 92,  0,  0,  0,  0,  0,  0
, 16, 63, 86, 23, 82, 88, 53, 15, 82, 61, 15, 63, 89, 27, 88, 92, 27, 86,  0,  0,  0,  0,  0,  0
, 15, 82, 87, 24, 90, 89, 81, 23, 82, 86, 27, 87, 91, 27, 89,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 23, 90, 88, 25, 85, 91, 84, 24, 85, 87, 27, 88, 92, 27, 91,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 27, 88, 89, 82, 23, 88, 85, 24, 89,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 24, 85, 89, 26, 93, 92, 83, 25, 85, 86, 27, 92, 88, 27, 89,104, 25, 93,  0,  0,  0,  0,  0,  0
, 16, 80, 86, 25, 93, 91, 79, 26, 80, 87, 27, 86, 89, 27, 91,105, 26, 93,  0,  0,  0,  0,  0,  0
, 27, 91, 92, 30,104,105, 80, 26, 92, 85, 25, 91, 94, 26,105, 98, 25,104,  0,  0,  0,  0,  0,  0
, 30,105, 99, 31, 69, 79, 32, 69, 79, 49, 69, 79, 70, 21, 69, 76, 21, 99, 80, 26, 79, 93, 26,105
, 20, 96, 67, 66,  4, 67,101, 28, 96,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  4, 67, 95, 30,100,101, 68, 20, 67, 76, 20,100,103, 28,101,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 25, 98, 83, 84,  5, 83,102, 29, 98,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
,  5, 83, 97, 30,102,104, 85, 25, 83, 93, 25,104,103, 29,102,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 20, 76,100, 26, 94,105, 69, 21, 94, 75, 21, 76,101, 30,100,104, 30,105,  0,  0,  0,  0,  0,  0
, 21, 76, 99, 28, 96,101, 67, 20, 96, 74, 20, 76,102, 30,101,105, 30, 99,  0,  0,  0,  0,  0,  0
, 20, 96,100, 29,103,102, 95, 28, 96, 99, 30,100,104, 30,102,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 25, 98,104, 28,103,101, 97, 29, 98,100, 30,101,105, 30,104,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 30,101,102, 96, 28,101, 98, 29,102,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0
, 26, 93,105, 29, 98,102, 83, 25, 98, 91, 25, 93, 99, 30,105,101, 30,102,  0,  0,  0,  0,  0,  0
, 21, 94, 99, 25, 93,104, 79, 26, 94, 92, 26, 93,100, 30, 99,102, 30,104,  0,  0,  0,  0,  0,  0};

#define N_EDGES 30
const int edges[N_EDGES] = {
 1,  2,  3,  4,  5,  8,  9, 13, 14, 18, 19, 23, 24, 28, 29, 35, 38, 45, 51, 54, 60, 64, 66, 73, 81, 84, 90, 95, 97, 103};


#endif
// star6

#endif
//y.h


