#SBATCH --time=0-00:08:00
#SBATCH -p play
# c #SBATCH --time=0-12:00:00
# c #SBATCH -p batch
# c #SBATCH --time=0-00:15:00
# c #SBATCH -p short
#SBATCH -o evolution_output1.txt
#SBATCH -e evolution_error1.txt
# c #SBATCH --qos short
# a #SBATCH -p largemem
# a #SBATCH --mem-per-cpu=6000
## rbatch

## Give fixed parameters that define the simulation setup

# this "if" is here because it allows hiding stuff in kate...
if (TRUE) {
	
	methods.to.run <- c('simulation','distances','ecoSNP.statistics')
	simulation.name <- 'test_run_2_6_2016'
}


## give parameters / other things which are varied in a grid

# this "if" is here because it allows hiding stuff in kate...


## paths and files
# this "if" is here because it allows hiding stuff in kate...
if (TRUE) {

	root <- '/m/cs/scratch/mi/pemartti/CCDD/PopSim/codes/niche_separation/to_publish'

}




	############################################
	## Code for actual operations starts here ##
	############################################
	
	source(paste(root, '/fast_evolution_functions.R', sep=''))
	source(paste(root, '/niche_summary_functions.R', sep=''))
	source(paste(root, '/analytical_functions.R', sep=''))
	require(gdata) # upperTriangle
	
	# Create a directory for simulation.name if it does not exist:
	res.dir.name <- paste(root, '/Results/', simulation.name, sep='')
	if (!file.exists(res.dir.name)) {
		dir.create(res.dir.name)
		dir.create(paste(res.dir.name, '/saved_genes', sep=''))
		dir.create(paste(res.dir.name, '/distances', sep=''))
		dir.create(paste(res.dir.name, '/genewise', sep=''))
		dir.create(paste(res.dir.name, '/locus_correlations', sep=''))
		dir.create(paste(res.dir.name, '/analytical', sep=''))
	}
	

	
	###################################
	## PARAMETERS FOR THE SIMULATION ##
	###################################
	
	n.generations <- 10#0000
	n.strain.types <- c('A'=5000, 'B'=5000)
	# How many strains in enviroments A/B. (niche.overlap specifies the same number for AB)
	
	niche.overlap <- 4000
	
	migration <- 0.5
	
	first.generation.for.summaries <- 2#10000 # Burn-in
	
	# The number of core genes for which detailed evolution is simulated.
	# Set this to zero, if only gene presence/absence pattern is to be
	# simulated.
	n.core.genes.to.simulate <- 40
	
	# Length of a single gene in base pairs
	gene.length <- 500
	
	# Mean number of strains that mutate per generation per gene
	mutation.rate <- 2.4
	
	# Mean number of homologous recombination event 
	# attempts per generation per gene
	recombination.rate <- 28
	
	# Parameter to determine whether a recombination is accepted.
	# Acceptance probability 10^(-Ax), x the Hamming distance between the
	# old and new alleles.
	recombination.acceptance.par <- 18
	
	
	# Parameters related to saving etc.
	save.interval <- 5#000
	
	save.extension <- '_test'
	
	save(simulation.name, n.generations, n.strain.types, first.generation.for.summaries, n.core.genes.to.simulate, gene.length, mutation.rate, recombination.rate, recombination.acceptance.par, niche.overlap, migration, save.interval, file=paste(res.dir.name, '/', simulation.name, '_pars.RData', sep=''))
	
	
	####################
	## Run simulation ##
	####################	
	if (any(methods.to.run=='simulation')) {
		save.path <- paste(root, '/Results/', simulation.name, '/saved_genes', sep='')
		population <- NULL
		start.generation <- 1
		
		if (start.generation<n.generations) {
			run.evolution(simulation.name=simulation.name, n.generations=n.generations, n.strain.types=n.strain.types, n.core.genes.to.simulate=n.core.genes.to.simulate, gene.length=gene.length, mutation.rate=mutation.rate, recombination.rate=recombination.rate, recombination.acceptance.par=recombination.acceptance.par, niche.overlap=niche.overlap, migration=migration, save.interval=save.interval, save.path=save.path, save.extension=save.extension, print.output=TRUE, population=population, start.generation=start.generation)
		}
	}
	
	
	#######################
	## Compute distances ##
	#######################	
	if (any(methods.to.run=='distances')) {
		
		# Number of strains per group between which distances are computed
		n.strains.per.group <- 100
		
		compute.niche.distances.over.whole.simulation(n.generations=n.generations, save.interval=save.interval, n.strains.per.group=n.strains.per.group, root=root, simulation.name=simulation.name, save.extension=save.extension)
		
	}
	
	
	
	###############################
	## Compute ecoSNP statistics ##
	###############################
	if (any(methods.to.run=='ecoSNP.statistics')) {
		
		# Specify sizes of the clusters in the real data. These will be taken into account when computing ecoSNP probabilities in the simulation.
		sample.sizes <- c(606,10)
		names(sample.sizes) <- c('A','B')
		
		file.extension <- 'test' # This can be used to specify the suffix of the output file
		
		identify.ecoSNPs(n.generations=n.generations, save.interval=save.interval, root=root, simulation.name=simulation.name, parameters=file.extension, result.dir.name='/Results', sample.sizes=sample.sizes)
		
	}
	
	
	##########################################
	## Compute analytical equilibrium state ##
	##########################################
	if (any(methods.to.run=='analytical')) {
		
		result.path <- paste(root, '/Results/', simulation.name, '/analytical', sep='')
		
		res <- optimize.analytical.model(niche.overlap=niche.overlap, migration=migration, mutation.rate=mutation.rate, n.genes=n.genes, gene.length=gene.length, recombination.rate=recombination.rate, recombination.acceptance.par=recombination.acceptance.par, n.strain.types=n.strain.types)
		
		dist.now <- res$dist.learned
		converged <- res$converged
		
		save(dist.now, converged, file=paste(result.path, '/analytical', save.extension, '.RData', sep=''))
	}
	
	
	
	##########################
	## Learn the shape of   ##
	## the equilibrium mode ##
	##########################
	if (any(methods.to.run=='mode.shape')) {
		
		result.path <- paste(root, '/Results/', simulation.name, '/mode_shape', sep='')
		max.dist <- 0.15
		dist.interval <- 0.002
		
		between.dist.change <- learn.the.shape.of.the.mode(niche.overlap=niche.overlap, migration=migration, mutation.rate=mutation.rate, n.genes=n.genes, gene.length=gene.length, recombination.rate=recombination.rate, recombination.acceptance.par=recombination.acceptance.par, n.strain.types=n.strain.types, max.dist=max.dist, dist.interval=dist.interval)
		
		names(between.dist.change) <- seq(dist.interval, max.dist, by=dist.interval)
		save(between.dist.change, file=paste(result.path, '/mode_shape', save.extension, '.RData', sep=''))
		
	}
	
