get.feature.cols <- function(gene.indexes, n.features.per.gene) {
	feature.cols <- (gene.indexes-1)*n.features.per.gene + 1
	feature.cols <- rep(feature.cols, each=n.features.per.gene) + seq(0, n.features.per.gene-1)
	
	return(feature.cols)
}



remove.empty.genes <- function(pop) {
	# Remove genes which are not present in any strain.
	
	genes.to.remove <- which(colSums(pop$gene.indicators)==0)	
	
	if (length(genes.to.remove) > 0) {
		
		pop$gene.indicators <- pop$gene.indicators[,-genes.to.remove,drop=F]
		if (ncol(pop$gene.indicators)==0) {
			stop('All genes removed')
		}
		
	}
	
	return(pop)
}





calculate.divergence <- function(gene.index, pop, n.features.per.gene, recipient, donor) {
	# Calculates Hamming distance divided by the length of the sequence 
	# between two recipient and donor.
	
	sites.to.consider <- get.feature.cols(gene.indexes=gene.index, n.features.per.gene=n.features.per.gene)
	
	block.distance <- sum(abs(pop$core.genes[recipient,sites.to.consider]-pop$core.genes[donor,sites.to.consider]))
	
	divergence <- pop$block.to.hamming[block.distance+1]
	
	return(divergence)
}


calculate.core.hamming <- function(pop, n.features.per.gene, recipient, donor) {
	
	block.distances.per.gene <- rowSums(matrix(abs(pop$core.genes[recipient,]-pop$core.genes[donor,]),ncol=n.features.per.gene, byrow=T))
						
	core.hamming <- mean(pop$block.to.hamming[block.distances.per.gene+1])
	
	return(core.hamming)
}