test.mvr.norm.own <- function() {
	d <- 1000
	aux <- rnorm(n=d)
	Sigma <- tcrossprod(aux) + 2*diag(d)

	n.reps <- 20


	tX <- proc.time()[3]
	val <- matrix(NA, nrow=n.reps, ncol=d)
	for (i in 1:n.reps) {
		val[i,] <- mvr.norm.own(0, Sigma)
	}
	tY <- proc.time()[3]
	print(paste('Own: ', tY-tX, sep=''))

	tX <- proc.time()[3]
	val <- matrix(NA, nrow=n.reps, ncol=d)
	mu <- rep(0,d)
	for (i in 1:n.reps) {
		val[i,] <- mvrnorm(n=1, mu=mu, Sigma=Sigma)
	}
	tY <- proc.time()[3]
	print(paste('Orig: ', tY-tX, sep=''))
	

	return(list(val=val, Sigma=Sigma))
}

mvr.norm.own <- function(mu, Sigma) {
	d <- nrow(Sigma)
	A <- t(chol(Sigma))
	z <- rnorm(n=d)
	val <- mu + A %*% z
	return(val)
}

log.mvr.density.proportional.own <- function(x, mu, Sigma) {

	d <- length(mu)
	#log.density <- -d/2*log(2*pi) - 0.5*determinant(Sigma, logarithm=TRUE)$modulus[1] -0.5 * t(x - mu) %*% chol2inv(chol(Sigma)) %*% (x-mu)

	log.density <- t(x - mu) %*% chol2inv(chol(Sigma)) %*% (x-mu)

	return(as.vector(log.density))
}
