function plotPSA(rootDirectory, datasetName, treeFileName, profilesWidth)
    
    if nargin == 3
        profilesWidth = 4;
    end
    
    delimiter = getDelimiter;
    rootToSummaries = [rootDirectory datasetName 'Summaries' delimiter];
    
    treeFileWithPath = [rootToSummaries delimiter treeFileName];
    
    leafNames = initializeThePlot(treeFileWithPath);
    % Here "leafNames" is ordered s.t. leafNames{1} is the name that will
    % be at the bottom in the plot.
    nStrains = length(leafNames);
    
    load([rootToSummaries delimiter 'globalNames.mat']);
    load([rootToSummaries delimiter 'proportionSharedAncestry.mat']);
    
    % Check if the given tree is a subtree whose leaf names are a subset of
    % globalNames, which contains the leaf names of the full tree.
    [~, globalNamePositions] = ismember(leafNames, globalNames);
    
    xLimOrig = get(gca,'XLim');
    annotationSpaceOnLeft = 0.1;
    phyloEnd = xLimOrig(2);
    
    segmentStart = phyloEnd + (xLimOrig(2)-xLimOrig(1)) .* annotationSpaceOnLeft;
    emptySpaceLength = (xLimOrig(2) - xLimOrig(1)) .* (profilesWidth + 0.15);
    segmentEnd = segmentStart + (xLimOrig(2) - xLimOrig(1)) .* profilesWidth;
    set(gca,'XLim',[xLimOrig(1) segmentStart + emptySpaceLength]);
    
    emptySpaceAtBottom = 0.05;
    yLim = get(gca,'YLim');
    spaceToAddToBottom = (yLim(2) - yLim(1)) * emptySpaceAtBottom;
    yLim(2) = yLim(2) + spaceToAddToBottom;
    set(gca, 'YLim', yLim, 'XTick', []);
    
    %keyboard
    %hCol = colorbar('southoutside', 'Position', [0.75 0.08 0.15 0.01]);

    % ADD PROPORTION SHARED ANCESTRY HEATMAP IMAGE
    globalRecombinationFlow = globalLengthShared ./ globalLengthCompared;

    globalRecombinationFlow(isnan(globalRecombinationFlow)) = 0;
    globalRecombinationFlow = globalRecombinationFlow + globalRecombinationFlow';
    globalRecombinationFlow = globalRecombinationFlow + eye(size(globalRecombinationFlow,1));
    
    aux = globalRecombinationFlow(globalNamePositions,globalNamePositions);
    globalRecombinationFlow = aux;
    globalRecombinationFlow = globalRecombinationFlow';
    hold on
    image([segmentStart segmentEnd], [0.5 nStrains+0.5], globalRecombinationFlow, 'CDataMapping', 'scaled');
    
    %keyboard
    hCol = colorbar('southoutside', 'Position', [0.75 0.08 0.15 0.01]);
end