function ancestralSeq = createAncestralSequences(uData, forLineages)
% If "forLineages" is true, then ancestral sequences for lineages are
% identified.
%
% Recent recombinations are always removed before inferring ancestral
% sequences. A locus in which no observations remain, after the recent
% recombinations have been removed, will get value "9".

if forLineages
    partition = uData.groupedPartition;
else
    partition = uData.partition;
end

nSnps = length(uData.snpPositions);
nClusters = length(unique(partition));

ancestralSeq = zeros(nClusters,nSnps);

load(uData.snpDataFileName); % Variable snpData


% Mark as missing all recent recombinations
nSnps = length(uData.snpPositions);
structureWithoutRecentRecombinations = uint8(repmat(uData.groupedPartition, [1 nSnps]));
recentRecombinationInds = find(structureWithoutRecentRecombinations ~= uData.updatedPopStructure);
snpData(recentRecombinationInds) = 9; % The value indicates a recent recombination event


for clusterIndex = 1:nClusters

    inds = find(partition == clusterIndex);
    clusterSequences = snpData(inds,:);

    for snpIndex = 1:nSnps
        observations = clusterSequences(:,snpIndex);
        observations = setdiff(observations, 9); % Remove observations in recent recombinations
        if ~isempty(observations)
            alleles = unique(observations);
            alleleCounts = histc(observations, alleles);
            [maxValue,maxIndex] = max(alleleCounts);
            ancestralSeq(clusterIndex, snpIndex) = alleles(maxIndex);
        else
            ancestralSeq(clusterIndex, snpIndex) = 9; % This value indicates that nothing is known of the ancestral sequences
        end
    end

end
