function popStructureToPlot = formulatePopStructureToPlot(uData, recombinationType)
    % recombinationType: 'recent', 'ancestral', 'both'
    
    if isequal(recombinationType, 'recent')
        popStructureToPlot = uData.popStructureCleaned;
        
    else
        
        popStructureToPlot = derivePopStructureFromLineageStructure(uData, 2);
        % The 2nd argument indicates that a population structure based on
        % "lineageStructureCleaned" should be formulated.
        
        % Mark as missing all recent recombinations
        nSnps = length(uData.snpPositions);
        lineageStructureWithoutRecentRecombinations = uint8(repmat(uData.groupedPartition, [1 nSnps]));
        recentRecombinationInds = find(lineageStructureWithoutRecentRecombinations ~= uData.popStructureCleaned);
        
        nLineages = max(uData.groupedPartition);
        
        if isequal(recombinationType, 'ancestral')
            popStructureToPlot(recentRecombinationInds) = nLineages + 2; % nLineages+1 is black, nLineages+2 is white.
        elseif isequal(recombinationType, 'both')
            popStructureToPlot(recentRecombinationInds) = uData.popStructureCleaned(recentRecombinationInds);
        end
        
    end
    
end