function segments = findRecombAreasForStrain(marginals, snpPositions, home, probLimit)
% The function identifies recombinant areas for the strain corresponding to
% "marginals". The home cluster of the strain is "home". Recombinant
% areas are those with home cluster probability less than "probLimit".

segments = zeros(size(marginals,2),3);  % columns: start, end, origin
nRecombinantSegments = 0;

[maxProb, maxProbOrigin] = max(marginals);
homeProb = marginals(home,:);

recombinantSnps = find(homeProb<probLimit);
if ~isempty(recombinantSnps)
    firstSnpOfSegment = recombinantSnps(1);
    for recombSnpIndex = 2:length(recombinantSnps)
        if recombinantSnps(recombSnpIndex)-recombinantSnps(recombSnpIndex-1)>1 ...
                || ~isequal(maxProbOrigin(recombinantSnps(recombSnpIndex)), ...
                maxProbOrigin(recombinantSnps(recombSnpIndex-1)))
            nRecombinantSegments = nRecombinantSegments+1;
            lastSnpOfSegment = recombinantSnps(recombSnpIndex-1);
            startPosition = snpPositions(firstSnpOfSegment);
            endPosition = snpPositions(lastSnpOfSegment);
            segments(nRecombinantSegments,:) = [startPosition endPosition maxProbOrigin(firstSnpOfSegment)];
            firstSnpOfSegment = recombinantSnps(recombSnpIndex);
        end
    end
    nRecombinantSegments = nRecombinantSegments+1;
    lastSnpOfSegment = recombinantSnps(end);
    startPosition = snpPositions(firstSnpOfSegment);
    endPosition = snpPositions(lastSnpOfSegment);
    segments(nRecombinantSegments,:) = [startPosition endPosition maxProbOrigin(firstSnpOfSegment)];
end

segments = segments(1:nRecombinantSegments,:);