function drawRecombinations(uData)

figure
[H,T,perm,cmapDontUse] = dendrogramOwn(uData.Z,0,'colorthreshold', ...
    uData.cutoff,'Orientation','left');
set(gca,'YTick',[]);
line([uData.cutoff uData.cutoff],get(gca,'YLim'),'LineStyle',':');

maxNClusters = max(max(uData.popStructureCleaned));
addRecombProfilesToDendrogram(gca, uData.popStructureCleaned, perm, ...
    hsv(maxNClusters), uData.partition, uData.snpPositions, uData.cutoff, ...
    uData.totalSequenceLength, ...
    determineTickLocations(uData.totalSequenceLength),[], ...
    uData.transPars.home,6, uData.snpData<0);
set(gca,'Box','on');