function tickInfo = determineTicks(segmentStart, segmentEnd, totalSequenceLength)

possibleIntervals = [10, 20, 50, 100, 200, 500, 1000, 2000, 5000, 10000, ...
    20000, 50000, 100000, 200000, 500000, 1000000, 2000000];

nPossibleIntervals = floor(totalSequenceLength ./ possibleIntervals);

[~,indexToUse] = min(abs(nPossibleIntervals - 5));
% Try to find a length s.t. the number of intervals to show is around 5.

intervalLength = possibleIntervals(indexToUse);
locationsOnSequenceScale = 0:intervalLength:totalSequenceLength;

tickInfo.locations = segmentStart + locationsOnSequenceScale ./ totalSequenceLength .* (segmentEnd - segmentStart);
tickInfo.values = locationsOnSequenceScale;